/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.AlterPartitionOperation;

public class AlterPartitionPropertiesOperation
extends AlterPartitionOperation {
    private final CatalogPartition catalogPartition;

    public AlterPartitionPropertiesOperation(ObjectIdentifier tableIdentifier, CatalogPartitionSpec partitionSpec, CatalogPartition catalogPartition) {
        super(tableIdentifier, partitionSpec);
        this.catalogPartition = catalogPartition;
    }

    public CatalogPartition getCatalogPartition() {
        return this.catalogPartition;
    }

    @Override
    public String asSummaryString() {
        String spec = OperationUtils.formatPartitionSpec(this.partitionSpec);
        String properties = OperationUtils.formatProperties(this.catalogPartition.getProperties());
        return String.format("ALTER TABLE %s PARTITION (%s) SET (%s)", this.tableIdentifier.asSummaryString(), spec, properties);
    }
}

