/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class DecimalData
implements Comparable<DecimalData> {
    static final int MAX_COMPACT_PRECISION = 18;
    static final int MAX_INT_DIGITS = 9;
    static final int MAX_LONG_DIGITS = 18;
    static final long[] POW10 = new long[19];
    final int precision;
    final int scale;
    final long longVal;
    BigDecimal decimalVal;

    DecimalData(int precision, int scale, long longVal, BigDecimal decimalVal) {
        this.precision = precision;
        this.scale = scale;
        this.longVal = longVal;
        this.decimalVal = decimalVal;
    }

    public int precision() {
        return this.precision;
    }

    public int scale() {
        return this.scale;
    }

    public BigDecimal toBigDecimal() {
        BigDecimal bd = this.decimalVal;
        if (bd == null) {
            this.decimalVal = bd = BigDecimal.valueOf(this.longVal, this.scale);
        }
        return bd;
    }

    public long toUnscaledLong() {
        if (this.isCompact()) {
            return this.longVal;
        }
        return this.toBigDecimal().unscaledValue().longValueExact();
    }

    public byte[] toUnscaledBytes() {
        return this.toBigDecimal().unscaledValue().toByteArray();
    }

    public boolean isCompact() {
        return this.precision <= 18;
    }

    public DecimalData copy() {
        return new DecimalData(this.precision, this.scale, this.longVal, this.decimalVal);
    }

    public int hashCode() {
        return this.toBigDecimal().hashCode();
    }

    @Override
    public int compareTo(@Nonnull DecimalData that) {
        if (this.isCompact() && that.isCompact() && this.scale == that.scale) {
            return Long.compare(this.longVal, that.longVal);
        }
        return this.toBigDecimal().compareTo(that.toBigDecimal());
    }

    public boolean equals(Object o) {
        if (!(o instanceof DecimalData)) {
            return false;
        }
        DecimalData that = (DecimalData)o;
        return this.compareTo(that) == 0;
    }

    public String toString() {
        return this.toBigDecimal().toPlainString();
    }

    @Nullable
    public static DecimalData fromBigDecimal(BigDecimal bd, int precision, int scale) {
        if ((bd = bd.setScale(scale, RoundingMode.HALF_UP)).precision() > precision) {
            return null;
        }
        long longVal = -1L;
        if (precision <= 18) {
            longVal = bd.movePointRight(scale).longValueExact();
        }
        return new DecimalData(precision, scale, longVal, bd);
    }

    public static DecimalData fromUnscaledLong(long unscaledLong, int precision, int scale) {
        Preconditions.checkArgument((precision > 0 && precision <= 18 ? 1 : 0) != 0);
        return new DecimalData(precision, scale, unscaledLong, null);
    }

    public static DecimalData fromUnscaledBytes(byte[] unscaledBytes, int precision, int scale) {
        BigDecimal bd = new BigDecimal(new BigInteger(unscaledBytes), scale);
        return DecimalData.fromBigDecimal(bd, precision, scale);
    }

    @Nullable
    public static DecimalData zero(int precision, int scale) {
        if (precision <= 18) {
            return new DecimalData(precision, scale, 0L, null);
        }
        return DecimalData.fromBigDecimal(BigDecimal.ZERO, precision, scale);
    }

    public static boolean isCompact(int precision) {
        return precision <= 18;
    }

    static {
        DecimalData.POW10[0] = 1L;
        for (int i = 1; i < POW10.length; ++i) {
            DecimalData.POW10[i] = 10L * POW10[i - 1];
        }
    }
}

