/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import java.util.List;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.AnalyticType;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.KeepExpression;
import net.sf.jsqlparser.expression.WindowDefinition;
import net.sf.jsqlparser.expression.WindowElement;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import net.sf.jsqlparser.statement.select.OrderByElement;

public class AnalyticExpression
extends ASTNodeAccessImpl
implements Expression {
    private String name;
    private Expression expression;
    private Expression offset;
    private Expression defaultValue;
    private boolean allColumns = false;
    private KeepExpression keep = null;
    private AnalyticType type = AnalyticType.OVER;
    private boolean distinct = false;
    private boolean unique = false;
    private boolean ignoreNulls = false;
    private boolean ignoreNullsOutside = false;
    private Expression filterExpression = null;
    private List<OrderByElement> funcOrderBy = null;
    private String windowName = null;
    private WindowDefinition windowDef = new WindowDefinition();

    public AnalyticExpression() {
    }

    public AnalyticExpression(Function function) {
        this.name = function.getName();
        this.allColumns = function.isAllColumns();
        this.distinct = function.isDistinct();
        this.unique = function.isUnique();
        this.funcOrderBy = function.getOrderByElements();
        ExpressionList list = function.getParameters();
        if (list != null) {
            if (list.getExpressions().size() > 3) {
                throw new IllegalArgumentException("function object not valid to initialize analytic expression");
            }
            this.expression = list.getExpressions().get(0);
            if (list.getExpressions().size() > 1) {
                this.offset = list.getExpressions().get(1);
            }
            if (list.getExpressions().size() > 2) {
                this.defaultValue = list.getExpressions().get(2);
            }
        }
        this.ignoreNulls = function.isIgnoreNulls();
        this.keep = function.getKeep();
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public List<OrderByElement> getOrderByElements() {
        return this.windowDef.orderBy.getOrderByElements();
    }

    public void setOrderByElements(List<OrderByElement> orderByElements) {
        this.windowDef.orderBy.setOrderByElements(orderByElements);
    }

    public KeepExpression getKeep() {
        return this.keep;
    }

    public void setKeep(KeepExpression keep) {
        this.keep = keep;
    }

    public ExpressionList getPartitionExpressionList() {
        return this.windowDef.partitionBy.getPartitionExpressionList();
    }

    public void setPartitionExpressionList(ExpressionList partitionExpressionList) {
        this.setPartitionExpressionList(partitionExpressionList, false);
    }

    public void setPartitionExpressionList(ExpressionList partitionExpressionList, boolean brackets) {
        this.windowDef.partitionBy.setPartitionExpressionList(partitionExpressionList, brackets);
    }

    public boolean isPartitionByBrackets() {
        return this.windowDef.partitionBy.isBrackets();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Expression getOffset() {
        return this.offset;
    }

    public void setOffset(Expression offset) {
        this.offset = offset;
    }

    public Expression getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Expression defaultValue) {
        this.defaultValue = defaultValue;
    }

    public WindowElement getWindowElement() {
        return this.windowDef.windowElement;
    }

    public void setWindowElement(WindowElement windowElement) {
        this.windowDef.windowElement = windowElement;
    }

    public AnalyticType getType() {
        return this.type;
    }

    public void setType(AnalyticType type) {
        this.type = type;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public boolean isIgnoreNulls() {
        return this.ignoreNulls;
    }

    public void setIgnoreNulls(boolean ignoreNulls) {
        this.ignoreNulls = ignoreNulls;
    }

    public boolean isIgnoreNullsOutside() {
        return this.ignoreNullsOutside;
    }

    public void setIgnoreNullsOutside(boolean ignoreNullsOutside) {
        this.ignoreNullsOutside = ignoreNullsOutside;
    }

    public String getWindowName() {
        return this.windowName;
    }

    public void setWindowName(String windowName) {
        this.windowName = windowName;
    }

    public WindowDefinition getWindowDefinition() {
        return this.windowDef;
    }

    public void setWindowDefinition(WindowDefinition windowDef) {
        this.windowDef = windowDef;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.name).append("(");
        if (this.isDistinct()) {
            b.append("DISTINCT ");
        }
        if (this.expression != null) {
            b.append(this.expression.toString());
            if (this.offset != null) {
                b.append(", ").append(this.offset.toString());
                if (this.defaultValue != null) {
                    b.append(", ").append(this.defaultValue.toString());
                }
            }
        } else if (this.isAllColumns()) {
            b.append("*");
        }
        if (this.isIgnoreNulls()) {
            b.append(" IGNORE NULLS");
        }
        if (this.funcOrderBy != null) {
            b.append(" ORDER BY ");
            b.append(this.funcOrderBy.stream().map(OrderByElement::toString).collect(Collectors.joining(", ")));
        }
        b.append(") ");
        if (this.keep != null) {
            b.append(this.keep.toString()).append(" ");
        }
        if (this.filterExpression != null) {
            b.append("FILTER (WHERE ");
            b.append(this.filterExpression.toString());
            b.append(")");
            if (this.type != AnalyticType.FILTER_ONLY) {
                b.append(" ");
            }
        }
        if (this.isIgnoreNullsOutside()) {
            b.append("IGNORE NULLS ");
        }
        switch (this.type) {
            case FILTER_ONLY: {
                return b.toString();
            }
            case WITHIN_GROUP: {
                b.append("WITHIN GROUP");
                break;
            }
            case WITHIN_GROUP_OVER: {
                b.append("WITHIN GROUP (");
                this.windowDef.orderBy.toStringOrderByElements(b);
                b.append(") OVER (");
                this.windowDef.partitionBy.toStringPartitionBy(b);
                b.append(")");
                break;
            }
            default: {
                b.append("OVER");
            }
        }
        if (this.windowName != null) {
            b.append(" ").append(this.windowName);
        } else if (this.type != AnalyticType.WITHIN_GROUP_OVER) {
            b.append(" ");
            b.append(this.windowDef.toString());
        }
        return b.toString();
    }

    public boolean isAllColumns() {
        return this.allColumns;
    }

    public void setAllColumns(boolean allColumns) {
        this.allColumns = allColumns;
    }

    public Expression getFilterExpression() {
        return this.filterExpression;
    }

    public void setFilterExpression(Expression filterExpression) {
        this.filterExpression = filterExpression;
    }

    public AnalyticExpression withName(String name) {
        this.setName(name);
        return this;
    }

    public AnalyticExpression withExpression(Expression expression) {
        this.setExpression(expression);
        return this;
    }

    public AnalyticExpression withOffset(Expression offset) {
        this.setOffset(offset);
        return this;
    }

    public AnalyticExpression withDefaultValue(Expression defaultValue) {
        this.setDefaultValue(defaultValue);
        return this;
    }

    public AnalyticExpression withAllColumns(boolean allColumns) {
        this.setAllColumns(allColumns);
        return this;
    }

    public AnalyticExpression withKeep(KeepExpression keep) {
        this.setKeep(keep);
        return this;
    }

    public AnalyticExpression withType(AnalyticType type) {
        this.setType(type);
        return this;
    }

    public AnalyticExpression withDistinct(boolean distinct) {
        this.setDistinct(distinct);
        return this;
    }

    public AnalyticExpression withUnique(boolean unique) {
        this.setUnique(unique);
        return this;
    }

    public AnalyticExpression withIgnoreNulls(boolean ignoreNulls) {
        this.setIgnoreNulls(ignoreNulls);
        return this;
    }

    public AnalyticExpression withFilterExpression(Expression filterExpression) {
        this.setFilterExpression(filterExpression);
        return this;
    }

    public AnalyticExpression withWindowElement(WindowElement windowElement) {
        this.setWindowElement(windowElement);
        return this;
    }

    public <E extends Expression> E getExpression(Class<E> type) {
        return (E)((Expression)type.cast(this.getExpression()));
    }

    public <E extends Expression> E getOffset(Class<E> type) {
        return (E)((Expression)type.cast(this.getOffset()));
    }

    public <E extends Expression> E getDefaultValue(Class<E> type) {
        return (E)((Expression)type.cast(this.getDefaultValue()));
    }

    public <E extends Expression> E getFilterExpression(Class<E> type) {
        return (E)((Expression)type.cast(this.getFilterExpression()));
    }

    public List<OrderByElement> getFuncOrderBy() {
        return this.funcOrderBy;
    }

    public void setFuncOrderBy(List<OrderByElement> funcOrderBy) {
        this.funcOrderBy = funcOrderBy;
    }
}

