/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.db.CommandEntity;
import org.apache.inlong.common.enums.PullJobTypeEnum;
import org.apache.inlong.common.enums.TaskStateEnum;
import org.apache.inlong.common.enums.TaskTypeEnum;
import org.apache.inlong.common.pojo.agent.AgentConfigInfo;
import org.apache.inlong.common.pojo.agent.AgentConfigRequest;
import org.apache.inlong.common.pojo.agent.AgentResponseCode;
import org.apache.inlong.common.pojo.agent.CmdConfig;
import org.apache.inlong.common.pojo.agent.DataConfig;
import org.apache.inlong.common.pojo.agent.TaskRequest;
import org.apache.inlong.common.pojo.agent.TaskResult;
import org.apache.inlong.common.pojo.agent.TaskSnapshotRequest;
import org.apache.inlong.common.pojo.agent.installer.ConfigRequest;
import org.apache.inlong.common.pojo.agent.installer.ConfigResult;
import org.apache.inlong.common.pojo.agent.installer.ModuleConfig;
import org.apache.inlong.common.pojo.agent.installer.PackageConfig;
import org.apache.inlong.common.pojo.dataproxy.DataProxyTopicInfo;
import org.apache.inlong.common.pojo.dataproxy.MQClusterInfo;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.consts.SourceType;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.enums.ModuleType;
import org.apache.inlong.manager.common.enums.SourceStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.AgentTaskConfigEntity;
import org.apache.inlong.manager.dao.entity.InlongClusterEntity;
import org.apache.inlong.manager.dao.entity.InlongClusterNodeEntity;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.entity.InlongStreamEntity;
import org.apache.inlong.manager.dao.entity.ModuleConfigEntity;
import org.apache.inlong.manager.dao.entity.PackageConfigEntity;
import org.apache.inlong.manager.dao.entity.StreamSourceEntity;
import org.apache.inlong.manager.dao.mapper.DataSourceCmdConfigEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongClusterEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongClusterNodeEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongStreamEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamSourceEntityMapper;
import org.apache.inlong.manager.pojo.cluster.ClusterPageRequest;
import org.apache.inlong.manager.pojo.cluster.agent.AgentClusterNodeBindGroupRequest;
import org.apache.inlong.manager.pojo.cluster.agent.AgentClusterNodeDTO;
import org.apache.inlong.manager.pojo.cluster.pulsar.PulsarClusterDTO;
import org.apache.inlong.manager.pojo.group.pulsar.InlongPulsarDTO;
import org.apache.inlong.manager.pojo.module.ModuleDTO;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.source.file.FileSourceDTO;
import org.apache.inlong.manager.pojo.stream.InlongStreamExtParam;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.service.cluster.node.AgentClusterNodeOperator;
import org.apache.inlong.manager.service.core.AgentService;
import org.apache.inlong.manager.service.core.ConfigLoader;
import org.apache.inlong.manager.service.source.SourceOperatorFactory;
import org.apache.inlong.manager.service.source.SourceSnapshotOperator;
import org.apache.inlong.manager.service.source.StreamSourceOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AgentServiceImpl
implements AgentService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentServiceImpl.class);
    private static final int UNISSUED_STATUS = 2;
    private static final int ISSUED_STATUS = 3;
    private static final int MODULUS_100 = 100;
    private static final int TASK_FETCH_SIZE = 2;
    private static final Gson GSON = new Gson();
    private final LinkedBlockingQueue<ConfigRequest> updateModuleConfigQueue = new LinkedBlockingQueue();
    private Map<String, TaskResult> taskConfigMap = new ConcurrentHashMap<String, TaskResult>();
    private Map<String, AgentConfigInfo> agentConfigMap = new ConcurrentHashMap<String, AgentConfigInfo>();
    private Map<Integer, ModuleConfig> moduleConfigMap = new ConcurrentHashMap<Integer, ModuleConfig>();
    private Map<String, ConfigResult> installerConfigMap = new ConcurrentHashMap<String, ConfigResult>();
    @Value(value="${source.update.enabled:false}")
    private Boolean updateTaskTimeoutEnabled;
    @Value(value="${source.update.before.seconds:60}")
    private Integer beforeSeconds;
    @Value(value="${source.update.interval:60}")
    private Integer updateTaskInterval;
    @Value(value="${source.clean.enabled:false}")
    private Boolean sourceCleanEnabled;
    @Value(value="${source.clean.interval.seconds:600}")
    private Integer cleanInterval;
    @Value(value="${add.task.clean.enabled:false}")
    private Boolean dataAddTaskCleanEnabled;
    @Value(value="${add.task.clean.interval.seconds:10}")
    private Integer dataAddTaskCleanInterval;
    @Value(value="${add.task.retention.days:7}")
    private Integer retentionDays;
    @Value(value="${default.module.id:1}")
    private Integer defaultModuleId;
    @Autowired
    private StreamSourceEntityMapper sourceMapper;
    @Autowired
    private SourceSnapshotOperator snapshotOperator;
    @Autowired
    private DataSourceCmdConfigEntityMapper sourceCmdConfigMapper;
    @Autowired
    private InlongGroupEntityMapper groupMapper;
    @Autowired
    private InlongStreamEntityMapper streamMapper;
    @Autowired
    private InlongClusterEntityMapper clusterMapper;
    @Autowired
    private InlongClusterNodeEntityMapper clusterNodeMapper;
    @Autowired
    private SourceOperatorFactory operatorFactory;
    @Autowired
    private AgentClusterNodeOperator agentClusterNodeOperator;
    @Autowired
    private ConfigLoader configLoader;

    @PostConstruct
    private void startHeartbeatTask() {
        ScheduledExecutorService executor;
        ThreadFactory factory;
        try {
            this.reload();
            this.setReloadTimer();
        }
        catch (Exception e) {
            LOGGER.error("load agent task config failed", (Throwable)e);
        }
        LOGGER.debug("end to reload config for installer");
        if (this.updateTaskTimeoutEnabled.booleanValue()) {
            factory = new ThreadFactoryBuilder().setNameFormat("scheduled-source-timeout-%d").setDaemon(true).build();
            executor = Executors.newSingleThreadScheduledExecutor(factory);
            executor.scheduleWithFixedDelay(() -> {
                try {
                    this.sourceMapper.updateStatusToTimeout(this.beforeSeconds);
                    LOGGER.info("update task status successfully");
                }
                catch (Throwable t) {
                    LOGGER.error("update task status error", t);
                }
            }, 0L, this.updateTaskInterval.intValue(), TimeUnit.SECONDS);
            LOGGER.info("update task status started successfully");
        }
        if (this.sourceCleanEnabled.booleanValue()) {
            factory = new ThreadFactoryBuilder().setNameFormat("scheduled-source-deleted-%d").setDaemon(true).build();
            executor = Executors.newSingleThreadScheduledExecutor(factory);
            executor.scheduleWithFixedDelay(() -> {
                try {
                    this.sourceMapper.updateStatusByDeleted();
                    LOGGER.info("clean task successfully");
                }
                catch (Throwable t) {
                    LOGGER.error("clean task error", t);
                }
            }, 0L, this.cleanInterval.intValue(), TimeUnit.SECONDS);
            LOGGER.info("clean task started successfully");
        }
        if (this.dataAddTaskCleanEnabled.booleanValue()) {
            factory = new ThreadFactoryBuilder().setNameFormat("scheduled-subSource-deleted-%d").setDaemon(true).build();
            executor = Executors.newSingleThreadScheduledExecutor(factory);
            executor.scheduleWithFixedDelay(() -> {
                try {
                    List needDeletedList = this.sourceMapper.selectByByTimeout(this.retentionDays);
                    this.sourceMapper.logicalDeleteByTimeout(this.retentionDays);
                    if (CollectionUtils.isNotEmpty((Collection)needDeletedList)) {
                        for (StreamSourceEntity sourceEntity : needDeletedList) {
                            LOGGER.info("begin to clean sub task for source={}", (Object)sourceEntity);
                            StreamSourceOperator sourceOperator = this.operatorFactory.getInstance(sourceEntity.getSourceType());
                            SourceRequest request = (SourceRequest)CommonBeanUtils.copyProperties((Object)sourceEntity, SourceRequest::new, (boolean)true);
                            sourceOperator.updateAgentTaskConfig(request, sourceEntity.getModifier());
                            LOGGER.info("success to clean sub task successfully, ={}", (Object)sourceEntity.getId());
                        }
                    }
                }
                catch (Throwable t) {
                    LOGGER.error("clean sub task error", t);
                }
            }, 0L, this.dataAddTaskCleanInterval.intValue(), TimeUnit.SECONDS);
            LOGGER.info("clean sub task started successfully");
        }
    }

    private void setReloadTimer() {
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        executorService.scheduleWithFixedDelay(this::reload, 60000L, 60000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Boolean reportSnapshot(TaskSnapshotRequest request) {
        return this.snapshotOperator.snapshot(request);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRES_NEW)
    public void report(TaskRequest request) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to get agent task: {}", (Object)request);
        }
        if (request == null || StringUtils.isBlank((CharSequence)request.getAgentIp())) {
            throw new BusinessException("agent request or agent ip was empty, just return");
        }
        this.preTimeoutTasks(request);
        if (CollectionUtils.isEmpty((Collection)request.getCommandInfo())) {
            LOGGER.debug("task result was empty in request: {}, just return", (Object)request);
            return;
        }
        for (CommandEntity command : request.getCommandInfo()) {
            this.updateTaskStatus(command);
        }
    }

    public void reload() {
        this.reloadAgentTask();
        this.reloadModule();
        this.updateModuleConfig();
    }

    public void reloadAgentTask() {
        LOGGER.debug("start to reload agent task config.");
        try {
            ConcurrentHashMap<String, TaskResult> newTaskConfigMap = new ConcurrentHashMap<String, TaskResult>();
            ConcurrentHashMap<String, AgentConfigInfo> newAgentConfigMap = new ConcurrentHashMap<String, AgentConfigInfo>();
            ConcurrentHashMap<String, ConfigResult> newInstallerConfigMap = new ConcurrentHashMap<String, ConfigResult>();
            List<AgentTaskConfigEntity> agentTaskConfigEntityList = this.configLoader.loadAllAgentTaskConfigEntity();
            agentTaskConfigEntityList.forEach(agentTaskConfigEntity -> {
                try {
                    ConfigResult configResult;
                    AgentConfigInfo agentConfigInfo;
                    String key = agentTaskConfigEntity.getAgentIp() + "_" + agentTaskConfigEntity.getClusterName();
                    TaskResult taskResult = (TaskResult)JsonUtils.parseObject((String)agentTaskConfigEntity.getTaskParams(), TaskResult.class);
                    if (taskResult != null) {
                        taskResult.setVersion(agentTaskConfigEntity.getVersion());
                        newTaskConfigMap.putIfAbsent(key, taskResult);
                    }
                    if ((agentConfigInfo = (AgentConfigInfo)JsonUtils.parseObject((String)agentTaskConfigEntity.getConfigParams(), AgentConfigInfo.class)) != null) {
                        agentConfigInfo.setVersion(agentTaskConfigEntity.getVersion());
                        newAgentConfigMap.putIfAbsent(key, agentConfigInfo);
                    }
                    if ((configResult = (ConfigResult)JsonUtils.parseObject((String)agentTaskConfigEntity.getModuleParams(), ConfigResult.class)) != null) {
                        configResult.setVersion(agentTaskConfigEntity.getVersion());
                        newInstallerConfigMap.putIfAbsent(key, configResult);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("failed to get agent task config for agent ip={}, cluster name={}", (Object)agentTaskConfigEntity.getAgentIp(), (Object)agentTaskConfigEntity.getClusterName());
                }
            });
            this.taskConfigMap = newTaskConfigMap;
            this.agentConfigMap = newAgentConfigMap;
            this.installerConfigMap = newInstallerConfigMap;
        }
        catch (Throwable t) {
            LOGGER.error("failed to reload all agent task config", t);
        }
        LOGGER.debug("end to reload agent task config");
    }

    public void reloadModule() {
        LOGGER.info("start to reload agent task config.");
        try {
            ConcurrentHashMap<Integer, ModuleConfig> newModuleConfigMap = new ConcurrentHashMap<Integer, ModuleConfig>();
            List<ModuleConfigEntity> moduleConfigEntityList = this.configLoader.loadAllModuleConfigEntity();
            List<PackageConfigEntity> packageConfigEntityList = this.configLoader.loadAllPackageConfigEntity();
            ConcurrentHashMap packageConfigMap = new ConcurrentHashMap();
            packageConfigEntityList.forEach(packageConfigEntity -> packageConfigMap.putIfAbsent(packageConfigEntity.getId(), packageConfigEntity));
            moduleConfigEntityList.forEach(moduleConfigEntity -> {
                ModuleConfig moduleConfig = (ModuleConfig)CommonBeanUtils.copyProperties((Object)moduleConfigEntity, ModuleConfig::new);
                moduleConfig.setId(Integer.valueOf(ModuleType.forType((String)moduleConfigEntity.getType()).getModuleId()));
                moduleConfig.setEntityId(moduleConfigEntity.getId());
                PackageConfigEntity packageConfigEntity = (PackageConfigEntity)packageConfigMap.get(moduleConfigEntity.getPackageId());
                moduleConfig.setPackageConfig((PackageConfig)CommonBeanUtils.copyProperties((Object)packageConfigEntity, PackageConfig::new));
                ModuleDTO moduleDTO = (ModuleDTO)JsonUtils.parseObject((String)moduleConfigEntity.getExtParams(), ModuleDTO.class);
                moduleConfig = (ModuleConfig)CommonBeanUtils.copyProperties((Object)moduleDTO, (Object)moduleConfig, (boolean)true);
                moduleConfig.setProcessesNum(Integer.valueOf(1));
                newModuleConfigMap.putIfAbsent(moduleConfigEntity.getId(), moduleConfig);
            });
            this.moduleConfigMap = newModuleConfigMap;
        }
        catch (Throwable t) {
            LOGGER.error("fail to reload module config", t);
        }
        LOGGER.debug("end to reload module config");
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateModuleConfig() {
        LOGGER.info("start to update module config.");
        try {
            LinkedBlockingQueue tempQueue = new LinkedBlockingQueue();
            if (this.updateModuleConfigQueue.isEmpty()) {
                return;
            }
            int moveNum = this.updateModuleConfigQueue.drainTo(tempQueue);
            LOGGER.info("begin to update module config source size={}, target size={}, move num={}", new Object[]{this.updateModuleConfigQueue.size(), tempQueue.size(), moveNum});
            while (!tempQueue.isEmpty()) {
                ConfigRequest configRequest = (ConfigRequest)tempQueue.poll();
                String ip = configRequest.getLocalIp();
                String clusterName = configRequest.getClusterName();
                String key = ip + "_" + clusterName;
                ConfigResult configResult = this.installerConfigMap.get(key);
                Integer restartTime = 0;
                ArrayList<ModuleConfig> configs = new ArrayList<ModuleConfig>();
                ArrayList<Integer> moduleIdList = new ArrayList<Integer>();
                if (this.moduleConfigMap.isEmpty() || this.moduleConfigMap.get(this.defaultModuleId) != null) {
                    return;
                }
                if (configResult == null) {
                    moduleIdList.add(this.defaultModuleId);
                } else {
                    if (CollectionUtils.isNotEmpty((Collection)configResult.getModuleList())) {
                        restartTime = ((ModuleConfig)configResult.getModuleList().get(0)).getRestartTime();
                    }
                    for (ModuleConfig moduleConfig : configResult.getModuleList()) {
                        moduleIdList.add(moduleConfig.getEntityId());
                    }
                }
                for (Integer moduleId : moduleIdList) {
                    ModuleConfig moduleConfig = this.moduleConfigMap.get(moduleId);
                    if (moduleConfig == null) continue;
                    if (configResult != null && CollectionUtils.isNotEmpty((Collection)configResult.getModuleList())) {
                        for (ModuleConfig config : configResult.getModuleList()) {
                            if (!Objects.equals(config.getEntityId(), moduleId)) continue;
                            restartTime = config.getRestartTime();
                        }
                    }
                    moduleConfig.setRestartTime(restartTime);
                    String moduleStr = GSON.toJson((Object)moduleConfig);
                    String moduleMd5 = DigestUtils.md5Hex((String)moduleStr);
                    moduleConfig.setMd5(moduleMd5);
                    configs.add(moduleConfig);
                }
                String jsonStr = GSON.toJson(configs);
                String configMd5 = DigestUtils.md5Hex((String)jsonStr);
                ConfigResult newConfigResult = ConfigResult.builder().moduleList(configs).md5(configMd5).code(AgentResponseCode.SUCCESS).build();
                if (configResult != null && Objects.equals(configResult.getMd5(), newConfigResult.getMd5())) continue;
                this.agentClusterNodeOperator.updateModuleConfig(ip, clusterName);
            }
        }
        catch (Throwable t) {
            LOGGER.error("fail to update module config", t);
        }
        LOGGER.info("end to update module config");
    }

    private void updateTaskStatus(CommandEntity command) {
        Integer taskId = command.getTaskId();
        StreamSourceEntity current = this.sourceMapper.selectForAgentTask(taskId);
        if (current == null) {
            LOGGER.warn("stream source not found by id={}, just return", (Object)taskId);
            return;
        }
        if (!Objects.equals(command.getVersion(), current.getVersion())) {
            LOGGER.warn("task result version [{}] not equals to current [{}] for id [{}], skip update", new Object[]{command.getVersion(), current.getVersion(), taskId});
            return;
        }
        int result = command.getCommandResult();
        int previousStatus = current.getStatus();
        int nextStatus = SourceStatus.SOURCE_NORMAL.getCode();
        if (1 == result) {
            LOGGER.warn("task failed for id =[{}]", (Object)taskId);
            nextStatus = SourceStatus.SOURCE_FAILED.getCode();
        } else if (previousStatus / 100 == 3) {
            if (SourceStatus.BEEN_ISSUED_DELETE.getCode() == previousStatus) {
                nextStatus = SourceStatus.SOURCE_DISABLE.getCode();
            } else if (SourceStatus.BEEN_ISSUED_STOP.getCode() == previousStatus) {
                nextStatus = SourceStatus.SOURCE_STOP.getCode();
            }
        }
        if (nextStatus != previousStatus) {
            this.sourceMapper.updateStatus(taskId, Integer.valueOf(nextStatus), Boolean.valueOf(false));
            LOGGER.info("task result=[{}], update source status to [{}] for id [{}]", new Object[]{result, nextStatus, taskId});
        }
    }

    @Override
    public AgentConfigInfo getAgentConfig(AgentConfigRequest request) {
        LOGGER.debug("begin to get agent config info for {}", (Object)request);
        String key = request.getIp() + "_" + request.getClusterName();
        AgentConfigInfo agentConfigInfo = this.agentConfigMap.get(key);
        if (agentConfigInfo == null) {
            return null;
        }
        if (request.getMd5() == null || !Objects.equals(request.getMd5(), agentConfigInfo.getMd5())) {
            return agentConfigInfo;
        }
        LOGGER.debug("success to get agent config info for: {}, result: {}", (Object)request, (Object)agentConfigInfo);
        return AgentConfigInfo.builder().md5(agentConfigInfo.getMd5()).code(AgentResponseCode.NO_UPDATE).build();
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRES_NEW)
    public TaskResult getTaskResult(TaskRequest request) {
        if (StringUtils.isBlank((CharSequence)request.getClusterName()) || StringUtils.isBlank((CharSequence)request.getAgentIp())) {
            throw new BusinessException("agent request or agent ip was empty, just return");
        }
        this.preProcessFileTask(request);
        this.preProcessNonFileTasks(request);
        List<DataConfig> tasks = this.processQueuedTasks(request);
        List<CmdConfig> cmdConfigs = this.getAgentCmdConfigs(request);
        return TaskResult.builder().dataConfigs(tasks).cmdConfigs(cmdConfigs).build();
    }

    @Override
    public TaskResult getExistTaskConfig(TaskRequest request) {
        LOGGER.debug("begin to get all exist task by request={}", (Object)request);
        String key = request.getAgentIp() + "_" + request.getClusterName();
        TaskResult taskResult = this.taskConfigMap.get(key);
        if (taskResult == null) {
            key = "All_" + request.getClusterName();
            taskResult = this.taskConfigMap.get(key);
        }
        if (taskResult == null) {
            return null;
        }
        if (request.getMd5() == null || !Objects.equals(request.getMd5(), taskResult.getMd5())) {
            return taskResult;
        }
        return TaskResult.builder().dataConfigs(new ArrayList()).cmdConfigs(new ArrayList()).md5(taskResult.getMd5()).code(AgentResponseCode.NO_UPDATE).build();
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRES_NEW)
    public Boolean bindGroup(AgentClusterNodeBindGroupRequest request) {
        HashSet bindSet = Sets.newHashSet();
        HashSet unbindSet = Sets.newHashSet();
        if (request.getBindClusterNodes() != null) {
            bindSet.addAll(request.getBindClusterNodes());
        }
        if (request.getUnbindClusterNodes() != null) {
            unbindSet.addAll(request.getUnbindClusterNodes());
        }
        Preconditions.expectTrue((Sets.union((Set)bindSet, (Set)unbindSet).size() == bindSet.size() + unbindSet.size() ? 1 : 0) != 0, (String)"can not add and del node tag in the sameTime");
        InlongClusterEntity cluster = this.clusterMapper.selectByNameAndType(request.getClusterName(), "AGENT");
        String message = "Current user does not have permission to bind cluster node tag";
        if (CollectionUtils.isNotEmpty((Collection)bindSet)) {
            bindSet.stream().flatMap(clusterNode -> {
                ClusterPageRequest pageRequest = new ClusterPageRequest();
                pageRequest.setParentId(cluster.getId());
                pageRequest.setType("AGENT");
                pageRequest.setKeyword(clusterNode);
                return this.clusterNodeMapper.selectByCondition(pageRequest).stream();
            }).filter(Objects::nonNull).forEach(entity -> {
                HashSet groupSet = new HashSet();
                AgentClusterNodeDTO agentClusterNodeDTO = new AgentClusterNodeDTO();
                if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
                    agentClusterNodeDTO = AgentClusterNodeDTO.getFromJson((String)entity.getExtParams());
                    String agentGroup = agentClusterNodeDTO.getAgentGroup();
                    groupSet = StringUtils.isBlank((CharSequence)agentGroup) ? groupSet : Sets.newHashSet((Object[])agentGroup.split(","));
                }
                groupSet.add(request.getAgentGroup());
                agentClusterNodeDTO.setAgentGroup(Joiner.on((String)",").join(groupSet));
                entity.setExtParams(GSON.toJson((Object)agentClusterNodeDTO));
                this.clusterNodeMapper.insertOnDuplicateKeyUpdate(entity);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)unbindSet)) {
            unbindSet.stream().flatMap(clusterNode -> {
                ClusterPageRequest pageRequest = new ClusterPageRequest();
                pageRequest.setParentId(cluster.getId());
                pageRequest.setType("AGENT");
                pageRequest.setKeyword(clusterNode);
                return this.clusterNodeMapper.selectByCondition(pageRequest).stream();
            }).filter(Objects::nonNull).forEach(entity -> {
                HashSet groupSet = new HashSet();
                AgentClusterNodeDTO agentClusterNodeDTO = new AgentClusterNodeDTO();
                if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
                    agentClusterNodeDTO = AgentClusterNodeDTO.getFromJson((String)entity.getExtParams());
                    String agentGroup = agentClusterNodeDTO.getAgentGroup();
                    groupSet = StringUtils.isBlank((CharSequence)agentGroup) ? groupSet : Sets.newHashSet((Object[])agentGroup.split(","));
                }
                groupSet.remove(request.getAgentGroup());
                agentClusterNodeDTO.setAgentGroup(Joiner.on((String)",").join(groupSet));
                entity.setExtParams(GSON.toJson((Object)agentClusterNodeDTO));
                this.clusterNodeMapper.insertOnDuplicateKeyUpdate(entity);
            });
        }
        return true;
    }

    @Override
    public ConfigResult getConfig(ConfigRequest request) {
        String key = request.getLocalIp() + "_" + request.getClusterName();
        ConfigResult configResult = this.installerConfigMap.get(key);
        if (configResult == null) {
            if (!this.updateModuleConfigQueue.contains(request)) {
                this.updateModuleConfigQueue.add(request);
            }
            LOGGER.debug(String.format("can not get config result for cluster name=%s, ip=%s", request.getClusterName(), request.getLocalIp()));
            return null;
        }
        if (Objects.equals(request.getMd5(), configResult.getMd5())) {
            return ConfigResult.builder().md5(configResult.getMd5()).code(AgentResponseCode.NO_UPDATE).build();
        }
        return configResult;
    }

    private List<DataConfig> processQueuedTasks(TaskRequest request) {
        HashSet needAddStatusSet = Sets.newHashSet((Iterable)SourceStatus.TOBE_ISSUED_SET);
        if (PullJobTypeEnum.NEVER == PullJobTypeEnum.getPullJobType((int)request.getPullJobType())) {
            LOGGER.debug("agent pull job type is [NEVER], just pull to be active tasks");
            needAddStatusSet.remove(SourceStatus.TO_BE_ISSUED_ADD);
        }
        List sourceEntities = this.sourceMapper.selectByStatusAndCluster(needAddStatusSet.stream().map(SourceStatus::getCode).collect(Collectors.toList()), request.getClusterName(), request.getAgentIp(), request.getUuid());
        ArrayList issuedTasks = Lists.newArrayList();
        for (StreamSourceEntity sourceEntity : sourceEntities) {
            int op = this.getOp(sourceEntity.getStatus());
            int nextStatus = this.getNextStatus(sourceEntity.getStatus());
            sourceEntity.setPreviousStatus(sourceEntity.getStatus());
            sourceEntity.setStatus(Integer.valueOf(nextStatus));
            if (this.sourceMapper.updateByPrimaryKeySelective(sourceEntity) != 1) continue;
            sourceEntity.setVersion(Integer.valueOf(sourceEntity.getVersion() + 1));
            DataConfig dataConfig = this.getDataConfig(sourceEntity, op);
            issuedTasks.add(dataConfig);
            LOGGER.info("Offer source task({}) for agent({}) in cluster({})", new Object[]{dataConfig, request.getAgentIp(), request.getClusterName()});
        }
        return issuedTasks;
    }

    private void preProcessNonFileTasks(TaskRequest taskRequest) {
        List<Integer> needAddStatusList;
        if (PullJobTypeEnum.NEVER == PullJobTypeEnum.getPullJobType((int)taskRequest.getPullJobType())) {
            LOGGER.debug("agent pull job type is [NEVER], just pull to be active tasks");
            needAddStatusList = Collections.singletonList(SourceStatus.TO_BE_ISSUED_ACTIVE.getCode());
        } else {
            needAddStatusList = Arrays.asList(SourceStatus.TO_BE_ISSUED_ADD.getCode(), SourceStatus.TO_BE_ISSUED_ACTIVE.getCode());
        }
        ArrayList sourceTypes = Lists.newArrayList((Object[])new String[]{"KAFKA", "MYSQL_BINLOG", "POSTGRESQL"});
        List sourceEntities = this.sourceMapper.selectByStatusAndType(needAddStatusList, (List)sourceTypes, 2);
        for (StreamSourceEntity sourceEntity : sourceEntities) {
            sourceEntity.setAgentIp(taskRequest.getAgentIp());
            sourceEntity.setUuid(taskRequest.getUuid());
            this.sourceMapper.updateByPrimaryKeySelective(sourceEntity);
        }
    }

    private void preProcessFileTask(TaskRequest taskRequest) {
        this.preProcessTemplateFileTask(taskRequest);
        this.preProcessLabelFileTasks(taskRequest);
    }

    private void preProcessTemplateFileTask(TaskRequest taskRequest) {
        List<Integer> needCopiedStatusList = Arrays.asList(SourceStatus.TO_BE_ISSUED_ADD.getCode(), SourceStatus.TO_BE_ISSUED_ACTIVE.getCode());
        String agentIp = taskRequest.getAgentIp();
        String agentClusterName = taskRequest.getClusterName();
        Preconditions.expectTrue((StringUtils.isNotBlank((CharSequence)agentIp) || StringUtils.isNotBlank((CharSequence)agentClusterName) ? 1 : 0) != 0, (String)"both agent ip and cluster name are blank when fetching file task");
        List sourceEntities = this.sourceMapper.selectTemplateSourceByCluster(needCopiedStatusList, (List)Lists.newArrayList((Object[])new String[]{"FILE"}), agentClusterName);
        HashSet noNeedAddTask = Sets.newHashSet((Object[])new GroupStatus[]{GroupStatus.CONFIG_OFFLINE_SUCCESSFUL, GroupStatus.CONFIG_OFFLINE_ING, GroupStatus.CONFIG_DELETING, GroupStatus.CONFIG_DELETED});
        sourceEntities.stream().forEach(sourceEntity -> {
            InlongClusterNodeEntity clusterNodeEntity;
            InlongGroupEntity groupEntity = this.groupMapper.selectByGroupId(sourceEntity.getInlongGroupId());
            if (groupEntity != null && noNeedAddTask.contains(GroupStatus.forCode((int)groupEntity.getStatus()))) {
                return;
            }
            StreamSourceEntity subSource = this.sourceMapper.selectOneByTaskMapIdAndAgentIp(sourceEntity.getId(), agentIp);
            if (subSource == null && this.matchGroup((StreamSourceEntity)sourceEntity, clusterNodeEntity = this.selectByIpAndCluster(agentClusterName, agentIp))) {
                StreamSourceEntity fileEntity = (StreamSourceEntity)CommonBeanUtils.copyProperties((Object)sourceEntity, StreamSourceEntity::new);
                fileEntity.setSourceName(fileEntity.getSourceName() + "-" + RandomStringUtils.randomAlphanumeric((int)10).toLowerCase(Locale.ROOT));
                fileEntity.setTaskMapId(sourceEntity.getId());
                fileEntity.setAgentIp(agentIp);
                fileEntity.setStatus(SourceStatus.TO_BE_ISSUED_ADD.getCode());
                this.sourceMapper.insert(fileEntity);
                LOGGER.info("Transform new template task({}) for agent({}) in cluster({}).", new Object[]{fileEntity.getId(), taskRequest.getAgentIp(), taskRequest.getClusterName()});
            }
        });
    }

    private void preProcessLabelFileTasks(TaskRequest taskRequest) {
        List<Integer> needProcessedStatusList = Arrays.asList(SourceStatus.SOURCE_NORMAL.getCode(), SourceStatus.SOURCE_FAILED.getCode(), SourceStatus.SOURCE_STOP.getCode(), SourceStatus.TO_BE_ISSUED_ADD.getCode(), SourceStatus.TO_BE_ISSUED_STOP.getCode(), SourceStatus.TO_BE_ISSUED_ACTIVE.getCode());
        String agentIp = taskRequest.getAgentIp();
        String agentClusterName = taskRequest.getClusterName();
        Preconditions.expectTrue((StringUtils.isNotBlank((CharSequence)agentIp) || StringUtils.isNotBlank((CharSequence)agentClusterName) ? 1 : 0) != 0, (String)"both agent ip and cluster name are blank when fetching file task");
        InlongClusterNodeEntity clusterNodeEntity = this.selectByIpAndCluster(agentClusterName, agentIp);
        List sourceEntities = this.sourceMapper.selectByAgentIpAndCluster(needProcessedStatusList, (List)Lists.newArrayList((Object[])new String[]{"FILE"}), agentIp, agentClusterName);
        sourceEntities.forEach(sourceEntity -> {
            HashSet exceptedUnmatchedStatus = Sets.newHashSet((Object[])new SourceStatus[]{SourceStatus.SOURCE_STOP, SourceStatus.TO_BE_ISSUED_STOP});
            if (!this.matchGroup((StreamSourceEntity)sourceEntity, clusterNodeEntity) && !exceptedUnmatchedStatus.contains(SourceStatus.forCode((int)sourceEntity.getStatus()))) {
                LOGGER.info("Transform task({}) from {} to {} because tag mismatch for agent({}) in cluster({})", new Object[]{sourceEntity.getAgentIp(), sourceEntity.getStatus(), SourceStatus.TO_BE_ISSUED_STOP.getCode(), agentIp, agentClusterName});
                this.sourceMapper.updateStatus(sourceEntity.getId(), SourceStatus.TO_BE_ISSUED_STOP.getCode(), Boolean.valueOf(false));
            }
            InlongGroupEntity groupEntity = this.groupMapper.selectByGroupId(sourceEntity.getInlongGroupId());
            HashSet exceptedMatchedSourceStatus = Sets.newHashSet((Object[])new SourceStatus[]{SourceStatus.SOURCE_NORMAL, SourceStatus.TO_BE_ISSUED_ADD, SourceStatus.TO_BE_ISSUED_ACTIVE});
            HashSet matchedGroupStatus = Sets.newHashSet((Object[])new GroupStatus[]{GroupStatus.CONFIG_SUCCESSFUL});
            if (this.matchGroup((StreamSourceEntity)sourceEntity, clusterNodeEntity) && groupEntity != null && !exceptedMatchedSourceStatus.contains(SourceStatus.forCode((int)sourceEntity.getStatus())) && matchedGroupStatus.contains(GroupStatus.forCode((int)groupEntity.getStatus()))) {
                LOGGER.info("Transform task({}) from {} to {} because tag rematch for agent({}) in cluster({})", new Object[]{sourceEntity.getAgentIp(), sourceEntity.getStatus(), SourceStatus.TO_BE_ISSUED_ACTIVE.getCode(), agentIp, agentClusterName});
                this.sourceMapper.updateStatus(sourceEntity.getId(), SourceStatus.TO_BE_ISSUED_ACTIVE.getCode(), Boolean.valueOf(false));
            }
        });
    }

    private void preTimeoutTasks(TaskRequest taskRequest) {
        List needUpdateIds = this.sourceMapper.selectHeartbeatTimeoutIds(null, taskRequest.getAgentIp(), taskRequest.getClusterName());
        if (CollectionUtils.isNotEmpty((Collection)needUpdateIds)) {
            this.sourceMapper.rollbackTimeoutStatusByIds(needUpdateIds, null);
        }
    }

    private InlongClusterNodeEntity selectByIpAndCluster(String clusterName, String ip) {
        InlongClusterEntity clusterEntity = this.clusterMapper.selectByNameAndType(clusterName, "AGENT");
        if (clusterEntity == null) {
            return null;
        }
        return this.clusterNodeMapper.selectByParentIdAndIp(clusterEntity.getId(), ip).stream().findFirst().orElse(null);
    }

    private int getOp(int status) {
        return status % 100;
    }

    private int getNextStatus(int status) {
        int op = status % 100;
        return 300 + op;
    }

    private DataConfig getDataConfig(StreamSourceEntity entity, int op) {
        DataConfig dataConfig = new DataConfig();
        dataConfig.setIp(entity.getAgentIp());
        dataConfig.setUuid(entity.getUuid());
        dataConfig.setOp(String.valueOf(op));
        dataConfig.setTaskId(entity.getId());
        dataConfig.setTaskType(Integer.valueOf(this.getTaskType(entity)));
        dataConfig.setTaskName(entity.getSourceName());
        dataConfig.setSnapshot(entity.getSnapshot());
        dataConfig.setTimeZone(entity.getDataTimeZone());
        dataConfig.setVersion(entity.getVersion());
        String groupId = entity.getInlongGroupId();
        String streamId = entity.getInlongStreamId();
        dataConfig.setInlongGroupId(groupId);
        dataConfig.setInlongStreamId(streamId);
        InlongGroupEntity groupEntity = this.groupMapper.selectByGroupId(groupId);
        InlongStreamEntity streamEntity = this.streamMapper.selectByIdentifier(groupId, streamId);
        StreamSourceOperator sourceOperator = this.operatorFactory.getInstance(entity.getSourceType());
        String extParams = sourceOperator.getExtParams(entity);
        if (groupEntity != null && streamEntity != null) {
            dataConfig.setState(Integer.valueOf(SourceStatus.NORMAL_STATUS_SET.contains(SourceStatus.forCode((int)entity.getStatus())) ? TaskStateEnum.RUNNING.getType() : TaskStateEnum.FROZEN.getType()));
            dataConfig.setSyncSend(streamEntity.getSyncSend());
            if ("FILE".equalsIgnoreCase(entity.getSourceType())) {
                String dataSeparator = String.valueOf((char)Integer.parseInt(streamEntity.getDataSeparator()));
                FileSourceDTO fileSourceDTO = (FileSourceDTO)JsonUtils.parseObject((String)extParams, FileSourceDTO.class);
                if (Objects.nonNull(fileSourceDTO)) {
                    fileSourceDTO.setDataSeparator(dataSeparator);
                    dataConfig.setAuditVersion(fileSourceDTO.getAuditVersion());
                    fileSourceDTO.setDataContentStyle(streamEntity.getDataType());
                    extParams = JsonUtils.toJsonString((Object)fileSourceDTO);
                }
            }
            InlongStreamInfo streamInfo = (InlongStreamInfo)CommonBeanUtils.copyProperties((Object)streamEntity, InlongStreamInfo::new);
            InlongStreamExtParam.unpackExtParams((String)streamEntity.getExtParams(), (Object)streamInfo);
            dataConfig.setPredefinedFields(streamInfo.getPredefinedFields());
            int dataReportType = groupEntity.getDataReportType();
            dataConfig.setDataReportType(Integer.valueOf(dataReportType));
            if (InlongConstants.REPORT_TO_MQ_RECEIVED == dataReportType) {
                DataProxyTopicInfo topicConfig;
                ArrayList<MQClusterInfo> mqSet = new ArrayList<MQClusterInfo>();
                List<String> clusterTagList = Collections.singletonList(groupEntity.getInlongClusterTag());
                ClusterPageRequest pageRequest = ClusterPageRequest.builder().type(groupEntity.getMqType()).clusterTagList(clusterTagList).build();
                List mqClusterList = this.clusterMapper.selectByCondition(pageRequest);
                for (InlongClusterEntity cluster : mqClusterList) {
                    MQClusterInfo clusterInfo = new MQClusterInfo();
                    clusterInfo.setUrl(cluster.getUrl());
                    clusterInfo.setToken(cluster.getToken());
                    clusterInfo.setMqType(cluster.getType());
                    clusterInfo.setParams((Map)JsonUtils.parseObject((String)cluster.getExtParams(), HashMap.class));
                    mqSet.add(clusterInfo);
                }
                dataConfig.setMqClusters(mqSet);
                String mqResource = groupEntity.getMqResource();
                String mqType = groupEntity.getMqType();
                if ("PULSAR".equals(mqType) || "TDMQ_PULSAR".equals(mqType)) {
                    InlongPulsarDTO pulsarDTO = InlongPulsarDTO.getFromJson((String)groupEntity.getExtParams());
                    String tenant = pulsarDTO.getPulsarTenant();
                    if (StringUtils.isBlank((CharSequence)tenant)) {
                        PulsarClusterDTO pulsarCluster = PulsarClusterDTO.getFromJson((String)((InlongClusterEntity)mqClusterList.get(0)).getExtParams());
                        tenant = pulsarCluster.getPulsarTenant();
                    }
                    String topic = String.format("persistent://%s/%s/%s", tenant, mqResource, streamEntity.getMqResource());
                    DataProxyTopicInfo topicConfig2 = new DataProxyTopicInfo();
                    topicConfig2.setInlongGroupId(groupId + "/" + streamId);
                    topicConfig2.setTopic(topic);
                    dataConfig.setTopicInfo(topicConfig2);
                } else if ("TUBEMQ".equals(mqType)) {
                    topicConfig = new DataProxyTopicInfo();
                    topicConfig.setInlongGroupId(groupId);
                    topicConfig.setTopic(mqResource);
                    dataConfig.setTopicInfo(topicConfig);
                } else if ("KAFKA".equals(mqType)) {
                    topicConfig = new DataProxyTopicInfo();
                    topicConfig.setInlongGroupId(groupId);
                    topicConfig.setTopic(groupEntity.getMqResource() + "." + streamEntity.getMqResource());
                    dataConfig.setTopicInfo(topicConfig);
                }
            } else {
                LOGGER.warn("set syncSend=[0] as the stream not exists for groupId={}, streamId={}", (Object)groupId, (Object)streamId);
            }
        }
        dataConfig.setExtParams(extParams);
        return dataConfig;
    }

    private int getTaskType(StreamSourceEntity sourceEntity) {
        TaskTypeEnum taskType = (TaskTypeEnum)SourceType.SOURCE_TASK_MAP.get(sourceEntity.getSourceType());
        if (taskType == null) {
            throw new BusinessException("Unsupported task type for source type " + sourceEntity.getSourceType());
        }
        return taskType.getType();
    }

    private List<CmdConfig> getAgentCmdConfigs(TaskRequest taskRequest) {
        return this.sourceCmdConfigMapper.queryCmdByAgentIp(taskRequest.getAgentIp()).stream().map(cmd -> {
            CmdConfig cmdConfig = new CmdConfig();
            cmdConfig.setDataTime(cmd.getSpecifiedDataTime());
            cmdConfig.setOp(cmd.getCmdType());
            cmdConfig.setId(cmd.getId());
            cmdConfig.setTaskId(cmd.getTaskId());
            return cmdConfig;
        }).collect(Collectors.toList());
    }

    private boolean matchGroup(StreamSourceEntity sourceEntity, InlongClusterNodeEntity clusterNodeEntity) {
        Preconditions.expectNotNull((Object)sourceEntity, (String)"cluster must be valid");
        if (sourceEntity.getInlongClusterNodeGroup() == null) {
            return true;
        }
        if (clusterNodeEntity == null || clusterNodeEntity.getExtParams() == null) {
            return false;
        }
        HashSet clusterNodeGroups = new HashSet();
        if (StringUtils.isNotBlank((CharSequence)clusterNodeEntity.getExtParams())) {
            AgentClusterNodeDTO agentClusterNodeDTO = AgentClusterNodeDTO.getFromJson((String)clusterNodeEntity.getExtParams());
            String agentGroup = agentClusterNodeDTO.getAgentGroup();
            clusterNodeGroups = StringUtils.isBlank((CharSequence)agentGroup) ? new HashSet() : Sets.newHashSet((Object[])agentGroup.split(","));
        }
        Set sourceGroups = Stream.of(sourceEntity.getInlongClusterNodeGroup().split(",")).collect(Collectors.toSet());
        return sourceGroups.stream().anyMatch(clusterNodeGroups::contains);
    }
}

