/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.ck;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.inlong.manager.common.util.UrlVerificationUtils;
import org.apache.inlong.manager.pojo.sink.ck.ClickHouseFieldInfo;
import org.apache.inlong.manager.pojo.sink.ck.ClickHouseTableInfo;
import org.apache.inlong.manager.service.resource.sink.ck.ClickHouseSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.clickhouse.ClickHouseDatabaseMetadata;

public class ClickHouseJdbcUtils {
    private static final String CLICKHOUSE_DRIVER_CLASS = "ru.yandex.clickhouse.ClickHouseDriver";
    private static final String COLUMN_LABEL = "TABLE_NAME";
    private static final String CLICKHOUSE_JDBC_PREFIX = "jdbc:clickhouse://";
    private static final Logger LOG = LoggerFactory.getLogger(ClickHouseJdbcUtils.class);

    public static Connection getConnection(String url, String user, String password) throws Exception {
        UrlVerificationUtils.extractHostAndValidatePortFromJdbcUrl((String)url, (String)CLICKHOUSE_JDBC_PREFIX);
        Connection conn = ClickHouseJdbcUtils.establishConnection(url, user, password);
        return conn;
    }

    private static Connection establishConnection(String url, String user, String password) throws Exception {
        Connection conn;
        try {
            Class.forName(CLICKHOUSE_DRIVER_CLASS);
            conn = DriverManager.getConnection(url, user, password);
        }
        catch (Exception e) {
            LOG.error("get ClickHouse connection error, please check ClickHouse JDBC URL, username or password", (Throwable)e);
            throw new Exception("get ClickHouse connection error, please check JDBC URL, username or password. other error msg: " + e.getMessage());
        }
        if (conn == null) {
            throw new Exception("get ClickHouse connection failed, please contact administrator");
        }
        LOG.info("get ClickHouse connection success, url={}", (Object)url);
        return conn;
    }

    public static void executeSql(String sql, String url, String user, String password) throws Exception {
        try (Connection conn = ClickHouseJdbcUtils.getConnection(url, user, password);){
            Statement stmt = conn.createStatement();
            stmt.execute(sql);
            LOG.info("execute sql [{}] success for url: {}", (Object)sql, (Object)url);
        }
    }

    public static void executeSqlBatch(List<String> sql, String url, String user, String password) throws Exception {
        try (Connection conn = ClickHouseJdbcUtils.getConnection(url, user, password);){
            Statement stmt = conn.createStatement();
            for (String entry : sql) {
                stmt.execute(entry);
            }
            LOG.info("execute sql [{}] success for url: {}", sql, (Object)url);
        }
    }

    public static void createDb(String url, String user, String password, String dbName) throws Exception {
        String createDbSql = ClickHouseSqlBuilder.buildCreateDbSql(dbName);
        ClickHouseJdbcUtils.executeSql(createDbSql, url, user, password);
    }

    public static void createTable(String url, String user, String password, ClickHouseTableInfo tableInfo) throws Exception {
        String createTableSql = ClickHouseSqlBuilder.buildCreateTableSql(tableInfo);
        ClickHouseJdbcUtils.executeSql(createTableSql, url, user, password);
    }

    public static List<String> getTables(String url, String user, String password, String dbname) throws Exception {
        ArrayList<String> tables = new ArrayList<String>();
        try (Connection conn = ClickHouseJdbcUtils.getConnection(url, user, password);){
            ClickHouseDatabaseMetadata metaData = (ClickHouseDatabaseMetadata)conn.getMetaData();
            LOG.info("dbname is {}", (Object)dbname);
            ResultSet rs = metaData.getTables(dbname, dbname, null, new String[]{"TABLE"});
            while (rs.next()) {
                String tableName = rs.getString(COLUMN_LABEL);
                tables.add(tableName);
            }
            rs.close();
        }
        return tables;
    }

    /*
     * Exception decompiling
     */
    public static List<ClickHouseFieldInfo> getFields(String url, String user, String password, String dbName, String tableName) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void addColumns(String url, String user, String password, String dbName, String tableName, List<ClickHouseFieldInfo> columnList) throws Exception {
        List<String> addColumnSql = ClickHouseSqlBuilder.buildAddColumnsSql(dbName, tableName, columnList);
        ClickHouseJdbcUtils.executeSqlBatch(addColumnSql, url, user, password);
    }
}

