/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.mysql;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.pojo.sink.mysql.MySQLColumnInfo;
import org.apache.inlong.manager.pojo.sink.mysql.MySQLTableInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLSqlBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySQLSqlBuilder.class);

    public static String getCheckDatabase(String dbName) {
        StringBuilder sqlBuilder = new StringBuilder().append("SELECT schema_name ").append(" FROM information_schema.schemata ").append("WHERE schema_name = '").append(dbName).append("';");
        LOGGER.info("check database sql: {}", (Object)sqlBuilder);
        return sqlBuilder.toString();
    }

    public static String getCheckTable(String dbName, String tableName) {
        StringBuilder sqlBuilder = new StringBuilder().append("select table_schema,table_name ").append(" from information_schema.tables where table_schema = '").append(dbName).append("' and table_name = '").append(tableName).append("' ;");
        LOGGER.info("check table sql: {}", (Object)sqlBuilder);
        return sqlBuilder.toString();
    }

    public static String getCheckColumn(String dbName, String tableName, String columnName) {
        StringBuilder sqlBuilder = new StringBuilder().append("SELECT COLUMN_NAME,COLUMN_TYPE,COLUMN_COMMENT ").append(" from  information_schema.COLUMNS where table_schema='").append(dbName).append("' and table_name = '").append(tableName).append("' and column_name = '").append(columnName).append("';");
        LOGGER.info("check table sql: {}", (Object)sqlBuilder);
        return sqlBuilder.toString();
    }

    public static String buildCreateDbSql(String dbName) {
        String sql = "CREATE DATABASE " + dbName;
        LOGGER.info("create db sql: {}", (Object)sql);
        return sql;
    }

    public static String buildCreateTableSql(MySQLTableInfo table) {
        StringBuilder sql = new StringBuilder().append("CREATE TABLE ").append(table.getDbName()).append(".").append(table.getTableName()).append(MySQLSqlBuilder.buildCreateColumnsSql(table));
        if (StringUtils.isEmpty((CharSequence)table.getEngine())) {
            sql.append(" ENGINE=InnoDB ");
        } else {
            sql.append(" ENGINE=").append(table.getEngine()).append(" ");
        }
        if (!StringUtils.isEmpty((CharSequence)table.getCharset())) {
            sql.append(" DEFAULT CHARSET=").append(table.getCharset()).append(" ");
        }
        LOGGER.info("create table sql: {}", (Object)sql);
        return sql.toString();
    }

    public static List<String> buildAddColumnsSql(String dbName, String tableName, List<MySQLColumnInfo> columnList) {
        List<String> columnInfoList = MySQLSqlBuilder.getColumnsInfo(columnList);
        ArrayList<String> resultList = new ArrayList<String>();
        StringBuilder sqlBuilder = new StringBuilder();
        columnInfoList.forEach(columnInfo -> {
            sqlBuilder.append("ALTER TABLE ").append(dbName).append(".").append(tableName).append(" ADD COLUMN ").append((String)columnInfo).append(";");
            resultList.add(sqlBuilder.toString());
            sqlBuilder.delete(0, sqlBuilder.length());
        });
        return resultList;
    }

    private static String buildCreateColumnsSql(MySQLTableInfo table) {
        List<String> columnList = MySQLSqlBuilder.getColumnsInfo(table.getColumns());
        StringBuilder sql = new StringBuilder().append(" (").append(StringUtils.join(columnList, (String)","));
        if (!StringUtils.isEmpty((CharSequence)table.getPrimaryKey())) {
            sql.append(", PRIMARY KEY (").append(table.getPrimaryKey()).append(")");
        }
        sql.append(") ");
        LOGGER.info("create columns sql={}", (Object)sql);
        return sql.toString();
    }

    private static List<String> getColumnsInfo(List<MySQLColumnInfo> columns) {
        ArrayList<String> columnList = new ArrayList<String>();
        StringBuilder columnBuilder = new StringBuilder();
        columns.forEach(columnInfo -> {
            columnBuilder.append("`").append(columnInfo.getName()).append("`").append(" ").append(columnInfo.getType());
            if (!StringUtils.isEmpty((CharSequence)columnInfo.getComment())) {
                columnBuilder.append(" COMMENT '").append(columnInfo.getComment()).append("'");
            }
            columnBuilder.append(" ");
            columnList.add(columnBuilder.toString());
            columnBuilder.delete(0, columnBuilder.length());
        });
        return columnList;
    }

    public static String buildDescTableSql(String dbName, String tableName) {
        StringBuilder sql = new StringBuilder().append("SELECT COLUMN_NAME,COLUMN_TYPE,COLUMN_COMMENT ").append(" from  information_schema.COLUMNS where table_schema='").append(dbName).append("' and table_name = '").append(tableName).append("';");
        LOGGER.info("desc table sql={}", (Object)sql);
        return sql.toString();
    }
}

