/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.starrocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.pojo.sink.starrocks.StarRocksColumnInfo;
import org.apache.inlong.manager.pojo.sink.starrocks.StarRocksTableInfo;
import org.apache.inlong.manager.service.resource.sink.hive.SqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarRocksSqlBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlBuilder.class);

    public static String buildCreateDbSql(String dbName) {
        String sql = "CREATE DATABASE IF NOT EXISTS `" + dbName + "`";
        LOGGER.info("create db sql: {}", (Object)sql);
        return sql;
    }

    public static String buildCreateTableSql(StarRocksTableInfo table) {
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE ").append(table.getTableName());
        sql.append(StarRocksSqlBuilder.getColumnsAndComments(table));
        if (!Objects.isNull(table.getReplicationNum())) {
            sql.append(" PROPERTIES ( \"replication_num\" = \"").append(table.getReplicationNum()).append("\")");
        }
        LOGGER.info("create table sql: {}", (Object)sql);
        return sql.toString();
    }

    public static String buildDescTableSql(String dbName, String tableName) {
        StringBuilder sql = new StringBuilder();
        String fullTableName = "`" + dbName + "." + tableName + "`";
        sql.append("DESC ").append(fullTableName);
        LOGGER.info("desc table sql={}", (Object)sql);
        return sql.toString();
    }

    public static List<String> buildAddColumnsSql(String dbName, String tableName, List<StarRocksColumnInfo> columnList) {
        List<String> columnInfoList = StarRocksSqlBuilder.getColumnsInfo(columnList);
        ArrayList<String> resultList = new ArrayList<String>();
        StringBuilder sqlBuilder = new StringBuilder();
        columnInfoList.forEach(columnInfo -> {
            sqlBuilder.append("ALTER TABLE ").append(dbName).append(".").append(tableName).append(" ADD COLUMN ").append((String)columnInfo).append(";");
            resultList.add(sqlBuilder.toString());
            sqlBuilder.delete(0, sqlBuilder.length());
        });
        return resultList;
    }

    private static List<String> getColumnsInfo(List<StarRocksColumnInfo> columns) {
        ArrayList<String> columnList = new ArrayList<String>();
        StringBuilder columnBuilder = new StringBuilder();
        columns.forEach(columnInfo -> {
            columnBuilder.append("`").append(columnInfo.getFieldName()).append("`").append(" ").append(columnInfo.getFieldType());
            if (!StringUtils.isEmpty((CharSequence)columnInfo.getFieldComment())) {
                columnBuilder.append(" COMMENT '").append(columnInfo.getFieldComment()).append("'");
            }
            columnBuilder.append(" ");
            columnList.add(columnBuilder.toString());
            columnBuilder.delete(0, columnBuilder.length());
        });
        return columnList;
    }

    private static String getColumnsAndComments(StarRocksTableInfo tableInfo) {
        List columns = tableInfo.getColumns();
        ArrayList<String> columnList = new ArrayList<String>();
        ArrayList<String> sortKeyList = new ArrayList<String>();
        ArrayList<String> distributeList = new ArrayList<String>();
        for (StarRocksColumnInfo columnInfo : columns) {
            StringBuilder columnStr = new StringBuilder().append("`").append(columnInfo.getFieldName()).append("` ").append(columnInfo.getFieldType());
            if (StringUtils.isNotEmpty((CharSequence)columnInfo.getFieldComment())) {
                columnStr.append(" COMMENT ").append("'").append(columnInfo.getFieldComment()).append("'");
            }
            if (columnInfo.getIsDistributed().booleanValue()) {
                distributeList.add("`" + columnInfo.getFieldName() + "` ");
            }
            if (columnInfo.getIsSortKey().booleanValue()) {
                sortKeyList.add("`" + columnInfo.getFieldName() + "` ");
            }
            columnList.add(columnStr.toString());
        }
        StringBuilder result = new StringBuilder().append(" (").append(StringUtils.join(columnList, (String)",")).append(") ");
        if (StringUtils.isNotBlank((CharSequence)tableInfo.getPrimaryKey())) {
            result.append("PRIMARY KEY (").append(tableInfo.getPrimaryKey()).append(") ");
        }
        if (sortKeyList.size() > 0) {
            result.append("DUPLICATE KEY (").append(StringUtils.join(sortKeyList, (String)",")).append(") ");
        }
        if (distributeList.size() <= 0 && columns.size() > 0) {
            distributeList.add("`" + ((StarRocksColumnInfo)columns.get(0)).getFieldName() + "` ");
        }
        result.append("DISTRIBUTED BY HASH (").append(StringUtils.join(distributeList, (String)",")).append(") ").append("BUCKETS ").append(tableInfo.getBarrelSize());
        return result.toString();
    }

    public static String getCheckTable(String dbName, String tableName) {
        StringBuilder sqlBuilder = new StringBuilder().append("select table_schema,table_name ").append(" from information_schema.tables where table_schema = '").append(dbName).append("' and table_name = '").append(tableName).append("' ;");
        LOGGER.info("check table sql: {}", (Object)sqlBuilder);
        return sqlBuilder.toString();
    }

    public static String getCheckColumn(String dbName, String tableName, String columnName) {
        StringBuilder sqlBuilder = new StringBuilder().append("SELECT COLUMN_NAME,COLUMN_TYPE,COLUMN_COMMENT ").append(" from  information_schema.COLUMNS where table_schema='").append(dbName).append("' and table_name = '").append(tableName).append("' and column_name = '").append(columnName).append("';");
        LOGGER.info("check table sql: {}", (Object)sqlBuilder);
        return sqlBuilder.toString();
    }
}

