/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.io.BaseEncoding;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ByteBuffers;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.iceberg.util.JsonUtil;

public class SingleValueParser {
    private static final String KEYS = "keys";
    private static final String VALUES = "values";

    private SingleValueParser() {
    }

    public static Object fromJson(Type type, JsonNode defaultValue) {
        if (defaultValue == null || defaultValue.isNull()) {
            return null;
        }
        switch (type.typeId()) {
            case BOOLEAN: {
                Preconditions.checkArgument((boolean)defaultValue.isBoolean(), (String)"Cannot parse default as a %s value: %s", (Object)type, (Object)defaultValue);
                return defaultValue.booleanValue();
            }
            case INTEGER: {
                Preconditions.checkArgument((defaultValue.isIntegralNumber() && defaultValue.canConvertToInt() ? 1 : 0) != 0, (String)"Cannot parse default as a %s value: %s", (Object)type, (Object)defaultValue);
                return defaultValue.intValue();
            }
            case LONG: {
                Preconditions.checkArgument((defaultValue.isIntegralNumber() && defaultValue.canConvertToLong() ? 1 : 0) != 0, (String)"Cannot parse default as a %s value: %s", (Object)type, (Object)defaultValue);
                return defaultValue.longValue();
            }
            case FLOAT: {
                Preconditions.checkArgument((boolean)defaultValue.isFloatingPointNumber(), (String)"Cannot parse default as a %s value: %s", (Object)type, (Object)defaultValue);
                return Float.valueOf(defaultValue.floatValue());
            }
            case DOUBLE: {
                Preconditions.checkArgument((boolean)defaultValue.isFloatingPointNumber(), (String)"Cannot parse default as a %s value: %s", (Object)type, (Object)defaultValue);
                return defaultValue.doubleValue();
            }
            case DECIMAL: {
                BigDecimal retDecimal;
                Preconditions.checkArgument((boolean)defaultValue.isTextual(), (String)"Cannot parse default as a %s value: %s", (Object)type, (Object)defaultValue);
                try {
                    retDecimal = new BigDecimal(defaultValue.textValue());
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(String.format("Cannot parse default as a %s value: %s", type, defaultValue), e);
                }
                Preconditions.checkArgument((retDecimal.scale() == ((Types.DecimalType)type).scale() ? 1 : 0) != 0, (String)"Cannot parse default as a %s value: %s, the scale doesn't match", (Object)type, (Object)defaultValue);
                return retDecimal;
            }
            case STRING: {
                Preconditions.checkArgument((boolean)defaultValue.isTextual(), (String)"Cannot parse default as a %s value: %s", (Object)type, (Object)defaultValue);
                return defaultValue.textValue();
            }
            case UUID: {
                UUID uuid;
                Preconditions.checkArgument((defaultValue.isTextual() && defaultValue.textValue().length() == 36 ? 1 : 0) != 0, (String)"Cannot parse default as a %s value: %s", (Object)type, (Object)defaultValue);
                try {
                    uuid = UUID.fromString(defaultValue.textValue());
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(String.format("Cannot parse default as a %s value: %s", type, defaultValue), e);
                }
                return uuid;
            }
            case DATE: {
                Preconditions.checkArgument((boolean)defaultValue.isTextual(), (String)"Cannot parse default as a %s value: %s", (Object)type, (Object)defaultValue);
                return DateTimeUtil.isoDateToDays((String)defaultValue.textValue());
            }
            case TIME: {
                Preconditions.checkArgument((boolean)defaultValue.isTextual(), (String)"Cannot parse default as a %s value: %s", (Object)type, (Object)defaultValue);
                return DateTimeUtil.isoTimeToMicros((String)defaultValue.textValue());
            }
            case TIMESTAMP: {
                Preconditions.checkArgument((boolean)defaultValue.isTextual(), (String)"Cannot parse default as a %s value: %s", (Object)type, (Object)defaultValue);
                if (((Types.TimestampType)type).shouldAdjustToUTC()) {
                    String timestampTz = defaultValue.textValue();
                    Preconditions.checkArgument((boolean)DateTimeUtil.isUTCTimestamptz((String)timestampTz), (String)"Cannot parse default as a %s value: %s, offset must be +00:00", (Object)type, (Object)defaultValue);
                    return DateTimeUtil.isoTimestamptzToMicros((String)timestampTz);
                }
                return DateTimeUtil.isoTimestampToMicros((String)defaultValue.textValue());
            }
            case FIXED: {
                Preconditions.checkArgument((boolean)defaultValue.isTextual(), (String)"Cannot parse default as a %s value: %s", (Object)type, (Object)defaultValue);
                int defaultLength = defaultValue.textValue().length();
                int fixedLength = ((Types.FixedType)type).length();
                Preconditions.checkArgument((defaultLength == fixedLength * 2 ? 1 : 0) != 0, (String)"Cannot parse default %s value: %s, incorrect length: %s", (Object)type, (Object)defaultValue, (Object)defaultLength);
                byte[] fixedBytes = BaseEncoding.base16().decode((CharSequence)defaultValue.textValue().toUpperCase(Locale.ROOT));
                return ByteBuffer.wrap(fixedBytes);
            }
            case BINARY: {
                Preconditions.checkArgument((boolean)defaultValue.isTextual(), (String)"Cannot parse default as a %s value: %s", (Object)type, (Object)defaultValue);
                byte[] binaryBytes = BaseEncoding.base16().decode((CharSequence)defaultValue.textValue().toUpperCase(Locale.ROOT));
                return ByteBuffer.wrap(binaryBytes);
            }
            case LIST: {
                return SingleValueParser.listFromJson(type, defaultValue);
            }
            case MAP: {
                return SingleValueParser.mapFromJson(type, defaultValue);
            }
            case STRUCT: {
                return SingleValueParser.structFromJson(type, defaultValue);
            }
        }
        throw new UnsupportedOperationException(String.format("Type: %s is not supported", type));
    }

    private static StructLike structFromJson(Type type, JsonNode defaultValue) {
        Preconditions.checkArgument((boolean)defaultValue.isObject(), (String)"Cannot parse default as a %s value: %s", (Object)type, (Object)defaultValue);
        Types.StructType struct = type.asStructType();
        GenericRecord defaultRecord = GenericRecord.create(struct);
        List fields = struct.fields();
        for (int pos = 0; pos < fields.size(); ++pos) {
            Types.NestedField field = (Types.NestedField)fields.get(pos);
            String idString = String.valueOf(field.fieldId());
            if (!defaultValue.has(idString)) continue;
            defaultRecord.set(pos, SingleValueParser.fromJson(field.type(), defaultValue.get(idString)));
        }
        return defaultRecord;
    }

    private static Map<Object, Object> mapFromJson(Type type, JsonNode defaultValue) {
        Preconditions.checkArgument((defaultValue.isObject() && defaultValue.has(KEYS) && defaultValue.has(VALUES) && defaultValue.get(KEYS).isArray() && defaultValue.get(VALUES).isArray() ? 1 : 0) != 0, (String)"Cannot parse %s to a %s value", (Object)defaultValue, (Object)type);
        JsonNode keys = defaultValue.get(KEYS);
        JsonNode values = defaultValue.get(VALUES);
        Preconditions.checkArgument((keys.size() == values.size() ? 1 : 0) != 0, (String)"Cannot parse default as a %s value: %s", (Object)type, (Object)defaultValue);
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        Iterator keyIter = keys.iterator();
        Type keyType = type.asMapType().keyType();
        Iterator valueIter = values.iterator();
        Type valueType = type.asMapType().valueType();
        while (keyIter.hasNext()) {
            mapBuilder.put(SingleValueParser.fromJson(keyType, (JsonNode)keyIter.next()), SingleValueParser.fromJson(valueType, (JsonNode)valueIter.next()));
        }
        return mapBuilder.build();
    }

    private static List<Object> listFromJson(Type type, JsonNode defaultValue) {
        Preconditions.checkArgument((boolean)defaultValue.isArray(), (String)"Cannot parse default as a %s value: %s", (Object)type, (Object)defaultValue);
        Type elementType = type.asListType().elementType();
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)defaultValue, e -> SingleValueParser.fromJson(elementType, e)));
    }

    public static Object fromJson(Type type, String defaultValue) {
        return JsonUtil.parse(defaultValue, node -> SingleValueParser.fromJson(type, node));
    }

    public static String toJson(Type type, Object defaultValue) {
        return SingleValueParser.toJson(type, defaultValue, false);
    }

    public static String toJson(Type type, Object defaultValue, boolean pretty) {
        return JsonUtil.generate(gen -> SingleValueParser.toJson(type, defaultValue, gen), pretty);
    }

    public static void toJson(Type type, Object defaultValue, JsonGenerator generator) throws IOException {
        if (defaultValue == null) {
            generator.writeNull();
            return;
        }
        switch (type.typeId()) {
            case BOOLEAN: {
                Preconditions.checkArgument((boolean)(defaultValue instanceof Boolean), (String)"Invalid default %s value: %s", (Object)type, (Object)defaultValue);
                generator.writeBoolean(((Boolean)defaultValue).booleanValue());
                break;
            }
            case INTEGER: {
                Preconditions.checkArgument((boolean)(defaultValue instanceof Integer), (String)"Invalid default %s value: %s", (Object)type, (Object)defaultValue);
                generator.writeNumber(((Integer)defaultValue).intValue());
                break;
            }
            case LONG: {
                Preconditions.checkArgument((boolean)(defaultValue instanceof Long), (String)"Invalid default %s value: %s", (Object)type, (Object)defaultValue);
                generator.writeNumber(((Long)defaultValue).longValue());
                break;
            }
            case FLOAT: {
                Preconditions.checkArgument((boolean)(defaultValue instanceof Float), (String)"Invalid default %s value: %s", (Object)type, (Object)defaultValue);
                generator.writeNumber(((Float)defaultValue).floatValue());
                break;
            }
            case DOUBLE: {
                Preconditions.checkArgument((boolean)(defaultValue instanceof Double), (String)"Invalid default %s value: %s", (Object)type, (Object)defaultValue);
                generator.writeNumber(((Double)defaultValue).doubleValue());
                break;
            }
            case DATE: {
                Preconditions.checkArgument((boolean)(defaultValue instanceof Integer), (String)"Invalid default %s value: %s", (Object)type, (Object)defaultValue);
                generator.writeString(DateTimeUtil.daysToIsoDate((int)((Integer)defaultValue)));
                break;
            }
            case TIME: {
                Preconditions.checkArgument((boolean)(defaultValue instanceof Long), (String)"Invalid default %s value: %s", (Object)type, (Object)defaultValue);
                generator.writeString(DateTimeUtil.microsToIsoTime((long)((Long)defaultValue)));
                break;
            }
            case TIMESTAMP: {
                Preconditions.checkArgument((boolean)(defaultValue instanceof Long), (String)"Invalid default %s value: %s", (Object)type, (Object)defaultValue);
                if (((Types.TimestampType)type).shouldAdjustToUTC()) {
                    generator.writeString(DateTimeUtil.microsToIsoTimestamptz((long)((Long)defaultValue)));
                    break;
                }
                generator.writeString(DateTimeUtil.microsToIsoTimestamp((long)((Long)defaultValue)));
                break;
            }
            case STRING: {
                Preconditions.checkArgument((boolean)(defaultValue instanceof CharSequence), (String)"Invalid default %s value: %s", (Object)type, (Object)defaultValue);
                generator.writeString(((CharSequence)defaultValue).toString());
                break;
            }
            case UUID: {
                Preconditions.checkArgument((boolean)(defaultValue instanceof UUID), (String)"Invalid default %s value: %s", (Object)type, (Object)defaultValue);
                generator.writeString(defaultValue.toString());
                break;
            }
            case FIXED: {
                Preconditions.checkArgument((boolean)(defaultValue instanceof ByteBuffer), (String)"Invalid default %s value: %s", (Object)type, (Object)defaultValue);
                ByteBuffer byteBufferValue = (ByteBuffer)defaultValue;
                int expectedLength = ((Types.FixedType)type).length();
                Preconditions.checkArgument((byteBufferValue.remaining() == expectedLength ? 1 : 0) != 0, (String)"Invalid default %s value, incorrect length: %s", (Object)type, (int)byteBufferValue.remaining());
                generator.writeString(BaseEncoding.base16().encode(ByteBuffers.toByteArray((ByteBuffer)byteBufferValue)));
                break;
            }
            case BINARY: {
                Preconditions.checkArgument((boolean)(defaultValue instanceof ByteBuffer), (String)"Invalid default %s value: %s", (Object)type, (Object)defaultValue);
                generator.writeString(BaseEncoding.base16().encode(ByteBuffers.toByteArray((ByteBuffer)((ByteBuffer)defaultValue))));
                break;
            }
            case DECIMAL: {
                Preconditions.checkArgument((defaultValue instanceof BigDecimal && ((BigDecimal)defaultValue).scale() == ((Types.DecimalType)type).scale() ? 1 : 0) != 0, (String)"Invalid default %s value: %s", (Object)type, (Object)defaultValue);
                BigDecimal decimalValue = (BigDecimal)defaultValue;
                if (decimalValue.scale() >= 0) {
                    generator.writeString(decimalValue.toPlainString());
                    break;
                }
                generator.writeString(decimalValue.toString());
                break;
            }
            case LIST: {
                Preconditions.checkArgument((boolean)(defaultValue instanceof List), (String)"Invalid default %s value: %s", (Object)type, (Object)defaultValue);
                List defaultList = (List)defaultValue;
                Type elementType = type.asListType().elementType();
                generator.writeStartArray();
                for (Object element : defaultList) {
                    SingleValueParser.toJson(elementType, element, generator);
                }
                generator.writeEndArray();
                break;
            }
            case MAP: {
                Preconditions.checkArgument((boolean)(defaultValue instanceof Map), (String)"Invalid default %s value: %s", (Object)type, (Object)defaultValue);
                Map defaultMap = (Map)defaultValue;
                Type keyType = type.asMapType().keyType();
                Type valueType = type.asMapType().valueType();
                ArrayList valueList = Lists.newArrayListWithExpectedSize((int)defaultMap.size());
                generator.writeStartObject();
                generator.writeArrayFieldStart(KEYS);
                for (Map.Entry entry : defaultMap.entrySet()) {
                    SingleValueParser.toJson(keyType, entry.getKey(), generator);
                    valueList.add(entry.getValue());
                }
                generator.writeEndArray();
                generator.writeArrayFieldStart(VALUES);
                for (Map.Entry value : valueList) {
                    SingleValueParser.toJson(valueType, value, generator);
                }
                generator.writeEndArray();
                generator.writeEndObject();
                break;
            }
            case STRUCT: {
                Preconditions.checkArgument((boolean)(defaultValue instanceof StructLike), (String)"Invalid default %s value: %s", (Object)type, (Object)defaultValue);
                Types.StructType structType = type.asStructType();
                List fields = structType.fields();
                StructLike defaultStruct = (StructLike)defaultValue;
                generator.writeStartObject();
                for (int i = 0; i < defaultStruct.size(); ++i) {
                    Types.NestedField field = (Types.NestedField)fields.get(i);
                    int fieldId = field.fieldId();
                    Object fieldDefaultValue = defaultStruct.get(i, Object.class);
                    if (fieldDefaultValue == null) continue;
                    generator.writeFieldName(String.valueOf(fieldId));
                    SingleValueParser.toJson(field.type(), fieldDefaultValue, generator);
                }
                generator.writeEndObject();
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Type: %s is not supported", type));
            }
        }
    }
}

