/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.apache.iceberg.metrics.CommitMetricsResultParser;
import org.apache.iceberg.metrics.CommitReport;
import org.apache.iceberg.metrics.ImmutableCommitReport;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.JsonUtil;

public class CommitReportParser {
    private static final String TABLE_NAME = "table-name";
    private static final String SNAPSHOT_ID = "snapshot-id";
    private static final String SEQUENCE_NUMBER = "sequence-number";
    private static final String OPERATION = "operation";
    private static final String METRICS = "metrics";
    private static final String METADATA = "metadata";

    private CommitReportParser() {
    }

    public static String toJson(CommitReport commitReport) {
        return CommitReportParser.toJson(commitReport, false);
    }

    public static String toJson(CommitReport commitReport, boolean pretty) {
        return JsonUtil.generate(gen -> CommitReportParser.toJson(commitReport, gen), pretty);
    }

    public static void toJson(CommitReport commitReport, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument((null != commitReport ? 1 : 0) != 0, (Object)"Invalid commit report: null");
        gen.writeStartObject();
        CommitReportParser.toJsonWithoutStartEnd(commitReport, gen);
        gen.writeEndObject();
    }

    public static void toJsonWithoutStartEnd(CommitReport commitReport, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument((null != commitReport ? 1 : 0) != 0, (Object)"Invalid commit report: null");
        gen.writeStringField(TABLE_NAME, commitReport.tableName());
        gen.writeNumberField(SNAPSHOT_ID, commitReport.snapshotId());
        gen.writeNumberField(SEQUENCE_NUMBER, commitReport.sequenceNumber());
        gen.writeStringField(OPERATION, commitReport.operation());
        gen.writeFieldName(METRICS);
        CommitMetricsResultParser.toJson(commitReport.commitMetrics(), gen);
        if (!commitReport.metadata().isEmpty()) {
            JsonUtil.writeStringMap(METADATA, commitReport.metadata(), gen);
        }
    }

    public static CommitReport fromJson(String json) {
        return JsonUtil.parse(json, CommitReportParser::fromJson);
    }

    public static CommitReport fromJson(JsonNode json) {
        Preconditions.checkArgument((null != json ? 1 : 0) != 0, (Object)"Cannot parse commit report from null object");
        Preconditions.checkArgument((boolean)json.isObject(), (String)"Cannot parse commit report from non-object: %s", (Object)json);
        ImmutableCommitReport.Builder builder = ImmutableCommitReport.builder().tableName(JsonUtil.getString(TABLE_NAME, json)).snapshotId(JsonUtil.getLong(SNAPSHOT_ID, json)).sequenceNumber(JsonUtil.getLong(SEQUENCE_NUMBER, json)).operation(JsonUtil.getString(OPERATION, json)).commitMetrics(CommitMetricsResultParser.fromJson(JsonUtil.get(METRICS, json)));
        if (json.has(METADATA)) {
            builder.metadata(JsonUtil.getStringMap(METADATA, json));
        }
        return builder.build();
    }
}

