/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.conf.sink;

import org.apache.flume.Context;
import org.apache.flume.conf.ComponentConfiguration;
import org.apache.flume.conf.ConfigurationException;
import org.apache.flume.conf.FlumeConfiguration;
import org.apache.flume.conf.FlumeConfigurationError;
import org.apache.flume.conf.FlumeConfigurationErrorType;

public class SinkConfiguration
extends ComponentConfiguration {
    protected String channel;

    public SinkConfiguration(String componentName) {
        super(componentName);
    }

    public String getChannel() {
        return this.channel;
    }

    public void getChannel(String channel) {
        this.channel = channel;
    }

    @Override
    public void configure(Context context) throws ConfigurationException {
        super.configure(context);
        this.channel = context.getString("channel");
        if (this.channel == null || this.channel.isEmpty()) {
            this.errors.add(new FlumeConfigurationError(this.componentName, "channel", FlumeConfigurationErrorType.PROPERTY_VALUE_NULL, FlumeConfigurationError.ErrorOrWarning.ERROR));
            throw new ConfigurationException("No channel configured for sink: " + this.getComponentName());
        }
    }

    @Override
    public String toString(int indentCount) {
        String basicStr = super.toString(indentCount);
        StringBuilder sb = new StringBuilder();
        sb.append(basicStr).append("  ").append("CHANNEL:").append(this.channel).append(FlumeConfiguration.NEWLINE);
        return sb.toString();
    }

    public static enum SinkConfigurationType {
        OTHER(null),
        NULL("org.apache.flume.conf.sink.NullSinkConfiguration"),
        LOGGER(null),
        FILE_ROLL("org.apache.flume.conf.sink.RollingFileSinkConfiguration"),
        HDFS("org.apache.flume.conf.sink.HDFSSinkConfiguration"),
        IRC("org.apache.flume.conf.sink.IRCSinkConfiguration"),
        AVRO("org.apache.flume.conf.sink.AvroSinkConfiguration"),
        THRIFT("org.apache.flume.conf.sink.ThriftSinkConfiguration"),
        ELASTICSEARCH("org.apache.flume.sink.elasticsearch.ElasticSearchSinkConfiguration"),
        HBASE("org.apache.flume.sink.hbase.HBaseSinkConfiguration"),
        ASYNCHBASE("org.apache.flume.sink.hbase.HBaseSinkConfiguration"),
        HBASE2("org.apache.flume.sink.hbase2.HBase2SinkConfiguration"),
        MORPHLINE_SOLR("org.apache.flume.sink.solr.morphline.MorphlineSolrSinkConfiguration"),
        HIVE("org.apache.flume.sink.hive.HiveSinkConfiguration"),
        HTTP("org.apache.flume.sink.http.HttpSinkConfiguration");

        private final String sinkConfigurationName;

        private SinkConfigurationType(String type) {
            this.sinkConfigurationName = type;
        }

        public String getSinkConfigurationType() {
            return this.sinkConfigurationName;
        }

        public SinkConfiguration getConfiguration(String name) throws ConfigurationException {
            if (this == OTHER) {
                return new SinkConfiguration(name);
            }
            SinkConfiguration instance = null;
            try {
                if (this.sinkConfigurationName == null) {
                    return new SinkConfiguration(name);
                }
                Class<?> clazz = Class.forName(this.sinkConfigurationName);
                instance = (SinkConfiguration)clazz.getConstructor(String.class).newInstance(name);
            }
            catch (ClassNotFoundException e) {
                instance = new SinkConfiguration(name);
                instance.setNotFoundConfigClass();
            }
            catch (Exception e) {
                throw new ConfigurationException("Couldn't create configuration", e);
            }
            return instance;
        }
    }
}

