/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import io.debezium.DebeziumException;
import io.debezium.annotation.NotThreadSafe;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.ConnectionContext;
import io.debezium.connector.mongodb.DisconnectEvent;
import io.debezium.connector.mongodb.MongoDbChangeSnapshotOplogRecordEmitter;
import io.debezium.connector.mongodb.MongoDbCollectionSchema;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbSchema;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.ReplicaSet;
import io.debezium.connector.mongodb.ReplicaSetOffsetContext;
import io.debezium.connector.mongodb.ReplicaSets;
import io.debezium.function.BlockingConsumer;
import io.debezium.pipeline.ConnectorEvent;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.AbstractSnapshotChangeEventSource;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotChangeEventSource;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.spi.DataChangeEventListener;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.schema.DataCollectionId;
import io.debezium.util.Clock;
import io.debezium.util.Strings;
import io.debezium.util.Threads;
import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class MongoDbIncrementalSnapshotChangeEventSource<T extends DataCollectionId>
implements IncrementalSnapshotChangeEventSource<CollectionId> {
    private static final String DOCUMENT_ID = "_id";
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbIncrementalSnapshotChangeEventSource.class);
    private static final String AUTHORIZATION_FAILURE_MESSAGE = "Command failed with error 13";
    private final MongoDbConnectorConfig connectorConfig;
    private final Clock clock;
    private final MongoDbSchema collectionSchema;
    private final SnapshotProgressListener progressListener;
    private final DataChangeEventListener dataListener;
    private long totalRowsScanned = 0L;
    private final ReplicaSets replicaSets;
    private final ConnectionContext connectionContext;
    private final MongoDbTaskContext taskContext;
    private MongoDbCollectionSchema currentCollection;
    protected EventDispatcher<CollectionId> dispatcher;
    protected IncrementalSnapshotContext<T> context = null;
    protected final Map<Struct, Object[]> window = new LinkedHashMap<Struct, Object[]>();
    private ConnectionContext.MongoPrimary primary;
    private CollectionId signallingCollectionId;

    public MongoDbIncrementalSnapshotChangeEventSource(MongoDbConnectorConfig config, MongoDbTaskContext taskContext, ReplicaSets replicaSets, EventDispatcher<CollectionId> dispatcher, MongoDbSchema collectionSchema, Clock clock, SnapshotProgressListener progressListener, DataChangeEventListener dataChangeEventListener) {
        this.connectorConfig = config;
        this.replicaSets = replicaSets;
        this.taskContext = taskContext;
        this.connectionContext = taskContext.getConnectionContext();
        this.dispatcher = dispatcher;
        this.collectionSchema = collectionSchema;
        this.clock = clock;
        this.progressListener = progressListener;
        this.dataListener = dataChangeEventListener;
        this.signallingCollectionId = this.connectorConfig.getSignalingDataCollectionId() == null ? null : CollectionId.parse("UNUSED", this.connectorConfig.getSignalingDataCollectionId());
    }

    public void closeWindow(Partition partition, String id, OffsetContext offsetContext) throws InterruptedException {
        this.context = offsetContext.getIncrementalSnapshotContext();
        if (!this.context.closeWindow(id)) {
            return;
        }
        this.sendWindowEvents(partition, offsetContext);
        this.readChunk();
    }

    protected String getSignalCollectionName(String dataCollectionId) {
        return dataCollectionId;
    }

    protected void sendWindowEvents(Partition partition, OffsetContext offsetContext) throws InterruptedException {
        LOGGER.debug("Sending {} events from window buffer", (Object)this.window.size());
        offsetContext.incrementalSnapshotEvents();
        for (Object[] row : this.window.values()) {
            this.sendEvent(partition, this.dispatcher, offsetContext, row);
        }
        offsetContext.postSnapshotCompletion();
        this.window.clear();
    }

    protected void sendEvent(Partition partition, EventDispatcher dispatcher, OffsetContext offsetContext, Object[] row) throws InterruptedException {
        this.context.sendEvent(this.keyFromRow(row));
        ((ReplicaSetOffsetContext)offsetContext).readEvent((CollectionId)this.context.currentDataCollectionId(), this.clock.currentTimeAsInstant());
        dispatcher.dispatchSnapshotEvent((DataCollectionId)this.context.currentDataCollectionId(), this.getChangeRecordEmitter(partition, (DataCollectionId)this.context.currentDataCollectionId(), offsetContext, row), dispatcher.getIncrementalSnapshotChangeEventReceiver(this.dataListener));
    }

    protected ChangeRecordEmitter getChangeRecordEmitter(Partition partition, T dataCollectionId, OffsetContext offsetContext, Object[] row) {
        return new MongoDbChangeSnapshotOplogRecordEmitter(partition, offsetContext, this.clock, (Document)row[0], true);
    }

    protected void deduplicateWindow(DataCollectionId dataCollectionId, Object key) {
        if (!((DataCollectionId)this.context.currentDataCollectionId()).equals(dataCollectionId)) {
            return;
        }
        if (key instanceof Struct && this.window.remove((Struct)key) != null) {
            LOGGER.info("Removed '{}' from window", key);
        }
    }

    protected void emitWindowOpen() throws InterruptedException {
        CollectionId collectionId = this.signallingCollectionId;
        String id = this.context.currentChunkId() + "-open";
        this.primary.executeBlocking("emit window open for chunk '" + this.context.currentChunkId() + "'", (BlockingConsumer<MongoClient>)((BlockingConsumer)primary -> {
            MongoDatabase database = primary.getDatabase(collectionId.dbName());
            MongoCollection collection = database.getCollection(collectionId.name());
            LOGGER.trace("Emitting open window for chunk = '{}'", (Object)this.context.currentChunkId());
            Document signal = new Document();
            signal.put(DOCUMENT_ID, (Object)id);
            signal.put("type", (Object)"snapshot-window-open");
            signal.put("payload", (Object)"");
            collection.insertOne((Object)signal);
        }));
    }

    protected void emitWindowClose() throws InterruptedException {
        CollectionId collectionId = this.signallingCollectionId;
        String id = this.context.currentChunkId() + "-close";
        this.primary.executeBlocking("emit window close for chunk '" + this.context.currentChunkId() + "'", (BlockingConsumer<MongoClient>)((BlockingConsumer)primary -> {
            MongoDatabase database = primary.getDatabase(collectionId.dbName());
            MongoCollection collection = database.getCollection(collectionId.name());
            LOGGER.trace("Emitting close window for chunk = '{}'", (Object)this.context.currentChunkId());
            Document signal = new Document();
            signal.put(DOCUMENT_ID, (Object)id);
            signal.put("type", (Object)"snapshot-window-close");
            signal.put("payload", (Object)"");
            collection.insertOne((Object)signal);
        }));
    }

    public void init(OffsetContext offsetContext) {
        this.primary = this.establishConnectionToPrimary(this.replicaSets.all().get(0));
        if (offsetContext == null) {
            LOGGER.info("Empty incremental snapshot change event source started, no action needed");
            this.postIncrementalSnapshotCompleted();
            return;
        }
        this.context = offsetContext.getIncrementalSnapshotContext();
        if (!this.context.snapshotRunning()) {
            LOGGER.info("No incremental snapshot in progress, no action needed on start");
            this.postIncrementalSnapshotCompleted();
            return;
        }
        LOGGER.info("Incremental snapshot in progress, need to read new chunk on start");
        try {
            this.progressListener.snapshotStarted();
            this.readChunk();
        }
        catch (InterruptedException e) {
            throw new DebeziumException("Reading of an initial chunk after connector restart has been interrupted");
        }
        LOGGER.info("Incremental snapshot in progress, loading of initial chunk completed");
    }

    protected void readChunk() throws InterruptedException {
        if (!this.context.snapshotRunning()) {
            LOGGER.info("Skipping read chunk because snapshot is not running");
            this.postIncrementalSnapshotCompleted();
            return;
        }
        try {
            this.preReadChunk(this.context);
            this.context.startNewChunk();
            this.emitWindowOpen();
            while (this.context.snapshotRunning()) {
                CollectionId currentDataCollectionId = (CollectionId)this.context.currentDataCollectionId();
                this.currentCollection = (MongoDbCollectionSchema)this.collectionSchema.schemaFor(currentDataCollectionId);
                if (this.replicaSets.all().size() > 1) {
                    LOGGER.warn("Incremental snapshotting supported only for single result set topology, skipping collection '{}', known collections {}", (Object)currentDataCollectionId);
                    this.nextDataCollection();
                    continue;
                }
                if (this.currentCollection == null) {
                    LOGGER.warn("Schema not found for collection '{}', known collections {}", (Object)currentDataCollectionId, (Object)this.collectionSchema);
                    this.nextDataCollection();
                    continue;
                }
                if (!this.context.maximumKey().isPresent()) {
                    this.context.maximumKey(this.readMaximumKey());
                    if (!this.context.maximumKey().isPresent()) {
                        LOGGER.info("No maximum key returned by the query, incremental snapshotting of collection '{}' finished as it is empty", (Object)currentDataCollectionId);
                        this.nextDataCollection();
                        continue;
                    }
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Incremental snapshot for collection '{}' will end at position {}", (Object)currentDataCollectionId, (Object)this.context.maximumKey().orElse(new Object[0]));
                    }
                }
                this.createDataEventsForDataCollection();
                if (!this.window.isEmpty()) break;
                LOGGER.info("No data returned by the query, incremental snapshotting of table '{}' finished", (Object)currentDataCollectionId);
                this.collectionScanCompleted();
                this.nextDataCollection();
            }
            this.emitWindowClose();
        }
        finally {
            this.postReadChunk(this.context);
            if (!this.context.snapshotRunning()) {
                this.postIncrementalSnapshotCompleted();
            }
        }
    }

    private void nextDataCollection() {
        this.context.nextDataCollection();
        if (!this.context.snapshotRunning()) {
            this.progressListener.snapshotCompleted();
        }
    }

    private Object[] readMaximumKey() throws InterruptedException {
        Object[] objectArray;
        CollectionId collectionId = (CollectionId)this.currentCollection.id();
        AtomicReference key = new AtomicReference();
        this.primary.executeBlocking("maximum key for '" + collectionId + "'", (BlockingConsumer<MongoClient>)((BlockingConsumer)primary -> {
            MongoDatabase database = primary.getDatabase(collectionId.dbName());
            MongoCollection collection = database.getCollection(collectionId.name());
            Document lastDocument = (Document)collection.find().sort((Bson)new Document(DOCUMENT_ID, (Object)-1)).limit(1).first();
            if (lastDocument != null) {
                key.set(lastDocument.get((Object)DOCUMENT_ID));
            }
        }));
        if (key.get() != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = key.get();
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    public void addDataCollectionNamesToSnapshot(List<String> dataCollectionIds, OffsetContext offsetContext) throws InterruptedException {
        this.context = offsetContext.getIncrementalSnapshotContext();
        boolean shouldReadChunk = !this.context.snapshotRunning();
        String rsName = this.replicaSets.all().get(0).replicaSetName();
        dataCollectionIds = dataCollectionIds.stream().map(x -> rsName + "." + x).collect(Collectors.toList());
        List newDataCollectionIds = this.context.addDataCollectionNamesToSnapshot(dataCollectionIds);
        if (shouldReadChunk) {
            this.progressListener.snapshotStarted();
            this.progressListener.monitoredDataCollectionsDetermined((Iterable)newDataCollectionIds);
            this.readChunk();
        }
    }

    private void createDataEventsForDataCollection() throws InterruptedException {
        CollectionId collectionId = (CollectionId)this.currentCollection.id();
        long exportStart = this.clock.currentTimeInMillis();
        LOGGER.debug("Exporting data chunk from collection '{}' (total {} collections)", (Object)this.currentCollection.id(), (Object)this.context.dataCollectionsToBeSnapshottedCount());
        this.primary.executeBlocking("chunk query key for '" + this.currentCollection.id() + "'", (BlockingConsumer<MongoClient>)((BlockingConsumer)primary -> {
            MongoDatabase database = primary.getDatabase(collectionId.dbName());
            MongoCollection collection = database.getCollection(collectionId.name());
            Document maxKeyPredicate = new Document();
            Document maxKeyOp = new Document();
            maxKeyOp.put("$lte", ((Object[])this.context.maximumKey().get())[0]);
            maxKeyPredicate.put(DOCUMENT_ID, (Object)maxKeyOp);
            Document predicate = maxKeyPredicate;
            if (this.context.chunkEndPosititon() != null) {
                Document chunkEndPredicate = new Document();
                Document chunkEndOp = new Document();
                chunkEndOp.put("$gt", this.context.chunkEndPosititon()[0]);
                chunkEndPredicate.put(DOCUMENT_ID, (Object)chunkEndOp);
                predicate = new Document();
                predicate.put("$and", Arrays.asList(chunkEndPredicate, maxKeyPredicate));
            }
            LOGGER.debug("\t For collection '{}' using query: '{}', key: '{}', maximum key: '{}'", new Object[]{this.currentCollection.id(), predicate.toJson(), this.context.chunkEndPosititon(), this.context.maximumKey().get()});
            long rows = 0L;
            Threads.Timer logTimer = this.getTableScanLogTimer();
            Object[] lastRow = null;
            Object[] firstRow = null;
            for (Document doc : collection.find((Bson)predicate).sort((Bson)new Document(DOCUMENT_ID, (Object)1)).limit(this.connectorConfig.getIncrementalSnashotChunkSize())) {
                ++rows;
                Object[] row = new Object[]{doc};
                if (firstRow == null) {
                    firstRow = row;
                }
                Struct keyStruct = this.currentCollection.keyFromDocument(doc);
                this.window.put(keyStruct, row);
                if (logTimer.expired()) {
                    long stop = this.clock.currentTimeInMillis();
                    LOGGER.debug("\t Exported {} records for collection '{}' after {}", new Object[]{rows, this.currentCollection.id(), Strings.duration((long)(stop - exportStart))});
                    logTimer = this.getTableScanLogTimer();
                }
                lastRow = row;
            }
            Object[] firstKey = this.keyFromRow(firstRow);
            Object[] lastKey = this.keyFromRow(lastRow);
            if (this.context.isNonInitialChunk()) {
                this.progressListener.currentChunk(this.context.currentChunkId(), firstKey, lastKey);
            } else {
                this.progressListener.currentChunk(this.context.currentChunkId(), firstKey, lastKey, (Object[])this.context.maximumKey().orElse(null));
            }
            this.context.nextChunkPosition(lastKey);
            if (lastRow != null) {
                LOGGER.debug("\t Next window will resume from {}", (Object)this.context.chunkEndPosititon());
            }
            LOGGER.debug("\t Finished exporting {} records for window of collection '{}'; total duration '{}'", new Object[]{rows, this.currentCollection.id(), Strings.duration((long)(this.clock.currentTimeInMillis() - exportStart))});
            this.incrementTableRowsScanned(rows);
        }));
    }

    private void incrementTableRowsScanned(long rows) {
        this.totalRowsScanned += rows;
    }

    private void collectionScanCompleted() {
        this.progressListener.dataCollectionSnapshotCompleted(this.currentCollection.id(), this.totalRowsScanned);
        this.totalRowsScanned = 0L;
        this.progressListener.currentChunk(null, null, null, null);
    }

    private Threads.Timer getTableScanLogTimer() {
        return Threads.timer((Clock)this.clock, (Duration)AbstractSnapshotChangeEventSource.LOG_INTERVAL);
    }

    private Object[] keyFromRow(Object[] row) {
        if (row == null) {
            return null;
        }
        return new Object[]{((Document)row[0]).get((Object)DOCUMENT_ID)};
    }

    protected void setContext(IncrementalSnapshotContext<T> context) {
        this.context = context;
    }

    protected void preReadChunk(IncrementalSnapshotContext<T> context) {
    }

    protected void postReadChunk(IncrementalSnapshotContext<T> context) {
    }

    protected void postIncrementalSnapshotCompleted() {
    }

    public void processMessage(Partition partition, DataCollectionId dataCollectionId, Object key, OffsetContext offsetContext) throws InterruptedException {
        this.context = offsetContext.getIncrementalSnapshotContext();
        if (this.context == null) {
            LOGGER.warn("Context is null, skipping message processing");
            return;
        }
        LOGGER.trace("Checking window for table '{}', key '{}', window contains '{}'", new Object[]{dataCollectionId, key, this.window});
        if (!this.window.isEmpty() && this.context.deduplicationNeeded()) {
            this.deduplicateWindow(dataCollectionId, key);
        }
    }

    private ConnectionContext.MongoPrimary establishConnectionToPrimary(ReplicaSet replicaSet) {
        return this.connectionContext.primaryFor(replicaSet, this.taskContext.filters(), (desc, error) -> {
            if (error.getMessage() != null && error.getMessage().startsWith(AUTHORIZATION_FAILURE_MESSAGE)) {
                throw new ConnectException("Error while attempting to " + desc, error);
            }
            this.dispatcher.dispatchConnectorEvent((ConnectorEvent)new DisconnectEvent());
            LOGGER.error("Error while attempting to {}: {}", new Object[]{desc, error.getMessage(), error});
            throw new ConnectException("Error while attempting to " + desc, error);
        });
    }
}

