/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.source;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.lang.reflect.Constructor;
import java.util.concurrent.TimeUnit;
import org.apache.flume.channel.ChannelProcessor;
import org.apache.flume.source.AbstractSource;
import org.apache.inlong.audit.source.ServiceDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerMessageFactory
extends ChannelInitializer<SocketChannel> {
    private static final Logger LOG = LoggerFactory.getLogger(ServerMessageFactory.class);
    private static final int DEFAULT_READ_IDLE_TIME = 4200000;
    private AbstractSource source;
    private ChannelProcessor processor;
    private ChannelGroup allChannels;
    private ServiceDecoder serviceDecoder;
    private String messageHandlerName;
    private int maxConnections = Integer.MAX_VALUE;
    private final long msgValidThresholdDays;
    private int maxMsgLength;
    private String name;

    public ServerMessageFactory(AbstractSource source, ChannelGroup allChannels, ServiceDecoder serviceDecoder, String messageHandlerName, Integer maxMsgLength, Integer maxCons, Long msgValidThresholdDays, String name) {
        this.source = source;
        this.processor = source.getChannelProcessor();
        this.allChannels = allChannels;
        this.serviceDecoder = serviceDecoder;
        this.messageHandlerName = messageHandlerName;
        this.name = name;
        this.maxConnections = maxCons;
        this.maxMsgLength = maxMsgLength;
        this.msgValidThresholdDays = msgValidThresholdDays;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ch.pipeline().addLast("messageDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(this.maxMsgLength, 0, 4, 0, 0, true));
        ch.pipeline().addLast("readTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler(4200000L, TimeUnit.MILLISECONDS));
        if (this.processor != null) {
            try {
                Class<?> clazz = Class.forName(this.messageHandlerName);
                Constructor<?> ctor = clazz.getConstructor(AbstractSource.class, ServiceDecoder.class, ChannelGroup.class, Integer.class, Long.class);
                ChannelInboundHandlerAdapter messageHandler = (ChannelInboundHandlerAdapter)ctor.newInstance(this.source, this.serviceDecoder, this.allChannels, this.maxConnections, this.msgValidThresholdDays);
                ch.pipeline().addLast("messageHandler", (ChannelHandler)messageHandler);
            }
            catch (Exception e) {
                LOG.info("SimpleChannelHandler.newInstance  has error:" + this.name, (Throwable)e);
            }
        }
    }
}

