/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.transformation.function;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.transformation.CascadeFunction;
import org.apache.inlong.sort.protocol.transformation.ConstantParam;
import org.apache.inlong.sort.protocol.transformation.FunctionParam;
import org.apache.inlong.sort.protocol.transformation.StringConstantParam;

public class JsonGetterFunction
implements CascadeFunction,
Serializable {
    private static final long serialVersionUID = -2701547146694616429L;
    @JsonProperty(value="field")
    private FieldInfo field;
    @JsonProperty(value="key")
    private StringConstantParam key;

    @JsonCreator
    public JsonGetterFunction(@JsonProperty(value="field") FieldInfo field, @JsonProperty(value="key") StringConstantParam key) {
        this.field = (FieldInfo)Preconditions.checkNotNull((Object)field, (Object)"field is null");
        this.key = (StringConstantParam)Preconditions.checkNotNull((Object)key, (Object)"key is null");
    }

    @Override
    public String getName() {
        return "JSON_GETTER";
    }

    @Override
    public List<FunctionParam> getParams() {
        return Arrays.asList(this.field, this.key);
    }

    @Override
    public String format() {
        return String.format("%s(CAST(%s AS STRING), %s)", this.getName(), this.field.format(), this.key.format());
    }

    @Override
    public ConstantParam apply(ConstantParam constantParam) {
        return new ConstantParam(String.format("%s(%s, %s)", this.getName(), constantParam.format(), this.key.format()));
    }
}

