/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.inlong.audit.AuditIdEnum;
import org.apache.inlong.audit.CdcIdEnum;
import org.apache.inlong.audit.MetricIdEnum;
import org.apache.inlong.audit.entity.AuditInformation;
import org.apache.inlong.audit.entity.CdcType;
import org.apache.inlong.audit.entity.FlowType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditManagerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditManagerUtils.class);
    public static final int AUDIT_SUFFIX_LENGTH = 16;
    public static final int AUDIT_MAX_PREFIX_LENGTH = 14;
    public static final String AUDIT_DESCRIPTION_JOINER = "_";

    private static String buildSuccessAndFailureFlag(boolean success) {
        return success ? "0" : "1";
    }

    private static String buildRealtimeFlag(boolean isRealtime) {
        return isRealtime ? "0" : "1";
    }

    private static String buildDiscardFlag(boolean discard) {
        return discard ? "1" : "0";
    }

    private static String buildRetryFlag(boolean retry) {
        return retry ? "1" : "0";
    }

    private static String buildAuditIdSuffix(int auditId) {
        StringBuilder auditIdBinaryString = new StringBuilder(Integer.toBinaryString(auditId));
        for (int i = auditIdBinaryString.length(); i < 16; ++i) {
            auditIdBinaryString.insert(0, "0");
        }
        return auditIdBinaryString.toString();
    }

    public static int buildAuditId(AuditIdEnum baseAuditId, boolean success, boolean isRealtime, boolean discard, boolean retry) {
        String auditPreFix = AuditManagerUtils.buildSuccessAndFailureFlag(success) + AuditManagerUtils.buildRealtimeFlag(isRealtime) + AuditManagerUtils.buildDiscardFlag(discard) + AuditManagerUtils.buildRetryFlag(retry);
        return Integer.parseInt(auditPreFix + AuditManagerUtils.buildAuditIdSuffix(baseAuditId.getValue()), 2);
    }

    public static AuditInformation buildAuditInformation(String auditType, FlowType flowType, boolean success, boolean isRealtime, boolean discard, boolean retry) {
        String auditPreFix = AuditManagerUtils.buildSuccessAndFailureFlag(success) + AuditManagerUtils.buildRealtimeFlag(isRealtime) + AuditManagerUtils.buildDiscardFlag(discard) + AuditManagerUtils.buildRetryFlag(retry);
        AuditIdEnum baseAuditId = AuditIdEnum.getAuditId(auditType, flowType);
        int auditId = Integer.parseInt(auditPreFix + AuditManagerUtils.buildAuditIdSuffix(baseAuditId.getValue()), 2);
        StringBuilder nameInEnglish = new StringBuilder().append(baseAuditId.getAuditType().value()).append(AUDIT_DESCRIPTION_JOINER).append(flowType.getNameInEnglish()).append(AUDIT_DESCRIPTION_JOINER);
        StringBuilder nameInChinese = new StringBuilder().append(baseAuditId.getAuditType().value()).append(flowType.getNameInChinese());
        if (discard) {
            nameInEnglish.append("discard").append(AUDIT_DESCRIPTION_JOINER);
            nameInChinese.append("\u4e22\u5f03");
        }
        if (retry) {
            nameInEnglish.append("retry").append(AUDIT_DESCRIPTION_JOINER);
            nameInChinese.append("\u91cd\u8bd5");
        }
        if (success) {
            nameInEnglish.append("success");
            nameInChinese.append("\u6210\u529f");
        } else {
            nameInEnglish.append("failed");
            nameInChinese.append("\u5931\u8d25");
        }
        if (!isRealtime) {
            nameInEnglish.append("(CheckPoint)");
            nameInChinese.append("(CheckPoint)");
        }
        return new AuditInformation(auditId, nameInEnglish.toString(), nameInChinese.toString());
    }

    public static List<AuditInformation> getAllAuditInformation() {
        LinkedList<AuditInformation> auditInformationList = new LinkedList<AuditInformation>();
        for (AuditIdEnum auditIdEnum : AuditIdEnum.values()) {
            auditInformationList.addAll(AuditManagerUtils.combineAuditInformation(auditIdEnum.getAuditType().value(), auditIdEnum.getFlowType()));
        }
        return auditInformationList;
    }

    public static List<AuditInformation> getAllMetricInformation() {
        LinkedList<AuditInformation> metricInformationList = new LinkedList<AuditInformation>();
        for (MetricIdEnum metricIdEnum : MetricIdEnum.values()) {
            metricInformationList.add(new AuditInformation(metricIdEnum.getValue(), metricIdEnum.getEnglishDescription(), metricIdEnum.getChineseDescription()));
        }
        return metricInformationList;
    }

    public static List<AuditInformation> getAllAuditInformation(String auditType) {
        LinkedList<AuditInformation> auditInformationList = new LinkedList<AuditInformation>();
        for (AuditIdEnum auditIdEnum : AuditIdEnum.values()) {
            if (!auditIdEnum.getAuditType().value().equals(auditType)) continue;
            auditInformationList.addAll(AuditManagerUtils.combineAuditInformation(auditIdEnum.getAuditType().value(), auditIdEnum.getFlowType()));
        }
        return auditInformationList;
    }

    private static List<AuditInformation> combineAuditInformation(String auditType, FlowType flowType) {
        boolean[] combinations;
        LinkedList<AuditInformation> auditInformationList = new LinkedList<AuditInformation>();
        for (boolean success : combinations = new boolean[]{true, false}) {
            for (boolean isRealtime : combinations) {
                for (boolean discard : combinations) {
                    for (boolean retry : combinations) {
                        if (!AuditManagerUtils.shouldIncludeCombination(auditType, flowType, success, isRealtime, discard, retry)) continue;
                        auditInformationList.add(AuditManagerUtils.buildAuditInformation(auditType, flowType, success, isRealtime, discard, retry));
                    }
                }
            }
        }
        return auditInformationList;
    }

    private static boolean shouldIncludeCombination(String auditType, FlowType flowType, boolean success, boolean isRealtime, boolean discard, boolean retry) {
        if (discard && retry) {
            return false;
        }
        AuditIdEnum baseAuditId = AuditIdEnum.getAuditId(auditType, flowType);
        if (!isRealtime && AuditManagerUtils.isExcludedWhenNotRealtime(baseAuditId)) {
            return false;
        }
        if (!success && flowType == FlowType.INPUT && (discard || retry)) {
            return false;
        }
        if (!success && flowType == FlowType.OUTPUT && discard) {
            return false;
        }
        return !success || flowType != FlowType.INPUT || !retry;
    }

    private static boolean isExcludedWhenNotRealtime(AuditIdEnum baseAuditId) {
        return baseAuditId == AuditIdEnum.SDK_INPUT || baseAuditId == AuditIdEnum.SDK_OUTPUT || baseAuditId == AuditIdEnum.AGENT_INPUT || baseAuditId == AuditIdEnum.AGENT_OUTPUT || baseAuditId == AuditIdEnum.DATA_PROXY_INPUT || baseAuditId == AuditIdEnum.DATA_PROXY_OUTPUT;
    }

    private static int getMaxAuditId() {
        return 0x40000000;
    }

    public static int getStartAuditIdForMetric() {
        return AuditManagerUtils.getMaxAuditId() + 0;
    }

    public static int getStartAuditIdForCdcInput() {
        return AuditManagerUtils.getMaxAuditId() + 100000;
    }

    public static int getStartAuditIdForCdcOutput() {
        return AuditManagerUtils.getMaxAuditId() + 200000;
    }

    public static List<AuditInformation> getAllCdcIdInformation() {
        ArrayList<AuditInformation> result = new ArrayList<AuditInformation>(FlowType.values().length * CdcIdEnum.values().length);
        for (FlowType flowType : FlowType.values()) {
            for (CdcIdEnum cdcIdEnum : CdcIdEnum.values()) {
                result.add(AuditManagerUtils.createAuditInformation(cdcIdEnum, flowType));
            }
        }
        return result;
    }

    public static int getCdcId(String auditType, FlowType flowType, CdcType cdcType) {
        return CdcIdEnum.getCdcId(auditType, flowType, cdcType);
    }

    public static List<AuditInformation> getAllCdcIdInformation(String auditType) {
        ArrayList<AuditInformation> result = new ArrayList<AuditInformation>(FlowType.values().length * CdcIdEnum.values().length);
        for (FlowType flowType : FlowType.values()) {
            for (CdcIdEnum cdcIdEnum : CdcIdEnum.values()) {
                if (!cdcIdEnum.getAuditType().value().equals(auditType)) continue;
                result.add(AuditManagerUtils.createAuditInformation(cdcIdEnum, flowType));
            }
        }
        return result;
    }

    public static List<AuditInformation> getAllCdcIdInformation(String auditType, FlowType flowType) {
        ArrayList<AuditInformation> result = new ArrayList<AuditInformation>(CdcIdEnum.values().length);
        for (CdcIdEnum cdcIdEnum : CdcIdEnum.values()) {
            if (!cdcIdEnum.getAuditType().value().equals(auditType)) continue;
            result.add(AuditManagerUtils.createAuditInformation(cdcIdEnum, flowType));
        }
        return result;
    }

    public static AuditInformation getCdcIdInformation(String auditType, FlowType flowType, CdcType cdcType) {
        for (CdcIdEnum cdcIdEnum : CdcIdEnum.values()) {
            if (!cdcIdEnum.getAuditType().value().equals(auditType) || cdcIdEnum.getCdcType() != cdcType) continue;
            return AuditManagerUtils.createAuditInformation(cdcIdEnum, flowType);
        }
        return null;
    }

    private static AuditInformation createAuditInformation(CdcIdEnum cdcIdEnum, FlowType flowType) {
        return new AuditInformation(cdcIdEnum.getValue(flowType), cdcIdEnum.getEnglishDescription(flowType), cdcIdEnum.getChineseDescription(flowType));
    }
}

