/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkUtils.class);
    private static String localIp = NetworkUtils.getLocalIp();

    public static String getLocalIp() {
        if (StringUtils.isNotBlank(localIp)) {
            return localIp;
        }
        String ip = "127.0.0.1";
        try {
            Enumeration<NetworkInterface> allInterface = NetworkInterface.getNetworkInterfaces();
            while (allInterface.hasMoreElements()) {
                NetworkInterface oneInterface = allInterface.nextElement();
                if (oneInterface.isLoopback() || !oneInterface.isUp() || oneInterface.isVirtual()) continue;
                Enumeration<InetAddress> allAddress = oneInterface.getInetAddresses();
                while (allAddress.hasMoreElements()) {
                    InetAddress oneAddress = allAddress.nextElement();
                    localIp = oneAddress.getHostAddress();
                    if (StringUtils.isEmpty(localIp) || localIp.equals("127.0.0.1") || localIp.contains(":")) continue;
                    return localIp;
                }
            }
        }
        catch (SocketException e) {
            LOGGER.error("error while get local ip", e);
        }
        localIp = ip;
        return localIp;
    }
}

