/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.common.util.ListUtil;

public class SortConfigUtil {
    public static <T, R> List<T> checkDelete(List<T> last, List<T> current, Function<T, R> keyExtractor) {
        return ListUtil.subtract(last, current, keyExtractor);
    }

    public static <T, R> List<T> checkNew(List<T> last, List<T> current, Function<T, R> keyExtractor) {
        return ListUtil.subtract(current, last, keyExtractor);
    }

    public static <T, R, N extends Comparable<? super N>> List<T> checkUpdate(List<T> last, List<T> current, Function<T, R> keyExtractor, Function<T, N> versionExtractor) {
        List<R> intersection = ListUtil.intersectionKey(last, current, keyExtractor);
        Map lastMap = ListUtil.toMap(last, keyExtractor);
        Map currentMap = ListUtil.toMap(current, keyExtractor);
        return intersection.stream().map(key -> {
            Object lastElement = lastMap.get(key);
            Object currentElement = currentMap.get(key);
            Comparator comparator = Comparator.comparing(versionExtractor);
            return comparator.compare(lastElement, currentElement) < 0 ? currentElement : null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T, R, N extends Comparable<? super N>> List<T> checkLatest(List<T> last, List<T> current, Function<T, R> keyExtractor, Function<T, N> versionExtractor) {
        return Stream.of(SortConfigUtil.checkUpdate(last, current, keyExtractor, versionExtractor), SortConfigUtil.checkNoUpdate(last, current, keyExtractor, versionExtractor), SortConfigUtil.checkNew(last, current, keyExtractor)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static <T, R, N extends Comparable<? super N>> List<T> checkNoUpdate(List<T> last, List<T> current, Function<T, R> keyExtractor, Function<T, N> versionExtractor) {
        List<R> intersection = ListUtil.intersectionKey(last, current, keyExtractor);
        Map lastMap = ListUtil.toMap(last, keyExtractor);
        Map currentMap = ListUtil.toMap(current, keyExtractor);
        return intersection.stream().map(key -> {
            Object lastElement = lastMap.get(key);
            Object currentElement = currentMap.get(key);
            Comparator comparator = Comparator.comparing(versionExtractor);
            return comparator.compare(lastElement, currentElement) >= 0 ? lastElement : null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T, R> List<T> batchCheckDeleteRecursive(List<T> last, List<T> current, Function<T, R> keyExtractor, BiFunction<T, T, T> innerCheckDeleteFunction) {
        if (CollectionUtils.isEmpty(last)) {
            return null;
        }
        if (CollectionUtils.isEmpty(current)) {
            return last;
        }
        List<T> deleteByKey = SortConfigUtil.checkDelete(last, current, keyExtractor);
        List<T> deleteInner = SortConfigUtil.batchCheckRecursive(last, current, keyExtractor, innerCheckDeleteFunction);
        return ListUtil.union(deleteInner, deleteByKey);
    }

    public static <T, R> List<T> batchCheckUpdateRecursive(List<T> last, List<T> current, Function<T, R> keyExtractor, BiFunction<T, T, T> innerCheckUpdateFunction) {
        List<R> intersectionKey = ListUtil.intersectionKey(last, current, keyExtractor);
        if (CollectionUtils.isEmpty(intersectionKey)) {
            return null;
        }
        return SortConfigUtil.batchCheckRecursive(last, current, keyExtractor, innerCheckUpdateFunction);
    }

    public static <T, R> List<T> batchCheckNoUpdateRecursive(List<T> last, List<T> current, Function<T, R> keyExtractor, BiFunction<T, T, T> innerCheckNoUpdateFunction) {
        List<R> intersectionKey = ListUtil.intersectionKey(last, current, keyExtractor);
        if (CollectionUtils.isEmpty(intersectionKey)) {
            return null;
        }
        return SortConfigUtil.batchCheckRecursive(last, current, keyExtractor, innerCheckNoUpdateFunction);
    }

    public static <T, R> List<T> batchCheckNewRecursive(List<T> last, List<T> current, Function<T, R> keyExtractor, BiFunction<T, T, T> innerCheckNewFunction) {
        if (CollectionUtils.isEmpty(last)) {
            return current;
        }
        if (CollectionUtils.isEmpty(current)) {
            return null;
        }
        List<T> newByKey = SortConfigUtil.checkNew(last, current, keyExtractor);
        List<T> newInner = SortConfigUtil.batchCheckRecursive(last, current, keyExtractor, innerCheckNewFunction);
        return ListUtil.union(newInner, newByKey);
    }

    public static <T, R, N extends Comparable<? super N>> List<T> batchCheckLatestRecursive(List<T> last, List<T> current, Function<T, R> keyExtractor, BiFunction<T, T, T> singleCheckLatestFunction) {
        if (CollectionUtils.isEmpty(last)) {
            return current;
        }
        if (CollectionUtils.isEmpty(current)) {
            return null;
        }
        List<T> newByKey = SortConfigUtil.checkNew(current, last, keyExtractor);
        List<T> latestInner = SortConfigUtil.batchCheckRecursive(last, current, keyExtractor, singleCheckLatestFunction);
        return ListUtil.union(latestInner, newByKey);
    }

    private static <T, R> List<T> batchCheckRecursive(List<T> last, List<T> current, Function<T, R> keyExtractor, BiFunction<T, T, T> singleCheckFunction) {
        List<R> intersectionKey = ListUtil.intersectionKey(last, current, keyExtractor);
        if (CollectionUtils.isEmpty(intersectionKey)) {
            return null;
        }
        Map lastMap = ListUtil.toMap(last, keyExtractor);
        Map currentMap = ListUtil.toMap(current, keyExtractor);
        return intersectionKey.stream().map(tag -> singleCheckFunction.apply(lastMap.get(tag), currentMap.get(tag))).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

