/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.inlongmsg;

import org.apache.inlong.common.pojo.sort.dataflow.field.format.FormatInfo;
import org.apache.inlong.sort.formats.inlongmsg.FailureHandler;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgBody;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgHead;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoOpFailureHandler
implements FailureHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NoOpFailureHandler.class);

    @Override
    public void onParsingMsgFailure(Object msg, Exception t2) throws Exception {
        LOG.error("Could not properly serialize msg=[{}].", msg, (Object)t2);
        throw t2;
    }

    @Override
    public void onParsingHeadFailure(String attribute, Exception exception) throws Exception {
        LOG.error("Cannot properly parse the head {}", (Object)attribute, (Object)exception);
        throw exception;
    }

    @Override
    public void onParsingBodyFailure(InLongMsgHead head, byte[] body, Exception exception) throws Exception {
        LOG.error("Cannot properly parse the head: {}, the body: {}.", head, new String(body), exception);
        throw exception;
    }

    @Override
    public void onConvertingRowFailure(InLongMsgHead head, InLongMsgBody body, Exception exception) throws Exception {
        LOG.error("Cannot properly convert the InLongMsg ({}, {})", head, body, exception);
        throw exception;
    }

    @Override
    public void onConvertingFieldFailure(String fieldName, String fieldText, FormatInfo formatInfo, Exception exception) throws Exception {
        LOG.warn("Cannot convert the InLongMsg Filed (fieldName = {}, formatInfo = {}, fieldText = {}),", fieldName, formatInfo, fieldText, exception);
    }

    @Override
    public boolean isIgnoreFailure() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }
}

