/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.load;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.InlongMetric;
import org.apache.inlong.sort.protocol.enums.FilterStrategy;
import org.apache.inlong.sort.protocol.enums.SchemaChangePolicy;
import org.apache.inlong.sort.protocol.enums.SchemaChangeType;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.node.format.Format;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.apache.inlong.sort.protocol.transformation.FilterFunction;
import org.apache.inlong.sort.util.SchemaChangeUtils;

@JsonTypeName(value="dorisLoadNode")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DorisLoadNode
extends LoadNode
implements InlongMetric,
Serializable {
    private static final long serialVersionUID = -8002903269814211382L;
    @JsonProperty(value="feNodes")
    @Nonnull
    private String feNodes;
    @JsonProperty(value="username")
    @Nonnull
    private String userName;
    @JsonProperty(value="password")
    @Nonnull
    private String password;
    @JsonProperty(value="tableIdentifier")
    @Nullable
    private String tableIdentifier;
    @JsonProperty(value="primaryKey")
    private String primaryKey;
    @Nullable
    @JsonProperty(value="sinkMultipleEnable")
    private Boolean sinkMultipleEnable = false;
    @Nullable
    @JsonProperty(value="sinkMultipleFormat")
    private Format sinkMultipleFormat;
    @Nullable
    @JsonProperty(value="databasePattern")
    private String databasePattern;
    @Nullable
    @JsonProperty(value="tablePattern")
    private String tablePattern;
    @JsonProperty(value="enableSchemaChange")
    private boolean enableSchemaChange;
    @Nullable
    @JsonProperty(value="policyMap")
    private Map<SchemaChangeType, SchemaChangePolicy> policyMap;

    public DorisLoadNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @JsonProperty(value="fieldRelations") List<FieldRelation> fieldRelations, @JsonProperty(value="filters") List<FilterFunction> filters, @JsonProperty(value="filterStrategy") FilterStrategy filterStrategy, @Nullable @JsonProperty(value="sinkParallelism") Integer sinkParallelism, @JsonProperty(value="properties") Map<String, String> properties, @Nonnull @JsonProperty(value="feNodes") String feNodes, @Nonnull @JsonProperty(value="username") String userName, @Nonnull @JsonProperty(value="password") String password, @Nonnull @JsonProperty(value="tableIdentifier") String tableIdentifier, @JsonProperty(value="primaryKey") String primaryKey) {
        this(id, name, fields, fieldRelations, filters, filterStrategy, sinkParallelism, properties, feNodes, userName, password, tableIdentifier, primaryKey, null, null, null, null);
    }

    public DorisLoadNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @JsonProperty(value="fieldRelations") List<FieldRelation> fieldRelations, @JsonProperty(value="filters") List<FilterFunction> filters, @JsonProperty(value="filterStrategy") FilterStrategy filterStrategy, @Nullable @JsonProperty(value="sinkParallelism") Integer sinkParallelism, @JsonProperty(value="properties") Map<String, String> properties, @Nonnull @JsonProperty(value="feNodes") String feNodes, @Nonnull @JsonProperty(value="username") String userName, @Nonnull @JsonProperty(value="password") String password, @Nullable @JsonProperty(value="tableIdentifier") String tableIdentifier, @JsonProperty(value="primaryKey") String primaryKey, @Nullable @JsonProperty(value="sinkMultipleEnable", defaultValue="false") Boolean sinkMultipleEnable, @Nullable @JsonProperty(value="sinkMultipleFormat") Format sinkMultipleFormat, @Nullable @JsonProperty(value="databasePattern") String databasePattern, @Nullable @JsonProperty(value="tablePattern") String tablePattern) {
        this(id, name, fields, fieldRelations, filters, filterStrategy, sinkParallelism, properties, feNodes, userName, password, tableIdentifier, primaryKey, sinkMultipleEnable, sinkMultipleFormat, databasePattern, tablePattern, false, null);
    }

    @JsonCreator
    public DorisLoadNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @JsonProperty(value="fieldRelations") List<FieldRelation> fieldRelations, @JsonProperty(value="filters") List<FilterFunction> filters, @JsonProperty(value="filterStrategy") FilterStrategy filterStrategy, @Nullable @JsonProperty(value="sinkParallelism") Integer sinkParallelism, @JsonProperty(value="properties") Map<String, String> properties, @Nonnull @JsonProperty(value="feNodes") String feNodes, @Nonnull @JsonProperty(value="username") String userName, @Nonnull @JsonProperty(value="password") String password, @Nullable @JsonProperty(value="tableIdentifier") String tableIdentifier, @JsonProperty(value="primaryKey") String primaryKey, @Nullable @JsonProperty(value="sinkMultipleEnable", defaultValue="false") Boolean sinkMultipleEnable, @Nullable @JsonProperty(value="sinkMultipleFormat") Format sinkMultipleFormat, @Nullable @JsonProperty(value="databasePattern") String databasePattern, @Nullable @JsonProperty(value="tablePattern") String tablePattern, @JsonProperty(value="enableSchemaChange") boolean enableSchemaChange, @Nullable @JsonProperty(value="policyMap") Map<SchemaChangeType, SchemaChangePolicy> policyMap) {
        super(id, name, fields, fieldRelations, filters, filterStrategy, sinkParallelism, properties);
        this.feNodes = Preconditions.checkNotNull(feNodes, "feNodes is null");
        this.userName = Preconditions.checkNotNull(userName, "username is null");
        this.password = Preconditions.checkNotNull(password, "password is null");
        this.primaryKey = primaryKey;
        this.sinkMultipleEnable = sinkMultipleEnable;
        if (sinkMultipleEnable == null || !sinkMultipleEnable.booleanValue()) {
            this.tableIdentifier = Preconditions.checkNotNull(tableIdentifier, "tableIdentifier is null");
        } else {
            this.databasePattern = Preconditions.checkNotNull(databasePattern, "databasePattern is null");
            this.tablePattern = Preconditions.checkNotNull(tablePattern, "tablePattern is null");
            this.sinkMultipleFormat = Preconditions.checkNotNull(sinkMultipleFormat, "sinkMultipleFormat is null");
        }
        this.enableSchemaChange = enableSchemaChange;
        this.policyMap = policyMap;
        Preconditions.checkState(!enableSchemaChange || policyMap != null && !policyMap.isEmpty(), "policyMap is empty when enableSchemaChange is 'true'");
    }

    @Override
    public Map<String, String> tableOptions() {
        Map<String, String> options = super.tableOptions();
        options.put("connector", "doris-inlong");
        options.put("fenodes", this.feNodes);
        options.put("username", this.userName);
        options.put("password", this.password);
        if (this.sinkMultipleEnable != null && this.sinkMultipleEnable.booleanValue()) {
            options.put("sink.multiple.enable", this.sinkMultipleEnable.toString());
            options.put("sink.multiple.format", Objects.requireNonNull(this.sinkMultipleFormat).identifier());
            options.put("sink.multiple.database-pattern", this.databasePattern);
            options.put("sink.multiple.table-pattern", this.tablePattern);
            if (this.enableSchemaChange) {
                options.put("sink.schema-change.enable", "true");
                options.put("sink.schema-change.policies", SchemaChangeUtils.serialize(this.policyMap));
            }
        } else {
            options.put("sink.multiple.enable", "false");
            options.put("table.identifier", this.tableIdentifier);
        }
        return options;
    }

    @Override
    public String genTableName() {
        return String.format("table_%s", super.getId());
    }

    @Override
    public String getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DorisLoadNode)) {
            return false;
        }
        DorisLoadNode other = (DorisLoadNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isEnableSchemaChange() != other.isEnableSchemaChange()) {
            return false;
        }
        Boolean this$sinkMultipleEnable = this.getSinkMultipleEnable();
        Boolean other$sinkMultipleEnable = other.getSinkMultipleEnable();
        if (this$sinkMultipleEnable == null ? other$sinkMultipleEnable != null : !((Object)this$sinkMultipleEnable).equals(other$sinkMultipleEnable)) {
            return false;
        }
        String this$feNodes = this.getFeNodes();
        String other$feNodes = other.getFeNodes();
        if (this$feNodes == null ? other$feNodes != null : !this$feNodes.equals(other$feNodes)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$tableIdentifier = this.getTableIdentifier();
        String other$tableIdentifier = other.getTableIdentifier();
        if (this$tableIdentifier == null ? other$tableIdentifier != null : !this$tableIdentifier.equals(other$tableIdentifier)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        Format this$sinkMultipleFormat = this.getSinkMultipleFormat();
        Format other$sinkMultipleFormat = other.getSinkMultipleFormat();
        if (this$sinkMultipleFormat == null ? other$sinkMultipleFormat != null : !this$sinkMultipleFormat.equals(other$sinkMultipleFormat)) {
            return false;
        }
        String this$databasePattern = this.getDatabasePattern();
        String other$databasePattern = other.getDatabasePattern();
        if (this$databasePattern == null ? other$databasePattern != null : !this$databasePattern.equals(other$databasePattern)) {
            return false;
        }
        String this$tablePattern = this.getTablePattern();
        String other$tablePattern = other.getTablePattern();
        if (this$tablePattern == null ? other$tablePattern != null : !this$tablePattern.equals(other$tablePattern)) {
            return false;
        }
        Map<SchemaChangeType, SchemaChangePolicy> this$policyMap = this.getPolicyMap();
        Map<SchemaChangeType, SchemaChangePolicy> other$policyMap = other.getPolicyMap();
        return !(this$policyMap == null ? other$policyMap != null : !((Object)this$policyMap).equals(other$policyMap));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DorisLoadNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isEnableSchemaChange() ? 79 : 97);
        Boolean $sinkMultipleEnable = this.getSinkMultipleEnable();
        result = result * 59 + ($sinkMultipleEnable == null ? 43 : ((Object)$sinkMultipleEnable).hashCode());
        String $feNodes = this.getFeNodes();
        result = result * 59 + ($feNodes == null ? 43 : $feNodes.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $tableIdentifier = this.getTableIdentifier();
        result = result * 59 + ($tableIdentifier == null ? 43 : $tableIdentifier.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        Format $sinkMultipleFormat = this.getSinkMultipleFormat();
        result = result * 59 + ($sinkMultipleFormat == null ? 43 : $sinkMultipleFormat.hashCode());
        String $databasePattern = this.getDatabasePattern();
        result = result * 59 + ($databasePattern == null ? 43 : $databasePattern.hashCode());
        String $tablePattern = this.getTablePattern();
        result = result * 59 + ($tablePattern == null ? 43 : $tablePattern.hashCode());
        Map<SchemaChangeType, SchemaChangePolicy> $policyMap = this.getPolicyMap();
        result = result * 59 + ($policyMap == null ? 43 : ((Object)$policyMap).hashCode());
        return result;
    }

    @Nonnull
    public String getFeNodes() {
        return this.feNodes;
    }

    @Nonnull
    public String getUserName() {
        return this.userName;
    }

    @Nonnull
    public String getPassword() {
        return this.password;
    }

    @Nullable
    public String getTableIdentifier() {
        return this.tableIdentifier;
    }

    @Nullable
    public Boolean getSinkMultipleEnable() {
        return this.sinkMultipleEnable;
    }

    @Nullable
    public Format getSinkMultipleFormat() {
        return this.sinkMultipleFormat;
    }

    @Nullable
    public String getDatabasePattern() {
        return this.databasePattern;
    }

    @Nullable
    public String getTablePattern() {
        return this.tablePattern;
    }

    public boolean isEnableSchemaChange() {
        return this.enableSchemaChange;
    }

    @Nullable
    public Map<SchemaChangeType, SchemaChangePolicy> getPolicyMap() {
        return this.policyMap;
    }

    public void setFeNodes(@Nonnull String feNodes) {
        if (feNodes == null) {
            throw new NullPointerException("feNodes is marked non-null but is null");
        }
        this.feNodes = feNodes;
    }

    public void setUserName(@Nonnull String userName) {
        if (userName == null) {
            throw new NullPointerException("userName is marked non-null but is null");
        }
        this.userName = userName;
    }

    public void setPassword(@Nonnull String password) {
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        this.password = password;
    }

    public void setTableIdentifier(@Nullable String tableIdentifier) {
        this.tableIdentifier = tableIdentifier;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setSinkMultipleEnable(@Nullable Boolean sinkMultipleEnable) {
        this.sinkMultipleEnable = sinkMultipleEnable;
    }

    public void setSinkMultipleFormat(@Nullable Format sinkMultipleFormat) {
        this.sinkMultipleFormat = sinkMultipleFormat;
    }

    public void setDatabasePattern(@Nullable String databasePattern) {
        this.databasePattern = databasePattern;
    }

    public void setTablePattern(@Nullable String tablePattern) {
        this.tablePattern = tablePattern;
    }

    public void setEnableSchemaChange(boolean enableSchemaChange) {
        this.enableSchemaChange = enableSchemaChange;
    }

    public void setPolicyMap(@Nullable Map<SchemaChangeType, SchemaChangePolicy> policyMap) {
        this.policyMap = policyMap;
    }

    @Override
    public String toString() {
        return "DorisLoadNode(feNodes=" + this.getFeNodes() + ", userName=" + this.getUserName() + ", password=" + this.getPassword() + ", tableIdentifier=" + this.getTableIdentifier() + ", primaryKey=" + this.getPrimaryKey() + ", sinkMultipleEnable=" + this.getSinkMultipleEnable() + ", sinkMultipleFormat=" + this.getSinkMultipleFormat() + ", databasePattern=" + this.getDatabasePattern() + ", tablePattern=" + this.getTablePattern() + ", enableSchemaChange=" + this.isEnableSchemaChange() + ", policyMap=" + this.getPolicyMap() + ")";
    }

    public DorisLoadNode() {
    }
}

