/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.load;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.InlongMetric;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.apache.inlong.sort.protocol.transformation.FilterFunction;

@JsonTypeName(value="fileSystemLoad")
public class FileSystemLoadNode
extends LoadNode
implements InlongMetric,
Serializable {
    private static final long serialVersionUID = -4836034838166667371L;
    private static final String trigger = "sink.partition-commit.trigger";
    private static final String delay = "sink.partition-commit.delay";
    private static final String policyKind = "sink.partition-commit.policy.kind";
    private static final String waterMarkZone = "sink.partition-commit.watermark-time-zone";
    private static final String rollingRolloverInterval = "sink.rolling-policy.rollover-interval";
    private static final String rollingPolicyFileSize = "sink.rolling-policy.file-size";
    @JsonProperty(value="format")
    @Nonnull
    private String format;
    @JsonProperty(value="path")
    @Nonnull
    private String path;
    @JsonProperty(value="partitionFields")
    private List<FieldInfo> partitionFields;
    @JsonProperty(value="tempTableName")
    private String tempTableName;
    @JsonProperty(value="serverTimeZone")
    private String serverTimeZone;

    @JsonCreator
    public FileSystemLoadNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @JsonProperty(value="fieldRelations") List<FieldRelation> fieldRelations, @JsonProperty(value="filters") List<FilterFunction> filters, @Nonnull @JsonProperty(value="path") String path, @Nonnull @JsonProperty(value="format") String format, @Nullable @JsonProperty(value="sinkParallelism") Integer sinkParallelism, @JsonProperty(value="properties") Map<String, String> properties, @JsonProperty(value="parFields") List<FieldInfo> partitionFields, @JsonProperty(value="serverTimeZone") String serverTimeZone) {
        super(id, name, fields, fieldRelations, filters, null, sinkParallelism, properties);
        this.format = Preconditions.checkNotNull(format, "format type is null");
        this.path = Preconditions.checkNotNull(path, "path is null");
        this.partitionFields = partitionFields;
        this.tempTableName = name;
        this.serverTimeZone = serverTimeZone;
    }

    @Override
    public Map<String, String> tableOptions() {
        Map<String, String> map = super.tableOptions();
        map.put("connector", "filesystem-inlong");
        map.put("path", this.path);
        map.put("format", this.format);
        if (null != this.partitionFields) {
            Map<String, String> properties = super.getProperties();
            if (null == properties || !properties.containsKey(trigger)) {
                map.put(trigger, "process-time");
            }
            if (null == properties || !properties.containsKey(delay)) {
                map.put(delay, "10s");
            }
            if (null == properties || !properties.containsKey(policyKind)) {
                map.put(policyKind, "metastore,success-file");
            }
        }
        if (!map.containsKey(rollingRolloverInterval)) {
            map.put(rollingRolloverInterval, "1min");
        }
        if (!map.containsKey(rollingPolicyFileSize)) {
            map.put(rollingPolicyFileSize, "128MB");
        }
        if (null != this.serverTimeZone && !map.containsKey(waterMarkZone)) {
            map.put(waterMarkZone, this.serverTimeZone);
        }
        return map;
    }

    @Override
    public String genTableName() {
        return "node_" + super.getId() + "_" + this.tempTableName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileSystemLoadNode)) {
            return false;
        }
        FileSystemLoadNode other = (FileSystemLoadNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        List<FieldInfo> this$partitionFields = this.getPartitionFields();
        List<FieldInfo> other$partitionFields = other.getPartitionFields();
        if (this$partitionFields == null ? other$partitionFields != null : !((Object)this$partitionFields).equals(other$partitionFields)) {
            return false;
        }
        String this$tempTableName = this.getTempTableName();
        String other$tempTableName = other.getTempTableName();
        if (this$tempTableName == null ? other$tempTableName != null : !this$tempTableName.equals(other$tempTableName)) {
            return false;
        }
        String this$serverTimeZone = this.getServerTimeZone();
        String other$serverTimeZone = other.getServerTimeZone();
        return !(this$serverTimeZone == null ? other$serverTimeZone != null : !this$serverTimeZone.equals(other$serverTimeZone));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FileSystemLoadNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        List<FieldInfo> $partitionFields = this.getPartitionFields();
        result = result * 59 + ($partitionFields == null ? 43 : ((Object)$partitionFields).hashCode());
        String $tempTableName = this.getTempTableName();
        result = result * 59 + ($tempTableName == null ? 43 : $tempTableName.hashCode());
        String $serverTimeZone = this.getServerTimeZone();
        result = result * 59 + ($serverTimeZone == null ? 43 : $serverTimeZone.hashCode());
        return result;
    }

    @Nonnull
    public String getFormat() {
        return this.format;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Override
    public List<FieldInfo> getPartitionFields() {
        return this.partitionFields;
    }

    public String getTempTableName() {
        return this.tempTableName;
    }

    public String getServerTimeZone() {
        return this.serverTimeZone;
    }

    public void setFormat(@Nonnull String format) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        this.format = format;
    }

    public void setPath(@Nonnull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        this.path = path;
    }

    public void setPartitionFields(List<FieldInfo> partitionFields) {
        this.partitionFields = partitionFields;
    }

    public void setTempTableName(String tempTableName) {
        this.tempTableName = tempTableName;
    }

    public void setServerTimeZone(String serverTimeZone) {
        this.serverTimeZone = serverTimeZone;
    }

    @Override
    public String toString() {
        return "FileSystemLoadNode(format=" + this.getFormat() + ", path=" + this.getPath() + ", partitionFields=" + this.getPartitionFields() + ", tempTableName=" + this.getTempTableName() + ", serverTimeZone=" + this.getServerTimeZone() + ")";
    }

    public FileSystemLoadNode() {
    }
}

