/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Random;
import oracle.security.crypto.provider.TransitionMode;
import oracle.security.pki.BadPaddingException;
import oracle.security.pki.CipherSpi;
import oracle.security.pki.IllegalBlockSizeException;
import oracle.security.pki.NoSuchPaddingException;
import oracle.security.pki.ShortBufferException;

abstract class BlockCipher
extends CipherSpi {
    protected int a = 8;
    protected byte[] b;
    protected boolean c = true;
    protected Random d;
    protected AlgorithmParameterSpec e;
    private int f;
    private int g = 0;
    private int h = 1;
    private byte[] i;
    private int j;
    private byte[] k;
    private byte[] l;
    private static final int m = 0;
    private static final int n = 1;
    private static final int o = 2;
    private static final int p = 0;
    private static final int q = 1;
    private static final int r = 2;
    private static final int s = 3;

    protected abstract void a(Key var1, AlgorithmParameterSpec var2, boolean var3) throws InvalidKeyException, InvalidAlgorithmParameterException;

    protected abstract void a(Key var1, AlgorithmParameters var2, boolean var3) throws InvalidKeyException, InvalidAlgorithmParameterException;

    protected abstract String a();

    protected abstract void a(byte[] var1, byte[] var2);

    protected abstract void b(byte[] var1, byte[] var2);

    protected void a(String string) throws NoSuchAlgorithmException {
        if (string.equals("CBC")) {
            this.g = 0;
            this.c = true;
        } else if (string.equals("ECB")) {
            this.g = 1;
            this.c = false;
        } else if (string.equals("CFB")) {
            this.g = 2;
            this.c = true;
        } else {
            throw new NoSuchAlgorithmException("Mode " + string + " is unsupported");
        }
    }

    protected void b(String string) throws NoSuchPaddingException {
        if (string.equals("PKCS5Padding")) {
            this.h = 2;
        } else if (string.equals("NoPadding")) {
            this.h = 0;
        } else if (string.equals("ZeroesPadding")) {
            this.h = 1;
        } else if (string.equals("Zeroes")) {
            this.h = 1;
        } else if (string.equals("OraclePadding")) {
            this.h = 3;
        } else {
            throw new NoSuchPaddingException("Padding " + string + " is unsupported");
        }
    }

    protected int b() {
        return this.a;
    }

    protected int a(int n) {
        int n2 = n + this.j;
        if (this.f == 1) {
            n2 += this.a - n2 % this.a;
            if (this.h == 3) {
                ++n2;
            }
        }
        return n2;
    }

    protected byte[] c() {
        TransitionMode.checkCryptoCoreUseAllowed();
        if (this.b == null) {
            return null;
        }
        byte[] byArray = new byte[this.b.length];
        System.arraycopy(this.b, 0, byArray, 0, this.b.length);
        return byArray;
    }

    protected AlgorithmParameters d() {
        if (this.e == null) {
            return null;
        }
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(this.a());
            algorithmParameters.init(this.e);
            return algorithmParameters;
        }
        catch (Exception exception) {
            throw new InternalError("Unsupport AlgorithmParameters");
        }
    }

    protected void a(int n, Key key, Random random) throws InvalidKeyException {
        try {
            this.e = null;
            this.a(n, key, this.e, random);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException("Algorithm Parameter needed for this cipher");
        }
    }

    protected void a(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, Random random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.a(n, random, algorithmParameterSpec == null);
        this.a(key, algorithmParameterSpec, this.g == 2 ? true : this.f == 1);
        this.e();
    }

    protected void a(int n, Key key, AlgorithmParameters algorithmParameters, Random random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.a(n, random, algorithmParameters == null);
        this.a(key, algorithmParameters, this.g == 2 ? true : this.f == 1);
        this.e();
    }

    protected byte[] a(byte[] byArray, int n, int n2) {
        byte[] byArray2 = null;
        try {
            byte[] byArray3 = new byte[this.a(n2)];
            int n3 = this.a(byArray, n, n2, byArray3, 0);
            byArray2 = new byte[n3];
            System.arraycopy(byArray3, 0, byArray2, 0, n3);
        }
        catch (ShortBufferException shortBufferException) {
            shortBufferException.printStackTrace();
        }
        return byArray2;
    }

    protected int a(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        int n4;
        if (n2 == 0 || byArray == null || byArray2 == null) {
            return 0;
        }
        if (n2 + n > byArray.length || n3 > byArray2.length) {
            throw new ShortBufferException("Invalid input from the parameters");
        }
        if (byArray2.length - n3 < this.a(n2)) {
            throw new ShortBufferException("Output buffer is too short for this operation");
        }
        if (n2 > this.a && this.c(byArray, n, n2)) {
            throw new ShortBufferException("Illegal operation - double encryption detected");
        }
        int n5 = n2 + this.j;
        int n6 = this.a;
        if (this.f == 2 && this.h != 0 && this.h != 3) {
            ++n6;
        }
        if (n5 < n6) {
            System.arraycopy(byArray, n, this.i, this.j, n2);
            this.j += n2;
            return 0;
        }
        byte[] byArray3 = new byte[n5];
        System.arraycopy(this.i, 0, byArray3, 0, this.j);
        System.arraycopy(byArray, n, byArray3, this.j, n2);
        for (n4 = 0; n4 <= n5 - this.a; n4 += this.a) {
            byte[] byArray4 = new byte[this.a];
            System.arraycopy(byArray3, n4, byArray4, 0, this.a);
            this.j = 0;
            if (this.f == 1) {
                this.a(byArray4, this.g, byArray2, n3 + n4);
                continue;
            }
            if (this.h != 0 && this.h != 3 && n2 == n4 + this.a) {
                System.arraycopy(byArray3, n4, this.i, 0, this.a);
                this.j = this.a;
                return n4;
            }
            this.b(byArray4, this.g, byArray2, n3 + n4);
        }
        this.k = new byte[n4];
        System.arraycopy(byArray2, n3, this.k, 0, n4);
        this.j = n5 % this.a;
        if (this.j > 0) {
            System.arraycopy(byArray3, n4, this.i, 0, this.j);
        }
        return n4;
    }

    protected int b(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (n2 > 0 && (n > byArray.length || n + n2 > byArray.length || n3 > byArray2.length)) {
            throw new ShortBufferException("Invalid input from the parameters");
        }
        if (byArray2.length - n3 < this.a(n2)) {
            throw new ShortBufferException("Output buffer is too short for this operation");
        }
        int n4 = 0;
        if (n2 > 0) {
            n4 = this.a(byArray, n, n2, byArray2, n3);
        }
        if (this.h == 0 && this.j > 0 && this.f == 1) {
            throw new IllegalBlockSizeException("Padding not required but the buffer still remains");
        }
        if (this.j == 0 && (this.h == 1 || this.h == 0 || this.h == 3)) {
            if (this.h == 3 && this.f == 1) {
                byArray2[n4++] = 1;
            }
            this.e();
            return n4;
        }
        if (this.f == 1) {
            int n5 = this.a(this.i);
            this.a(this.i, this.g, byArray2, n3 + n4);
            if (this.h == 3) {
                byArray2[n4++ + this.a] = (byte)(n5 + 1);
            }
            this.e();
            return n4 + this.a;
        }
        if (this.h == 3) {
            if (this.j != 1) {
                throw new IllegalBlockSizeException("Decrypted data length is not 1+ multiple of 8");
            }
            byte by = this.i[0];
            this.e();
            return n4 + 1 - by;
        }
        if (this.j != 0 && this.j != this.a) {
            throw new BadPaddingException("Decrypted data length is not multiple of 8");
        }
        if (this.j == 0) {
            return n4;
        }
        this.b(this.i, this.g, byArray2, n3 + n4);
        if ((n4 += this.a) > 0) {
            int n6 = this.a(byArray2, n3 + n4);
            this.e();
            return n4 - n6;
        }
        return 0;
    }

    protected byte[] b(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2 = null;
        try {
            byte[] byArray3 = new byte[this.a(n2)];
            int n3 = this.b(byArray, n, n2, byArray3, 0);
            byArray2 = new byte[n3];
            System.arraycopy(byArray3, 0, byArray2, 0, n3);
        }
        catch (ShortBufferException shortBufferException) {
            throw new IllegalBlockSizeException(shortBufferException.toString());
        }
        return byArray2;
    }

    private void a(int n, Random random, boolean bl) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (n != 1 && n != 2) {
            throw new InvalidKeyException("operation is not supported");
        }
        this.f = n;
        this.d = random;
        if (this.c) {
            if (bl && n == 2) {
                throw new InvalidAlgorithmParameterException("Parameters is required for this mode");
            }
            if (random == null) {
                try {
                    this.d = new Random();
                }
                catch (Exception exception) {
                    throw new InternalError("Cannot find Random");
                }
            }
        }
    }

    private void e() {
        this.i = new byte[this.a];
        this.j = 0;
        if (this.c) {
            this.l = new byte[this.a];
            if (this.b == null) {
                throw new InternalError("IV is required but not initialized");
            }
            System.arraycopy(this.b, 0, this.l, 0, this.a);
        }
    }

    private void a(byte[] byArray, int n, byte[] byArray2, int n2) {
        TransitionMode.checkCryptoCoreUseAllowed();
        byte[] byArray3 = new byte[this.a];
        switch (n) {
            case 0: {
                this.a(byArray, this.l, byArray, 0);
                this.a(byArray, this.l);
                break;
            }
            case 2: {
                this.a(this.l, byArray3);
                this.a(byArray, byArray3, this.l, 0);
                break;
            }
            default: {
                this.a(byArray, byArray3);
                System.arraycopy(byArray3, 0, byArray2, n2, this.a);
                return;
            }
        }
        System.arraycopy(this.l, 0, byArray2, n2, this.a);
    }

    private void b(byte[] byArray, int n, byte[] byArray2, int n2) {
        TransitionMode.checkCryptoCoreUseAllowed();
        byte[] byArray3 = new byte[this.a];
        switch (n) {
            case 0: {
                this.b(byArray, byArray3);
                this.a(this.l, byArray3, byArray2, n2);
                System.arraycopy(byArray, 0, this.l, 0, this.a);
                break;
            }
            case 1: {
                this.b(byArray, byArray3);
                System.arraycopy(byArray3, 0, byArray2, n2, this.a);
                break;
            }
            case 2: {
                this.a(this.l, byArray3);
                this.a(byArray, byArray3, byArray2, n2);
                System.arraycopy(byArray, 0, this.l, 0, this.a);
                break;
            }
            default: {
                this.b(byArray, byArray3);
                System.arraycopy(byArray3, 0, byArray2, n2, this.a);
            }
        }
    }

    private void a(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        for (int i = 0; i < this.a; ++i) {
            byArray3[i + n] = (byte)(byArray[i] ^ byArray2[i]);
        }
    }

    private int a(byte[] byArray) {
        int n = 0;
        switch (this.h) {
            case 0: {
                break;
            }
            case 2: {
                n = this.a - this.j;
                for (int i = 0; i < n; ++i) {
                    byArray[this.j + i] = (byte)n;
                }
                break;
            }
            default: {
                n = this.j == 0 ? 0 : this.a - this.j;
                for (int i = 0; i < n; ++i) {
                    byArray[this.j + i] = 0;
                }
            }
        }
        return n;
    }

    private int a(byte[] byArray, int n) throws BadPaddingException {
        int n2 = 0;
        switch (this.h) {
            case 0: {
                break;
            }
            case 1: {
                n2 = byArray[n - 1];
                if (n2 != 0) {
                    return 0;
                }
                while (n > 0 && byArray[--n] == 0) {
                    ++n2;
                }
                if (n2 < this.a) break;
                throw new BadPaddingException("Invalid padding pattern");
            }
            case 2: {
                n2 = byArray[n - 1];
                if (n2 < 1 || n2 > this.a) {
                    throw new BadPaddingException("Invalid padding - pad exceeds blocksize");
                }
                n -= n2;
                for (int i = 0; i < n2; ++i) {
                    if (byArray[n + i] == n2) continue;
                    throw new BadPaddingException("Invalid pattern in PKCS5Padding");
                }
                break;
            }
            default: {
                throw new BadPaddingException("Unsupported padding mode");
            }
        }
        return n2;
    }

    private boolean c(byte[] byArray, int n, int n2) {
        if (this.k == null) {
            return false;
        }
        int n3 = n2 > this.k.length ? this.k.length : n2;
        for (int i = 0; i < n3; ++i) {
            if (this.k[i] == byArray[n + i]) continue;
            return false;
        }
        return true;
    }
}

