/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd.parser;

import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.CommandParsers;
import com.moilioncircle.redis.replicator.cmd.impl.XSetIdCommand;
import com.moilioncircle.redis.replicator.util.Strings;

public class XSetIdParser
implements CommandParser<XSetIdCommand> {
    @Override
    public XSetIdCommand parse(Object[] command) {
        int idx = 1;
        byte[] key = CommandParsers.toBytes(command[idx]);
        byte[] id = CommandParsers.toBytes(command[++idx]);
        ++idx;
        Long entriesAdded = null;
        byte[] maxDeletedEntryId = null;
        while (idx < command.length) {
            String next;
            if (Strings.isEquals(next = CommandParsers.toRune(command[idx++]), "ENTRIESADDED")) {
                entriesAdded = CommandParsers.toLong(command[idx++]);
                continue;
            }
            if (Strings.isEquals(next, "MAXDELETEDID")) {
                maxDeletedEntryId = CommandParsers.toBytes(command[idx++]);
                continue;
            }
            throw new UnsupportedOperationException(next);
        }
        return new XSetIdCommand(key, id, entriesAdded, maxDeletedEntryId);
    }
}

