/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class Keys<T> {
    public abstract int getNumberOfKeyFields();

    public abstract int[] computeLogicalKeyPositions();

    public abstract TypeInformation<?>[] getKeyFieldTypes();

    public abstract TypeInformation<?>[] getOriginalKeyFieldTypes();

    public abstract <E> void validateCustomPartitioner(Partitioner<E> var1, TypeInformation<E> var2);

    public boolean isEmpty() {
        return this.getNumberOfKeyFields() == 0;
    }

    public boolean areCompatible(Keys<?> other) throws IncompatibleKeysException {
        TypeInformation<?>[] otherKeyFieldTypes;
        TypeInformation<?>[] thisKeyFieldTypes = this.getKeyFieldTypes();
        if (thisKeyFieldTypes.length != (otherKeyFieldTypes = other.getKeyFieldTypes()).length) {
            throw new IncompatibleKeysException("The number of specified keys is different.");
        }
        for (int i = 0; i < thisKeyFieldTypes.length; ++i) {
            if (thisKeyFieldTypes[i].equals(otherKeyFieldTypes[i])) continue;
            throw new IncompatibleKeysException(thisKeyFieldTypes[i], otherKeyFieldTypes[i]);
        }
        return true;
    }

    private static int[] createIncrIntArray(int numKeys) {
        int[] keyFields = new int[numKeys];
        for (int i = 0; i < numKeys; ++i) {
            keyFields[i] = i;
        }
        return keyFields;
    }

    private static void rangeCheckFields(int[] fields, int maxAllowedField) {
        for (int f : fields) {
            if (f >= 0 && f <= maxAllowedField) continue;
            throw new IndexOutOfBoundsException("Tuple position is out of range: " + f);
        }
    }

    public static class IncompatibleKeysException
    extends Exception {
        private static final long serialVersionUID = 1L;
        public static final String SIZE_MISMATCH_MESSAGE = "The number of specified keys is different.";

        public IncompatibleKeysException(String message) {
            super(message);
        }

        public IncompatibleKeysException(TypeInformation<?> typeInformation, TypeInformation<?> typeInformation2) {
            super(typeInformation + " and " + typeInformation2 + " are not compatible");
        }
    }

    public static class ExpressionKeys<T>
    extends Keys<T> {
        public static final String SELECT_ALL_CHAR = "*";
        public static final String SELECT_ALL_CHAR_SCALA = "_";
        private static final Pattern WILD_CARD_REGEX = Pattern.compile("[\\.]?(\\*|\\_)$");
        private List<CompositeType.FlatFieldDescriptor> keyFields;
        private TypeInformation<?>[] originalKeyTypes;

        public ExpressionKeys(TypeInformation<T> type) {
            this(SELECT_ALL_CHAR, type);
        }

        public ExpressionKeys(int keyPosition, TypeInformation<T> type) {
            this(new int[]{keyPosition}, type, false);
        }

        public ExpressionKeys(int[] keyPositions, TypeInformation<T> type) {
            this(keyPositions, type, false);
        }

        public ExpressionKeys(int[] keyPositions, TypeInformation<T> type, boolean allowEmpty) {
            if (!type.isTupleType() || !(type instanceof CompositeType)) {
                throw new InvalidProgramException("Specifying keys via field positions is only valid for tuple data types. Type: " + type);
            }
            if (type.getArity() == 0) {
                throw new InvalidProgramException("Tuple size must be greater than 0. Size: " + type.getArity());
            }
            if (!(allowEmpty || keyPositions != null && keyPositions.length != 0)) {
                throw new IllegalArgumentException("The grouping fields must not be empty.");
            }
            this.keyFields = new ArrayList<CompositeType.FlatFieldDescriptor>();
            if (keyPositions == null || keyPositions.length == 0) {
                keyPositions = Keys.createIncrIntArray(type.getArity());
            } else {
                Keys.rangeCheckFields(keyPositions, type.getArity() - 1);
            }
            Preconditions.checkArgument(keyPositions.length > 0, "Grouping fields can not be empty at this point");
            CompositeType cType = (CompositeType)type;
            this.keyFields = new ArrayList<CompositeType.FlatFieldDescriptor>(type.getTotalFields());
            String[] fieldNames = cType.getFieldNames();
            this.originalKeyTypes = new TypeInformation[keyPositions.length];
            ArrayList<CompositeType.FlatFieldDescriptor> tmpList = new ArrayList<CompositeType.FlatFieldDescriptor>();
            for (int i = 0; i < keyPositions.length; ++i) {
                int keyPos = keyPositions[i];
                tmpList.clear();
                this.originalKeyTypes[i] = cType.getTypeAt(keyPos);
                cType.getFlatFields(fieldNames[keyPos], 0, tmpList);
                for (CompositeType.FlatFieldDescriptor ffd : tmpList) {
                    if (ffd.getType().isKeyType()) continue;
                    throw new InvalidProgramException("This type (" + ffd.getType() + ") cannot be used as key.");
                }
                this.keyFields.addAll(tmpList);
            }
        }

        public ExpressionKeys(String keyExpression, TypeInformation<T> type) {
            this(new String[]{keyExpression}, type);
        }

        public ExpressionKeys(String[] keyExpressions, TypeInformation<T> type) {
            Preconditions.checkNotNull(keyExpressions, "Field expression cannot be null.");
            this.keyFields = new ArrayList<CompositeType.FlatFieldDescriptor>(keyExpressions.length);
            if (type instanceof CompositeType) {
                CompositeType cType = (CompositeType)type;
                this.originalKeyTypes = new TypeInformation[keyExpressions.length];
                for (int i = 0; i < keyExpressions.length; ++i) {
                    String keyExpr = keyExpressions[i];
                    if (keyExpr == null) {
                        throw new InvalidProgramException("Expression key may not be null.");
                    }
                    List<CompositeType.FlatFieldDescriptor> flatFields = cType.getFlatFields(keyExpr = keyExpr.trim());
                    if (flatFields.size() == 0) {
                        throw new InvalidProgramException("Unable to extract key from expression '" + keyExpr + "' on key " + cType);
                    }
                    for (CompositeType.FlatFieldDescriptor field : flatFields) {
                        if (field.getType().isKeyType()) continue;
                        throw new InvalidProgramException("This type (" + field.getType() + ") cannot be used as key.");
                    }
                    this.keyFields.addAll(flatFields);
                    String strippedKeyExpr = WILD_CARD_REGEX.matcher(keyExpr).replaceAll("");
                    this.originalKeyTypes[i] = strippedKeyExpr.isEmpty() ? type : cType.getTypeAt(strippedKeyExpr);
                }
            } else {
                if (!type.isKeyType()) {
                    throw new InvalidProgramException("This type (" + type + ") cannot be used as key.");
                }
                for (String keyExpr : keyExpressions) {
                    if (keyExpr == null) {
                        throw new InvalidProgramException("Expression key may not be null.");
                    }
                    if (!SELECT_ALL_CHAR.equals(keyExpr = keyExpr.trim()) && !SELECT_ALL_CHAR_SCALA.equals(keyExpr)) {
                        throw new InvalidProgramException("Field expression must be equal to '*' or '_' for non-composite types.");
                    }
                    this.keyFields.add(new CompositeType.FlatFieldDescriptor(0, type));
                }
                this.originalKeyTypes = new TypeInformation[]{type};
            }
        }

        @Override
        public int getNumberOfKeyFields() {
            if (this.keyFields == null) {
                return 0;
            }
            return this.keyFields.size();
        }

        @Override
        public int[] computeLogicalKeyPositions() {
            int[] logicalKeys = new int[this.keyFields.size()];
            for (int i = 0; i < this.keyFields.size(); ++i) {
                logicalKeys[i] = this.keyFields.get(i).getPosition();
            }
            return logicalKeys;
        }

        @Override
        public TypeInformation<?>[] getKeyFieldTypes() {
            TypeInformation[] fieldTypes = new TypeInformation[this.keyFields.size()];
            for (int i = 0; i < this.keyFields.size(); ++i) {
                fieldTypes[i] = this.keyFields.get(i).getType();
            }
            return fieldTypes;
        }

        @Override
        public TypeInformation<?>[] getOriginalKeyFieldTypes() {
            return this.originalKeyTypes;
        }

        @Override
        public <E> void validateCustomPartitioner(Partitioner<E> partitioner, TypeInformation<E> typeInfo) {
            TypeInformation<?> keyType;
            if (this.keyFields.size() != 1) {
                throw new InvalidProgramException("Custom partitioners can only be used with keys that have one key field.");
            }
            if (typeInfo == null) {
                try {
                    typeInfo = TypeExtractor.getPartitionerTypes(partitioner);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (typeInfo != null && !(typeInfo instanceof GenericTypeInfo) && !(keyType = this.keyFields.get(0).getType()).equals(typeInfo)) {
                throw new InvalidProgramException("The partitioner is incompatible with the key type. Partitioner type: " + typeInfo + " , key type: " + keyType);
            }
        }

        public String toString() {
            return "ExpressionKeys: " + StringUtils.join(this.keyFields, (char)'.');
        }

        public static boolean isSortKey(int fieldPos, TypeInformation<?> type) {
            if (!type.isTupleType() || !(type instanceof CompositeType)) {
                throw new InvalidProgramException("Specifying keys via field positions is only valid for tuple data types. Type: " + type);
            }
            if (type.getArity() == 0) {
                throw new InvalidProgramException("Tuple size must be greater than 0. Size: " + type.getArity());
            }
            if (fieldPos < 0 || fieldPos >= type.getArity()) {
                throw new IndexOutOfBoundsException("Tuple position is out of range: " + fieldPos);
            }
            TypeInformation sortKeyType = ((CompositeType)type).getTypeAt(fieldPos);
            return sortKeyType.isSortKeyType();
        }

        public static boolean isSortKey(String fieldExpr, TypeInformation<?> type) {
            TypeInformation<Object> sortKeyType;
            if (SELECT_ALL_CHAR.equals(fieldExpr = fieldExpr.trim()) || SELECT_ALL_CHAR_SCALA.equals(fieldExpr)) {
                sortKeyType = type;
            } else if (type instanceof CompositeType) {
                sortKeyType = ((CompositeType)type).getTypeAt(fieldExpr);
            } else {
                throw new InvalidProgramException("Field expression must be equal to '*' or '_' for atomic types.");
            }
            return sortKeyType.isSortKeyType();
        }
    }

    public static class SelectorFunctionKeys<T, K>
    extends Keys<T> {
        private final KeySelector<T, K> keyExtractor;
        private final TypeInformation<T> inputType;
        private final TypeInformation<K> keyType;
        private final List<CompositeType.FlatFieldDescriptor> keyFields;
        private final TypeInformation<?>[] originalKeyTypes;

        public SelectorFunctionKeys(KeySelector<T, K> keyExtractor, TypeInformation<T> inputType, TypeInformation<K> keyType) {
            if (keyExtractor == null) {
                throw new NullPointerException("Key extractor must not be null.");
            }
            if (keyType == null) {
                throw new NullPointerException("Key type must not be null.");
            }
            if (!keyType.isKeyType()) {
                throw new InvalidProgramException("Return type " + keyType + " of KeySelector " + keyExtractor.getClass() + " is not a valid key type");
            }
            this.keyExtractor = keyExtractor;
            this.inputType = inputType;
            this.keyType = keyType;
            this.originalKeyTypes = new TypeInformation[]{keyType};
            if (keyType instanceof CompositeType) {
                this.keyFields = ((CompositeType)keyType).getFlatFields("*");
            } else {
                this.keyFields = new ArrayList<CompositeType.FlatFieldDescriptor>(1);
                this.keyFields.add(new CompositeType.FlatFieldDescriptor(0, keyType));
            }
        }

        public TypeInformation<K> getKeyType() {
            return this.keyType;
        }

        public TypeInformation<T> getInputType() {
            return this.inputType;
        }

        public KeySelector<T, K> getKeyExtractor() {
            return this.keyExtractor;
        }

        @Override
        public int getNumberOfKeyFields() {
            return this.keyFields.size();
        }

        @Override
        public int[] computeLogicalKeyPositions() {
            int[] logicalKeys = new int[this.keyFields.size()];
            for (int i = 0; i < this.keyFields.size(); ++i) {
                logicalKeys[i] = this.keyFields.get(i).getPosition();
            }
            return logicalKeys;
        }

        @Override
        public TypeInformation<?>[] getKeyFieldTypes() {
            TypeInformation[] fieldTypes = new TypeInformation[this.keyFields.size()];
            for (int i = 0; i < this.keyFields.size(); ++i) {
                fieldTypes[i] = this.keyFields.get(i).getType();
            }
            return fieldTypes;
        }

        @Override
        public TypeInformation<?>[] getOriginalKeyFieldTypes() {
            return this.originalKeyTypes;
        }

        @Override
        public <E> void validateCustomPartitioner(Partitioner<E> partitioner, TypeInformation<E> typeInfo) {
            if (this.keyFields.size() != 1) {
                throw new InvalidProgramException("Custom partitioners can only be used with keys that have one key field.");
            }
            if (typeInfo == null) {
                try {
                    typeInfo = TypeExtractor.getPartitionerTypes(partitioner);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (typeInfo != null && !(typeInfo instanceof GenericTypeInfo) && !this.keyType.equals(typeInfo)) {
                throw new InvalidProgramException("The partitioner is incompatible with the key type. Partitioner type: " + typeInfo + " , key type: " + this.keyType);
            }
        }

        public String toString() {
            return "Key function (Type: " + this.keyType + ")";
        }
    }
}

