/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.internal;

import com.google.protobuf.GeneratedMessageV3;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.BatcherBuilder;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.GenericSchema;
import org.apache.pulsar.client.api.schema.RecordSchemaBuilder;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.api.schema.SchemaDefinitionBuilder;
import org.apache.pulsar.client.internal.ReflectionUtils;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.KeyValueEncodingType;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaInfoWithVersion;
import org.apache.pulsar.common.schema.SchemaType;

public final class DefaultImplementation {
    private static final Class<ClientBuilder> CLIENT_BUILDER_IMPL = ReflectionUtils.newClassInstance("org.apache.pulsar.client.impl.ClientBuilderImpl");
    private static final Constructor<MessageId> MESSAGE_ID_IMPL_long_long_int = ReflectionUtils.getConstructor("org.apache.pulsar.client.impl.MessageIdImpl", Long.TYPE, Long.TYPE, Integer.TYPE);
    private static final Method MESSAGE_ID_IMPL_fromByteArray = ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.MessageIdImpl", "fromByteArray", byte[].class);
    private static final Method MESSAGE_ID_IMPL_fromByteArrayWithTopic = ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.MessageIdImpl", "fromByteArrayWithTopic", byte[].class, String.class);
    private static final Constructor<Authentication> AUTHENTICATION_TOKEN_String = ReflectionUtils.getConstructor("org.apache.pulsar.client.impl.auth.AuthenticationToken", String.class);
    private static final Constructor<Authentication> AUTHENTICATION_TOKEN_Supplier = ReflectionUtils.getConstructor("org.apache.pulsar.client.impl.auth.AuthenticationToken", Supplier.class);
    private static final Constructor<Authentication> AUTHENTICATION_TLS_String_String = ReflectionUtils.getConstructor("org.apache.pulsar.client.impl.auth.AuthenticationTls", String.class, String.class);
    private static final Constructor<SchemaDefinitionBuilder> SCHEMA_DEFINITION_BUILDER_CONSTRUCTOR = ReflectionUtils.getConstructor("org.apache.pulsar.client.impl.schema.SchemaDefinitionBuilderImpl", new Class[0]);

    public static <T> SchemaDefinitionBuilder<T> newSchemaDefinitionBuilder() {
        return ReflectionUtils.catchExceptions(() -> SCHEMA_DEFINITION_BUILDER_CONSTRUCTOR.newInstance(new Object[0]));
    }

    public static ClientBuilder newClientBuilder() {
        return ReflectionUtils.catchExceptions(() -> CLIENT_BUILDER_IMPL.newInstance());
    }

    public static MessageId newMessageId(long ledgerId, long entryId, int partitionIndex) {
        return ReflectionUtils.catchExceptions(() -> MESSAGE_ID_IMPL_long_long_int.newInstance(ledgerId, entryId, partitionIndex));
    }

    public static MessageId newMessageIdFromByteArray(byte[] data) {
        return ReflectionUtils.catchExceptions(() -> (MessageId)MESSAGE_ID_IMPL_fromByteArray.invoke(null, new Object[]{data}));
    }

    public static MessageId newMessageIdFromByteArrayWithTopic(byte[] data, String topicName) {
        return ReflectionUtils.catchExceptions(() -> (MessageId)MESSAGE_ID_IMPL_fromByteArrayWithTopic.invoke(null, data, topicName));
    }

    public static Authentication newAuthenticationToken(String token) {
        return ReflectionUtils.catchExceptions(() -> AUTHENTICATION_TOKEN_String.newInstance(token));
    }

    public static Authentication newAuthenticationToken(Supplier<String> supplier) {
        return ReflectionUtils.catchExceptions(() -> AUTHENTICATION_TOKEN_Supplier.newInstance(supplier));
    }

    public static Authentication newAuthenticationTLS(String certFilePath, String keyFilePath) {
        return ReflectionUtils.catchExceptions(() -> AUTHENTICATION_TLS_String_String.newInstance(certFilePath, keyFilePath));
    }

    public static Authentication createAuthentication(String authPluginClassName, String authParamsString) throws PulsarClientException.UnsupportedAuthenticationException {
        return ReflectionUtils.catchExceptions(() -> (Authentication)ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.AuthenticationUtil", "create", String.class, String.class).invoke(null, authPluginClassName, authParamsString));
    }

    public static Authentication createAuthentication(String authPluginClassName, Map<String, String> authParams) throws PulsarClientException.UnsupportedAuthenticationException {
        return ReflectionUtils.catchExceptions(() -> (Authentication)ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.AuthenticationUtil", "create", String.class, Map.class).invoke(null, authPluginClassName, authParams));
    }

    public static Schema<byte[]> newBytesSchema() {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.newClassInstance("org.apache.pulsar.client.impl.schema.BytesSchema").newInstance());
    }

    public static Schema<String> newStringSchema() {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.newClassInstance("org.apache.pulsar.client.impl.schema.StringSchema").newInstance());
    }

    public static Schema<String> newStringSchema(Charset charset) {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.getConstructor("org.apache.pulsar.client.impl.schema.StringSchema", Charset.class).newInstance(charset));
    }

    public static Schema<Byte> newByteSchema() {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.newClassInstance("org.apache.pulsar.client.impl.schema.ByteSchema").newInstance());
    }

    public static Schema<Short> newShortSchema() {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.newClassInstance("org.apache.pulsar.client.impl.schema.ShortSchema").newInstance());
    }

    public static Schema<Integer> newIntSchema() {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.newClassInstance("org.apache.pulsar.client.impl.schema.IntSchema").newInstance());
    }

    public static Schema<Long> newLongSchema() {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.newClassInstance("org.apache.pulsar.client.impl.schema.LongSchema").newInstance());
    }

    public static Schema<Boolean> newBooleanSchema() {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.newClassInstance("org.apache.pulsar.client.impl.schema.BooleanSchema").newInstance());
    }

    public static Schema<ByteBuffer> newByteBufferSchema() {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.newClassInstance("org.apache.pulsar.client.impl.schema.ByteBufferSchema").newInstance());
    }

    public static Schema<Float> newFloatSchema() {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.newClassInstance("org.apache.pulsar.client.impl.schema.FloatSchema").newInstance());
    }

    public static Schema<Double> newDoubleSchema() {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.newClassInstance("org.apache.pulsar.client.impl.schema.DoubleSchema").newInstance());
    }

    public static Schema<Date> newDateSchema() {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.schema.DateSchema", "of", null).invoke(null, null));
    }

    public static Schema<Time> newTimeSchema() {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.schema.TimeSchema", "of", null).invoke(null, null));
    }

    public static Schema<Timestamp> newTimestampSchema() {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.schema.TimestampSchema", "of", null).invoke(null, null));
    }

    public static Schema<Instant> newInstantSchema() {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.schema.InstantSchema", "of", null).invoke(null, null));
    }

    public static Schema<LocalDate> newLocalDateSchema() {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.schema.LocalDateSchema", "of", null).invoke(null, null));
    }

    public static Schema<LocalTime> newLocalTimeSchema() {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.schema.LocalTimeSchema", "of", null).invoke(null, null));
    }

    public static Schema<LocalDateTime> newLocalDateTimeSchema() {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.schema.LocalDateTimeSchema", "of", null).invoke(null, null));
    }

    public static <T> Schema<T> newAvroSchema(SchemaDefinition schemaDefinition) {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.schema.AvroSchema", "of", SchemaDefinition.class).invoke(null, schemaDefinition));
    }

    public static <T extends GeneratedMessageV3> Schema<T> newProtobufSchema(SchemaDefinition schemaDefinition) {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.schema.ProtobufSchema", "of", SchemaDefinition.class).invoke(null, schemaDefinition));
    }

    public static <T extends GeneratedMessageV3> Schema<T> newProtobufNativeSchema(SchemaDefinition schemaDefinition) {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.schema.ProtobufNativeSchema", "of", SchemaDefinition.class).invoke(null, schemaDefinition));
    }

    public static <T> Schema<T> newJSONSchema(SchemaDefinition schemaDefinition) {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.schema.JSONSchema", "of", SchemaDefinition.class).invoke(null, schemaDefinition));
    }

    public static Schema<GenericRecord> newAutoConsumeSchema() {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.newClassInstance("org.apache.pulsar.client.impl.schema.AutoConsumeSchema").newInstance());
    }

    public static Schema<byte[]> newAutoProduceSchema() {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.newClassInstance("org.apache.pulsar.client.impl.schema.AutoProduceBytesSchema").newInstance());
    }

    public static Schema<byte[]> newAutoProduceSchema(Schema<?> schema) {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.getConstructor("org.apache.pulsar.client.impl.schema.AutoProduceBytesSchema", Schema.class).newInstance(schema));
    }

    public static Schema<KeyValue<byte[], byte[]>> newKeyValueBytesSchema() {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.schema.KeyValueSchemaImpl", "kvBytes", new Class[0]).invoke(null, new Object[0]));
    }

    public static <K, V> Schema<KeyValue<K, V>> newKeyValueSchema(Schema<K> keySchema, Schema<V> valueSchema) {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.schema.KeyValueSchemaImpl", "of", Schema.class, Schema.class).invoke(null, keySchema, valueSchema));
    }

    public static <K, V> Schema<KeyValue<K, V>> newKeyValueSchema(Schema<K> keySchema, Schema<V> valueSchema, KeyValueEncodingType keyValueEncodingType) {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.schema.KeyValueSchemaImpl", "of", Schema.class, Schema.class, KeyValueEncodingType.class).invoke(null, new Object[]{keySchema, valueSchema, keyValueEncodingType}));
    }

    public static <K, V> Schema<KeyValue<K, V>> newKeyValueSchema(Class<K> key, Class<V> value, SchemaType type) {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.schema.KeyValueSchemaImpl", "of", Class.class, Class.class, SchemaType.class).invoke(null, new Object[]{key, value, type}));
    }

    public static Schema<?> getSchema(SchemaInfo schemaInfo) {
        return ReflectionUtils.catchExceptions(() -> (Schema)ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.schema.AutoConsumeSchema", "getSchema", SchemaInfo.class).invoke(null, schemaInfo));
    }

    public static GenericSchema<GenericRecord> getGenericSchema(SchemaInfo schemaInfo) {
        switch (schemaInfo.getType()) {
            case PROTOBUF_NATIVE: {
                return ReflectionUtils.catchExceptions(() -> (GenericSchema)ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.schema.generic.GenericProtobufNativeSchema", "of", SchemaInfo.class).invoke(null, schemaInfo));
            }
        }
        return ReflectionUtils.catchExceptions(() -> (GenericSchema)ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.schema.generic.GenericSchemaImpl", "of", SchemaInfo.class).invoke(null, schemaInfo));
    }

    public static RecordSchemaBuilder newRecordSchemaBuilder(String name) {
        return ReflectionUtils.catchExceptions(() -> (RecordSchemaBuilder)ReflectionUtils.getConstructor("org.apache.pulsar.client.impl.schema.RecordSchemaBuilderImpl", String.class).newInstance(name));
    }

    public static KeyValueEncodingType decodeKeyValueEncodingType(SchemaInfo schemaInfo) {
        return ReflectionUtils.catchExceptions(() -> (KeyValueEncodingType)((Object)((Object)ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.schema.KeyValueSchemaInfo", "decodeKeyValueEncodingType", SchemaInfo.class).invoke(null, schemaInfo))));
    }

    public static <K, V> SchemaInfo encodeKeyValueSchemaInfo(Schema<K> keySchema, Schema<V> valueSchema, KeyValueEncodingType keyValueEncodingType) {
        return DefaultImplementation.encodeKeyValueSchemaInfo("KeyValue", keySchema, valueSchema, keyValueEncodingType);
    }

    public static <K, V> SchemaInfo encodeKeyValueSchemaInfo(String schemaName, Schema<K> keySchema, Schema<V> valueSchema, KeyValueEncodingType keyValueEncodingType) {
        return ReflectionUtils.catchExceptions(() -> (SchemaInfo)ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.schema.KeyValueSchemaInfo", "encodeKeyValueSchemaInfo", String.class, Schema.class, Schema.class, KeyValueEncodingType.class).invoke(null, new Object[]{schemaName, keySchema, valueSchema, keyValueEncodingType}));
    }

    public static KeyValue<SchemaInfo, SchemaInfo> decodeKeyValueSchemaInfo(SchemaInfo schemaInfo) {
        return ReflectionUtils.catchExceptions(() -> (KeyValue)ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.schema.KeyValueSchemaInfo", "decodeKeyValueSchemaInfo", SchemaInfo.class).invoke(null, schemaInfo));
    }

    public static String jsonifySchemaInfo(SchemaInfo schemaInfo) {
        return ReflectionUtils.catchExceptions(() -> (String)ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.schema.SchemaUtils", "jsonifySchemaInfo", SchemaInfo.class).invoke(null, schemaInfo));
    }

    public static String jsonifySchemaInfoWithVersion(SchemaInfoWithVersion schemaInfoWithVersion) {
        return ReflectionUtils.catchExceptions(() -> (String)ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.schema.SchemaUtils", "jsonifySchemaInfoWithVersion", SchemaInfoWithVersion.class).invoke(null, schemaInfoWithVersion));
    }

    public static String jsonifyKeyValueSchemaInfo(KeyValue<SchemaInfo, SchemaInfo> kvSchemaInfo) {
        return ReflectionUtils.catchExceptions(() -> (String)ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.schema.SchemaUtils", "jsonifyKeyValueSchemaInfo", KeyValue.class).invoke(null, kvSchemaInfo));
    }

    public static String convertKeyValueSchemaInfoDataToString(KeyValue<SchemaInfo, SchemaInfo> kvSchemaInfo) {
        return ReflectionUtils.catchExceptions(() -> (String)ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.schema.SchemaUtils", "convertKeyValueSchemaInfoDataToString", KeyValue.class).invoke(null, kvSchemaInfo));
    }

    public static byte[] convertKeyValueDataStringToSchemaInfoSchema(byte[] keyValueSchemaInfoDataJsonBytes) {
        return ReflectionUtils.catchExceptions(() -> (byte[])ReflectionUtils.getStaticMethod("org.apache.pulsar.client.impl.schema.SchemaUtils", "convertKeyValueDataStringToSchemaInfoSchema", byte[].class).invoke(null, new Object[]{keyValueSchemaInfoDataJsonBytes}));
    }

    public static BatcherBuilder newDefaultBatcherBuilder() {
        return ReflectionUtils.catchExceptions(() -> (BatcherBuilder)ReflectionUtils.getConstructor("org.apache.pulsar.client.impl.DefaultBatcherBuilder", new Class[0]).newInstance(new Object[0]));
    }

    public static BatcherBuilder newKeyBasedBatcherBuilder() {
        return ReflectionUtils.catchExceptions(() -> (BatcherBuilder)ReflectionUtils.getConstructor("org.apache.pulsar.client.impl.KeyBasedBatcherBuilder", new Class[0]).newInstance(new Object[0]));
    }

    public static byte[] getBytes(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        if (byteBuffer.hasArray() && byteBuffer.arrayOffset() == 0 && byteBuffer.array().length == byteBuffer.remaining()) {
            return byteBuffer.array();
        }
        byte[] array = new byte[byteBuffer.remaining()];
        byteBuffer.get(array);
        return array;
    }

    public static SchemaInfo newSchemaInfoImpl(String name, byte[] schema, SchemaType type, Map<String, String> propertiesValue) {
        return ReflectionUtils.catchExceptions(() -> (SchemaInfo)ReflectionUtils.getConstructor("org.apache.pulsar.client.impl.schema.SchemaInfoImpl", String.class, byte[].class, SchemaType.class, Map.class).newInstance(new Object[]{name, schema, type, propertiesValue}));
    }

    private DefaultImplementation() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

