/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.network.SocketServer;
import kafka.network.SocketServer$;
import kafka.raft.KafkaFuturePurgatory;
import kafka.raft.KafkaFuturePurgatory$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.KafkaNetworkChannel;
import kafka.security.CredentialProvider;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRequestHandlerPool;
import kafka.server.KafkaServer$;
import kafka.server.LogDirFailureChannel;
import kafka.tools.RaftSocketServer;
import kafka.tools.TestRaftRequestHandler;
import kafka.tools.TestRaftServer$;
import kafka.utils.CoreUtils$;
import kafka.utils.KafkaScheduler;
import kafka.utils.KafkaScheduler$;
import kafka.utils.Logging;
import kafka.utils.ShutdownableThread;
import kafka.utils.ShutdownableThread$;
import kafka.utils.timer.SystemTimer;
import kafka.utils.timer.SystemTimer$;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.FileBasedStateStore;
import org.apache.kafka.raft.KafkaRaftClient;
import org.apache.kafka.raft.NetworkChannel;
import org.apache.kafka.raft.QuorumState;
import org.apache.kafka.raft.QuorumStateStore;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.raft.ReplicatedLog;
import scala.Function0;
import scala.Predef$;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t-e\u0001\u0002\u001d:\u0001yB\u0001b\u0013\u0001\u0003\u0006\u0004%\t\u0001\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005\u001b\")A\u000b\u0001C\u0001+\"9\u0011\f\u0001b\u0001\n\u0013Q\u0006B\u00024\u0001A\u0003%1\fC\u0004h\u0001\t\u0007I\u0011\u00025\t\r9\u0004\u0001\u0015!\u0003j\u0011\u001dy\u0007A1A\u0005\nADaa\u001f\u0001!\u0002\u0013\t\b\"\u0003?\u0001\u0001\u0004\u0005\r\u0011\"\u0001~\u0011-\tI\u0001\u0001a\u0001\u0002\u0004%\t!a\u0003\t\u0015\u0005]\u0001\u00011A\u0001B\u0003&a\u0010C\u0006\u0002\u001a\u0001\u0001\r\u00111A\u0005\u0002\u0005m\u0001bCA\u0015\u0001\u0001\u0007\t\u0019!C\u0001\u0003WA1\"a\f\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u001e!Y\u0011\u0011\u0007\u0001A\u0002\u0003\u0007I\u0011AA\u001a\u0011-\tY\u0005\u0001a\u0001\u0002\u0004%\t!!\u0014\t\u0017\u0005E\u0003\u00011A\u0001B\u0003&\u0011Q\u0007\u0005\f\u0003'\u0002\u0001\u0019!a\u0001\n\u0003\t)\u0006C\u0006\u0002^\u0001\u0001\r\u00111A\u0005\u0002\u0005}\u0003bCA2\u0001\u0001\u0007\t\u0011)Q\u0005\u0003/B1\"!\u001a\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002h!Y\u0011q\u000e\u0001A\u0002\u0003\u0007I\u0011AA9\u0011-\t)\b\u0001a\u0001\u0002\u0003\u0006K!!\u001b\t\u0017\u0005]\u0004\u00011AA\u0002\u0013\u0005\u0011\u0011\u0010\u0005\f\u0003\u000b\u0003\u0001\u0019!a\u0001\n\u0003\t9\tC\u0006\u0002\f\u0002\u0001\r\u0011!Q!\n\u0005m\u0004bCAG\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u001fC1\"a1\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002F\"Y\u0011\u0011\u001a\u0001A\u0002\u0003\u0005\u000b\u0015BAI\u0011-\tY\r\u0001a\u0001\u0002\u0004%\t!!4\t\u0017\u0005e\u0007\u00011AA\u0002\u0013\u0005\u00111\u001c\u0005\f\u0003?\u0004\u0001\u0019!A!B\u0013\ty\rC\u0006\u0002b\u0002\u0001\r\u00111A\u0005\u0002\u0005\r\bbCAv\u0001\u0001\u0007\t\u0019!C\u0001\u0003[D1\"!=\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002f\"9\u00111\u001f\u0001\u0005\u0002\u0005M\u0006bBA{\u0001\u0011\u0005\u00111\u0017\u0005\b\u0003o\u0004A\u0011AAZ\u0011\u001d\tI\u0010\u0001C\u0005\u0003wDqA!\u0005\u0001\t\u0013\u0011\u0019\u0002C\u0004\u0003&\u0001!IAa\n\t\u000f\t\u0015\u0003\u0001\"\u0003\u0003H!9!1\u000b\u0001\u0005\n\tUcABAK\u0001\u0001\t9\n\u0003\u0006\u0002 6\u0012\t\u0011)A\u0005\u0003CCa\u0001V\u0017\u0005\u0002\u00055\u0006bBAY[\u0011\u0005\u00131\u0017\u0005\b\u0003kkC\u0011IA\\\u0011\u001d\ty,\fC!\u0003\u0003<qAa\u001a:\u0011\u0003\u0011IG\u0002\u00049s!\u0005!1\u000e\u0005\u0007)R\"\tA!\u001c\t\u000f\t=D\u0007\"\u0001\u0003r!9!Q\u0011\u001b\u0005\u0002\t\u001d%A\u0004+fgR\u0014\u0016M\u001a;TKJ4XM\u001d\u0006\u0003um\nQ\u0001^8pYNT\u0011\u0001P\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001q(\u0012\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0002\u0005\u0006)1oY1mC&\u0011A)\u0011\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0019KU\"A$\u000b\u0005![\u0014!B;uS2\u001c\u0018B\u0001&H\u0005\u001daunZ4j]\u001e\faaY8oM&<W#A'\u0011\u00059\u000bV\"A(\u000b\u0005A[\u0014AB:feZ,'/\u0003\u0002S\u001f\nY1*\u00194lC\u000e{gNZ5h\u0003\u001d\u0019wN\u001c4jO\u0002\na\u0001P5oSRtDC\u0001,Y!\t9\u0006!D\u0001:\u0011\u0015Y5\u00011\u0001N\u0003%\u0001\u0018M\u001d;ji&|g.F\u0001\\!\taF-D\u0001^\u0015\tqv,\u0001\u0004d_6lwN\u001c\u0006\u0003y\u0001T!!\u00192\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0017aA8sO&\u0011Q-\u0018\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003)\u0001\u0018M\u001d;ji&|g\u000eI\u0001\u0005i&lW-F\u0001j!\tQG.D\u0001l\u0015\tAU,\u0003\u0002nW\n!A+[7f\u0003\u0015!\u0018.\\3!\u00035\u0019\b.\u001e;e_^tG*\u0019;dQV\t\u0011\u000f\u0005\u0002ss6\t1O\u0003\u0002uk\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005Y<\u0018\u0001B;uS2T\u0011\u0001_\u0001\u0005U\u00064\u0018-\u0003\u0002{g\nq1i\\;oi\u0012{wO\u001c'bi\u000eD\u0017AD:ikR$wn\u001e8MCR\u001c\u0007\u000eI\u0001\rg>\u001c7.\u001a;TKJ4XM]\u000b\u0002}B\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002w\u00059a.\u001a;x_J\\\u0017\u0002BA\u0004\u0003\u0003\u0011AbU8dW\u0016$8+\u001a:wKJ\f\u0001c]8dW\u0016$8+\u001a:wKJ|F%Z9\u0015\t\u00055\u00111\u0003\t\u0004\u0001\u0006=\u0011bAA\t\u0003\n!QK\\5u\u0011!\t)bCA\u0001\u0002\u0004q\u0018a\u0001=%c\u0005i1o\\2lKR\u001cVM\u001d<fe\u0002\n!c\u0019:fI\u0016tG/[1m!J|g/\u001b3feV\u0011\u0011Q\u0004\t\u0005\u0003?\t)#\u0004\u0002\u0002\")\u0019\u00111E\u001e\u0002\u0011M,7-\u001e:jifLA!a\n\u0002\"\t\u00112I]3eK:$\u0018.\u00197Qe>4\u0018\u000eZ3s\u0003Y\u0019'/\u001a3f]RL\u0017\r\u001c)s_ZLG-\u001a:`I\u0015\fH\u0003BA\u0007\u0003[A\u0011\"!\u0006\u000f\u0003\u0003\u0005\r!!\b\u0002'\r\u0014X\rZ3oi&\fG\u000e\u0015:pm&$WM\u001d\u0011\u0002\u0015Q|7.\u001a8DC\u000eDW-\u0006\u0002\u00026A!\u0011qGA$\u001b\t\tID\u0003\u0003\u0002<\u0005u\u0012!C5oi\u0016\u0014h.\u00197t\u0015\u0011\ty$!\u0011\u0002\u0015\u0011,G.Z4bi&|gN\u0003\u0003\u0002D\u0005\u0015\u0013!\u0002;pW\u0016t'bAA\u0012;&!\u0011\u0011JA\u001d\u0005Q!U\r\\3hCRLwN\u001c+pW\u0016t7)Y2iK\u0006qAo\\6f]\u000e\u000b7\r[3`I\u0015\fH\u0003BA\u0007\u0003\u001fB\u0011\"!\u0006\u0012\u0003\u0003\u0005\r!!\u000e\u0002\u0017Q|7.\u001a8DC\u000eDW\rI\u0001\u001cI\u0006$\u0018\r\u00157b]\u0016\u0014V-];fgRD\u0015M\u001c3mKJ\u0004vn\u001c7\u0016\u0005\u0005]\u0003c\u0001(\u0002Z%\u0019\u00111L(\u0003/-\u000bgm[1SKF,Xm\u001d;IC:$G.\u001a:Q_>d\u0017a\b3bi\u0006\u0004F.\u00198f%\u0016\fX/Z:u\u0011\u0006tG\r\\3s!>|Gn\u0018\u0013fcR!\u0011QBA1\u0011%\t)\u0002FA\u0001\u0002\u0004\t9&\u0001\u000feCR\f\u0007\u000b\\1oKJ+\u0017/^3ti\"\u000bg\u000e\u001a7feB{w\u000e\u001c\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014XCAA5!\r1\u00151N\u0005\u0004\u0003[:%AD&bM.\f7k\u00195fIVdWM]\u0001\u000eg\u000eDW\rZ;mKJ|F%Z9\u0015\t\u00055\u00111\u000f\u0005\n\u0003+9\u0012\u0011!a\u0001\u0003S\n!b]2iK\u0012,H.\u001a:!\u0003\u001diW\r\u001e:jGN,\"!a\u001f\u0011\t\u0005u\u0014\u0011Q\u0007\u0003\u0003\u007fR1!a\u001e^\u0013\u0011\t\u0019)a \u0003\u000f5+GO]5dg\u0006YQ.\u001a;sS\u000e\u001cx\fJ3r)\u0011\ti!!#\t\u0013\u0005U!$!AA\u0002\u0005m\u0014\u0001C7fiJL7m\u001d\u0011\u0002\u0019I\fg\r^%p)\"\u0014X-\u00193\u0016\u0005\u0005E\u0005cAAJ[5\t\u0001A\u0001\u0007SC\u001a$\u0018j\u001c+ie\u0016\fGmE\u0002.\u00033\u00032ARAN\u0013\r\tij\u0012\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fG-\u0001\u0004dY&,g\u000e\u001e\t\u0005\u0003G\u000bI+\u0004\u0002\u0002&*\u0019\u0011qU0\u0002\tI\fg\r^\u0005\u0005\u0003W\u000b)KA\bLC\u001a\\\u0017MU1gi\u000ec\u0017.\u001a8u)\u0011\t\t*a,\t\u000f\u0005}u\u00061\u0001\u0002\"\u00061Am\\,pe.$\"!!\u0004\u0002!%t\u0017\u000e^5bi\u0016\u001c\u0006.\u001e;e_^tGCAA]!\r\u0001\u00151X\u0005\u0004\u0003{\u000b%a\u0002\"p_2,\u0017M\\\u0001\nSN\u0014VO\u001c8j]\u001e,\"!!/\u0002!I\fg\r^%p)\"\u0014X-\u00193`I\u0015\fH\u0003BA\u0007\u0003\u000fD\u0011\"!\u0006\u001e\u0003\u0003\u0005\r!!%\u0002\u001bI\fg\r^%p)\"\u0014X-\u00193!\u00039qW\r^<pe.\u001c\u0005.\u00198oK2,\"!a4\u0011\t\u0005E\u0017Q[\u0007\u0003\u0003'T1!a*<\u0013\u0011\t9.a5\u0003'-\u000bgm[1OKR<xN]6DQ\u0006tg.\u001a7\u0002%9,Go^8sW\u000eC\u0017M\u001c8fY~#S-\u001d\u000b\u0005\u0003\u001b\ti\u000eC\u0005\u0002\u0016\u0001\n\t\u00111\u0001\u0002P\u0006ya.\u001a;x_J\\7\t[1o]\u0016d\u0007%A\u0006nKR\fG-\u0019;b\u0019><WCAAs!\u0011\t\t.a:\n\t\u0005%\u00181\u001b\u0002\u0011\u0017\u000647.Y'fi\u0006$\u0017\r^1M_\u001e\fq\"\\3uC\u0012\fG/\u0019'pO~#S-\u001d\u000b\u0005\u0003\u001b\ty\u000fC\u0005\u0002\u0016\r\n\t\u00111\u0001\u0002f\u0006aQ.\u001a;bI\u0006$\u0018\rT8hA\u000591\u000f^1siV\u0004\u0018\u0001C:ikR$wn\u001e8\u0002\u001b\u0005<\u0018-\u001b;TQV$Hm\\<o\u0003M\u0011W/\u001b7e\u001d\u0016$xo\u001c:l\u0007\"\fgN\\3m)\u0019\ty-!@\u0003\b!9\u0011q \u0015A\u0002\t\u0005\u0011A\u0003:bMR\u001cuN\u001c4jOB!\u00111\u0015B\u0002\u0013\u0011\u0011)!!*\u0003\u0015I\u000bg\r^\"p]\u001aLw\rC\u0004\u0003\n!\u0002\rAa\u0003\u0002\u00151|wmQ8oi\u0016DH\u000fE\u0002k\u0005\u001bI1Aa\u0004l\u0005)aunZ\"p]R,\u0007\u0010^\u0001\u0011EVLG\u000eZ'fi\u0006$\u0017\r^1M_\u001e$B!!:\u0003\u0016!9!qC\u0015A\u0002\te\u0011A\u00027pO\u0012K'\u000f\u0005\u0003\u0003\u001c\t\u0005RB\u0001B\u000f\u0015\r\u0011yb^\u0001\u0003S>LAAa\t\u0003\u001e\t!a)\u001b7f\u0003I\u0019'/Z1uK2{w\rR5sK\u000e$xN]=\u0015\r\te!\u0011\u0006B\u0016\u0011\u001d\u00119B\u000ba\u0001\u00053AqA!\f+\u0001\u0004\u0011y#\u0001\u0006m_\u001e$\u0015N\u001d(b[\u0016\u0004BA!\r\u0003@9!!1\u0007B\u001e!\r\u0011)$Q\u0007\u0003\u0005oQ1A!\u000f>\u0003\u0019a$o\\8u}%\u0019!QH!\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011\tEa\u0011\u0003\rM#(/\u001b8h\u0015\r\u0011i$Q\u0001\u0010EVLG\u000e\u001a*bMR\u001cE.[3oiRa\u0011\u0011\u0015B%\u0005\u0017\u0012iEa\u0014\u0003R!9\u0011q`\u0016A\u0002\t\u0005\u0001bBAqW\u0001\u0007\u0011Q\u001d\u0005\b\u0003\u0017\\\u0003\u0019AAh\u0011\u001d\u0011Ia\u000ba\u0001\u0005\u0017AqAa\u0006,\u0001\u0004\u0011I\"\u0001\nck&dGMT3uo>\u00148n\u00117jK:$HC\u0002B,\u0005G\u0012)\u0007\u0005\u0003\u0003Z\t}SB\u0001B.\u0015\r\u0011ifX\u0001\bG2LWM\u001c;t\u0013\u0011\u0011\tGa\u0017\u0003\u001b9+Go^8sW\u000ec\u0017.\u001a8u\u0011\u001d\ty\u0010\fa\u0001\u0005\u0003AqA!\u0003-\u0001\u0004\u0011Y!\u0001\bUKN$(+\u00194u'\u0016\u0014h/\u001a:\u0011\u0005]#4c\u0001\u001b@\u000bR\u0011!\u0011N\u0001\u0011O\u0016$\bK]8qg\u001a\u0013x.\\!sON$BAa\u001d\u0003|A!!Q\u000fB<\u001b\u0005)\u0018b\u0001B=k\nQ\u0001K]8qKJ$\u0018.Z:\t\u000f\tud\u00071\u0001\u0003\u0000\u0005!\u0011M]4t!\u0015\u0001%\u0011\u0011B\u0018\u0013\r\u0011\u0019)\u0011\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0005[\u0006Lg\u000e\u0006\u0003\u0002\u000e\t%\u0005b\u0002B?o\u0001\u0007!q\u0010")
public class TestRaftServer
implements Logging {
    private final KafkaConfig config;
    private final TopicPartition partition;
    private final Time time;
    private final CountDownLatch shutdownLatch;
    private SocketServer socketServer;
    private CredentialProvider credentialProvider;
    private DelegationTokenCache tokenCache;
    private KafkaRequestHandlerPool dataPlaneRequestHandlerPool;
    private KafkaScheduler scheduler;
    private Metrics metrics;
    private RaftIoThread raftIoThread;
    private KafkaNetworkChannel networkChannel;
    private KafkaMetadataLog metadataLog;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void main(String[] stringArray) {
        TestRaftServer$.MODULE$.main(stringArray);
    }

    public static Properties getPropsFromArgs(String[] stringArray) {
        return TestRaftServer$.MODULE$.getPropsFromArgs(stringArray);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    private TopicPartition partition() {
        return this.partition;
    }

    private Time time() {
        return this.time;
    }

    private CountDownLatch shutdownLatch() {
        return this.shutdownLatch;
    }

    public SocketServer socketServer() {
        return this.socketServer;
    }

    public void socketServer_$eq(SocketServer x$1) {
        this.socketServer = x$1;
    }

    public CredentialProvider credentialProvider() {
        return this.credentialProvider;
    }

    public void credentialProvider_$eq(CredentialProvider x$1) {
        this.credentialProvider = x$1;
    }

    public DelegationTokenCache tokenCache() {
        return this.tokenCache;
    }

    public void tokenCache_$eq(DelegationTokenCache x$1) {
        this.tokenCache = x$1;
    }

    public KafkaRequestHandlerPool dataPlaneRequestHandlerPool() {
        return this.dataPlaneRequestHandlerPool;
    }

    public void dataPlaneRequestHandlerPool_$eq(KafkaRequestHandlerPool x$1) {
        this.dataPlaneRequestHandlerPool = x$1;
    }

    public KafkaScheduler scheduler() {
        return this.scheduler;
    }

    public void scheduler_$eq(KafkaScheduler x$1) {
        this.scheduler = x$1;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public RaftIoThread raftIoThread() {
        return this.raftIoThread;
    }

    public void raftIoThread_$eq(RaftIoThread x$1) {
        this.raftIoThread = x$1;
    }

    public KafkaNetworkChannel networkChannel() {
        return this.networkChannel;
    }

    public void networkChannel_$eq(KafkaNetworkChannel x$1) {
        this.networkChannel = x$1;
    }

    public KafkaMetadataLog metadataLog() {
        return this.metadataLog;
    }

    public void metadataLog_$eq(KafkaMetadataLog x$1) {
        this.metadataLog = x$1;
    }

    public void startup() {
        LogContext logContext = new LogContext(new StringBuilder(11).append("[Raft id=").append(this.config().brokerId()).append("] ").toString());
        this.metrics_$eq(new Metrics());
        this.scheduler_$eq(new KafkaScheduler(1, KafkaScheduler$.MODULE$.$lessinit$greater$default$2(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3()));
        this.scheduler().startup();
        this.tokenCache_$eq(new DelegationTokenCache(ScramMechanism.mechanismNames()));
        this.credentialProvider_$eq(new CredentialProvider(ScramMechanism.mechanismNames(), this.tokenCache()));
        this.socketServer_$eq(new RaftSocketServer(this.config(), this.metrics(), this.time(), this.credentialProvider(), logContext));
        this.socketServer().startup(false);
        String logDirName = Log$.MODULE$.logDirName(this.partition());
        File logDir = this.createLogDirectory(new File((String)this.config().logDirs().head()), logDirName);
        RaftConfig raftConfig = new RaftConfig(this.config().originals());
        KafkaMetadataLog metadataLog = this.buildMetadataLog(logDir);
        KafkaNetworkChannel networkChannel = this.buildNetworkChannel(raftConfig, logContext);
        KafkaRaftClient raftClient = this.buildRaftClient(raftConfig, metadataLog, networkChannel, logContext, logDir);
        raftClient.initialize();
        TestRaftRequestHandler requestHandler = new TestRaftRequestHandler(networkChannel, this.socketServer().dataPlaneRequestChannel(), this.time(), (RaftClient)raftClient, this.partition());
        this.dataPlaneRequestHandlerPool_$eq(new KafkaRequestHandlerPool(this.config().brokerId(), this.socketServer().dataPlaneRequestChannel(), requestHandler, this.time(), Predef$.MODULE$.Integer2int(this.config().numIoThreads()), new StringBuilder(28).append(SocketServer$.MODULE$.DataPlaneMetricPrefix()).append("RequestHandlerAvgIdlePercent").toString(), SocketServer$.MODULE$.DataPlaneThreadPrefix()));
        this.socketServer().startProcessingRequests((Map<Endpoint, CompletableFuture<Void>>)Predef$.MODULE$.Map().empty());
        this.raftIoThread_$eq(new RaftIoThread(this, raftClient));
        this.raftIoThread().start();
    }

    public void shutdown() {
        if (this.raftIoThread() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.raftIoThread().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
        }
        if (this.dataPlaneRequestHandlerPool() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.dataPlaneRequestHandlerPool().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
        }
        if (this.socketServer() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.socketServer().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
        }
        if (this.networkChannel() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.networkChannel().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        }
        if (this.scheduler() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.scheduler().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
        }
        if (this.metrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.metrics().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        }
        if (this.metadataLog() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.metadataLog().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        }
        this.shutdownLatch().countDown();
    }

    public void awaitShutdown() {
        this.shutdownLatch().await();
    }

    private KafkaNetworkChannel buildNetworkChannel(RaftConfig raftConfig, LogContext logContext) {
        NetworkClient netClient = this.buildNetworkClient(raftConfig, logContext);
        String clientId = new StringBuilder(5).append("Raft-").append(this.config().brokerId()).toString();
        return new KafkaNetworkChannel(this.time(), (KafkaClient)netClient, clientId, raftConfig.retryBackoffMs(), raftConfig.requestTimeoutMs());
    }

    private KafkaMetadataLog buildMetadataLog(File logDir) {
        if (this.config().logDirs().size() != 1) {
            throw new ConfigException("There must be exactly one configured log dir");
        }
        java.util.Map<String, Object> defaultProps = KafkaServer$.MODULE$.copyKafkaConfigToLog(this.config());
        LogConfig$.MODULE$.validateValues(defaultProps);
        LogConfig defaultLogConfig = new LogConfig(defaultProps, LogConfig$.MODULE$.apply$default$2());
        Log log = Log$.MODULE$.apply(logDir, defaultLogConfig, 0L, 0L, this.scheduler(), new BrokerTopicStats(), this.time(), Predef$.MODULE$.Integer2int(this.config().transactionalIdExpirationMs()), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), new LogDirFailureChannel(5));
        return new KafkaMetadataLog(log, this.partition(), KafkaMetadataLog$.MODULE$.$lessinit$greater$default$3());
    }

    private File createLogDirectory(File logDir, String logDirName) {
        String logDirPath = logDir.getAbsolutePath();
        File dir = new File(logDirPath, logDirName);
        Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        return dir;
    }

    private KafkaRaftClient buildRaftClient(RaftConfig raftConfig, KafkaMetadataLog metadataLog, KafkaNetworkChannel networkChannel, LogContext logContext, File logDir) {
        QuorumState quorumState = new QuorumState(this.config().brokerId(), raftConfig.quorumVoterIds(), raftConfig.electionTimeoutMs(), raftConfig.fetchTimeoutMs(), (QuorumStateStore)new FileBasedStateStore(new File(logDir, "quorum-state")), this.time(), logContext, new Random());
        KafkaFuturePurgatory fetchPurgatory = new KafkaFuturePurgatory(this.config().brokerId(), new SystemTimer("raft-fetch-purgatory-reaper", SystemTimer$.MODULE$.$lessinit$greater$default$2(), SystemTimer$.MODULE$.$lessinit$greater$default$3(), SystemTimer$.MODULE$.$lessinit$greater$default$4()), KafkaFuturePurgatory$.MODULE$.$lessinit$greater$default$3());
        KafkaFuturePurgatory appendPurgatory = new KafkaFuturePurgatory(this.config().brokerId(), new SystemTimer("raft-append-purgatory-reaper", SystemTimer$.MODULE$.$lessinit$greater$default$2(), SystemTimer$.MODULE$.$lessinit$greater$default$3(), SystemTimer$.MODULE$.$lessinit$greater$default$4()), KafkaFuturePurgatory$.MODULE$.$lessinit$greater$default$3());
        return new KafkaRaftClient(raftConfig, (NetworkChannel)networkChannel, (ReplicatedLog)metadataLog, quorumState, this.time(), fetchPurgatory, appendPurgatory, logContext);
    }

    private NetworkClient buildNetworkClient(RaftConfig raftConfig, LogContext logContext) {
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)this.config().interBrokerSecurityProtocol(), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)this.config(), (ListenerName)this.config().interBrokerListenerName(), (String)this.config().saslMechanismInterBrokerProtocol(), (Time)this.time(), (boolean)this.config().saslInterBrokerHandshakeRequestEnable(), (LogContext)logContext);
        String metricGroupPrefix = "raft-channel";
        boolean collectPerConnectionMetrics = false;
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(this.config().connectionsMaxIdleMs()), this.metrics(), this.time(), metricGroupPrefix, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava(), collectPerConnectionMetrics, channelBuilder, logContext);
        String clientId = new StringBuilder(19).append("broker-").append(this.config().brokerId()).append("-raft-client").toString();
        int maxInflightRequestsPerConnection = 1;
        int reconnectBackoffMs = 50;
        int reconnectBackoffMsMs = 500;
        boolean discoverBrokerVersions = false;
        return new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId, maxInflightRequestsPerConnection, (long)reconnectBackoffMs, (long)reconnectBackoffMsMs, -1, Predef$.MODULE$.Integer2int(this.config().socketReceiveBufferBytes()), raftConfig.requestTimeoutMs(), Predef$.MODULE$.Long2long(this.config().connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config().connectionSetupTimeoutMaxMs()), ClientDnsLookup.USE_ALL_DNS_IPS, this.time(), discoverBrokerVersions, new ApiVersions(), logContext);
    }

    public TestRaftServer(KafkaConfig config) {
        this.config = config;
        Logging.$init$(this);
        this.partition = new TopicPartition("__cluster_metadata", 0);
        this.time = Time.SYSTEM;
        this.shutdownLatch = new CountDownLatch(1);
    }

    public class RaftIoThread
    extends ShutdownableThread {
        private final KafkaRaftClient client;
        public final /* synthetic */ TestRaftServer $outer;

        @Override
        public void doWork() {
            this.client.poll();
        }

        @Override
        public boolean initiateShutdown() {
            if (super.initiateShutdown()) {
                this.client.shutdown(5000).whenComplete((x$1, exception) -> {
                    if (exception != null) {
                        if (this.logger().underlying().isErrorEnabled()) {
                            this.logger().underlying().error("Shutdown of RaftClient failed", exception);
                            return;
                        }
                    } else if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Completed shutdown of RaftClient");
                    }
                });
                return true;
            }
            return false;
        }

        @Override
        public boolean isRunning() {
            return this.client.isRunning();
        }

        public /* synthetic */ TestRaftServer kafka$tools$TestRaftServer$RaftIoThread$$$outer() {
            return this.$outer;
        }

        public RaftIoThread(TestRaftServer $outer, KafkaRaftClient client) {
            this.client = client;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("raft-io-thread", ShutdownableThread$.MODULE$.$lessinit$greater$default$2());
        }
    }
}

