/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.auth.web;

import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Set;
import org.apache.inlong.manager.common.enums.TenantUserTypeEnum;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.service.user.UserService;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;

public class WebAuthorizingRealm
extends AuthorizingRealm {
    private final UserService userService;

    public WebAuthorizingRealm(UserService userService) {
        this.userService = userService;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        UsernamePasswordToken upToken = (UsernamePasswordToken)token;
        String username = upToken.getUsername();
        UserInfo userInfo = this.userService.getByName(username);
        Preconditions.expectNotNull((Object)userInfo, (String)("User not exist with name=" + username));
        Preconditions.expectTrue((boolean)userInfo.getDueDate().after(new Date()), (String)("User " + username + " was expired"));
        userInfo.setRoles((Set)Sets.newHashSet((Object[])new String[]{userInfo.getAccountType() == 0 ? TenantUserTypeEnum.TENANT_ADMIN.name() : TenantUserTypeEnum.TENANT_OPERATOR.name()}));
        return new SimpleAuthenticationInfo((Object)userInfo, (Object)userInfo.getPassword(), this.getName());
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        SimpleAuthorizationInfo simpleAuthorizationInfo = new SimpleAuthorizationInfo();
        UserInfo userInfo = (UserInfo)this.getAvailablePrincipal(principalCollection);
        if (userInfo != null) {
            simpleAuthorizationInfo.setRoles(userInfo.getRoles());
        }
        return simpleAuthorizationInfo;
    }
}

