/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.apache.inlong.manager.common.enums.OperationTarget;
import org.apache.inlong.manager.common.enums.OperationType;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.user.InlongRoleInfo;
import org.apache.inlong.manager.pojo.user.InlongRolePageRequest;
import org.apache.inlong.manager.pojo.user.InlongRoleRequest;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.service.operationlog.OperationLog;
import org.apache.inlong.manager.service.user.InlongRoleService;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Api(tags={"INLONG-User-API"})
public class InlongRoleController {
    @Autowired
    private InlongRoleService inlongRoleService;

    @RequestMapping(value={"/role/inlong/get/{id}"}, method={RequestMethod.GET})
    @ApiOperation(value="Get inlong role by ID")
    @RequiresRoles(logical=Logical.OR, value={"INLONG_ADMIN", "INLONG_OPERATOR"})
    @ApiImplicitParam(name="id", dataTypeClass=Integer.class, required=true)
    public Response<InlongRoleInfo> get(@PathVariable int id) {
        return Response.success((Object)this.inlongRoleService.get(id));
    }

    @RequestMapping(value={"/role/inlong/save"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.CREATE, operationTarget=OperationTarget.INLONG_ROLE)
    @RequiresRoles(value={"INLONG_ADMIN"})
    @ApiOperation(value="Save inlong role")
    public Response<Integer> save(@Validated @RequestBody InlongRoleRequest request) {
        String operator = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.inlongRoleService.save(request, operator));
    }

    @RequestMapping(value={"/role/inlong/update"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.UPDATE, operationTarget=OperationTarget.INLONG_ROLE)
    @RequiresRoles(value={"INLONG_ADMIN"})
    @ApiOperation(value="Update inlong role")
    public Response<Boolean> update(@Validated @RequestBody InlongRoleRequest request) {
        String operator = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.inlongRoleService.update(request, operator));
    }

    @RequestMapping(value={"/role/inlong/list"}, method={RequestMethod.POST})
    @ApiOperation(value="List inlong roles by paginating")
    @RequiresRoles(logical=Logical.OR, value={"INLONG_ADMIN", "INLONG_OPERATOR"})
    public Response<PageResult<InlongRoleInfo>> listByCondition(@RequestBody InlongRolePageRequest request) {
        return Response.success((Object)this.inlongRoleService.listByCondition(request));
    }
}

