/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.inlong.manager.common.enums.OperationTarget;
import org.apache.inlong.manager.common.enums.OperationType;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.pojo.workflow.ProcessCountRequest;
import org.apache.inlong.manager.pojo.workflow.ProcessCountResponse;
import org.apache.inlong.manager.pojo.workflow.ProcessDetailResponse;
import org.apache.inlong.manager.pojo.workflow.ProcessRequest;
import org.apache.inlong.manager.pojo.workflow.ProcessResponse;
import org.apache.inlong.manager.pojo.workflow.TaskCountRequest;
import org.apache.inlong.manager.pojo.workflow.TaskCountResponse;
import org.apache.inlong.manager.pojo.workflow.TaskLogRequest;
import org.apache.inlong.manager.pojo.workflow.TaskRequest;
import org.apache.inlong.manager.pojo.workflow.TaskResponse;
import org.apache.inlong.manager.pojo.workflow.WorkflowApprovalRequest;
import org.apache.inlong.manager.pojo.workflow.WorkflowExecuteLog;
import org.apache.inlong.manager.pojo.workflow.WorkflowOperationRequest;
import org.apache.inlong.manager.pojo.workflow.WorkflowResult;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.task.TaskForm;
import org.apache.inlong.manager.service.operationlog.OperationLog;
import org.apache.inlong.manager.service.workflow.WorkflowService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Api(tags={"Workflow-API"})
public class WorkflowController {
    private static final Logger log = LoggerFactory.getLogger(WorkflowController.class);
    @Autowired
    private WorkflowService workflowService;

    @PostMapping(value={"/workflow/start"})
    @OperationLog(operation=OperationType.CREATE, operationTarget=OperationTarget.WORKFLOW)
    @ApiOperation(value="Initiation process")
    public Response<WorkflowResult> start(@RequestBody WorkflowOperationRequest request) {
        String applicant = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.workflowService.start(request.getName(), applicant, (ProcessForm)request.getForm()));
    }

    @PostMapping(value={"/workflow/cancel/{id}"})
    @OperationLog(operation=OperationType.UPDATE, operationTarget=OperationTarget.WORKFLOW)
    @ApiOperation(value="Cancellation process")
    @ApiImplicitParam(name="id", value="Process ID", dataTypeClass=Integer.class, required=true)
    public Response<WorkflowResult> cancel(@PathVariable Integer id, @RequestBody WorkflowOperationRequest request) {
        String operator = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.workflowService.cancel(id, operator, request.getRemark()));
    }

    @PostMapping(value={"/workflow/continue/{id}"})
    @OperationLog(operation=OperationType.UPDATE, operationTarget=OperationTarget.WORKFLOW)
    @ApiOperation(value="Continue process")
    @ApiImplicitParam(name="id", value="Process ID", dataTypeClass=Integer.class, required=true)
    public Response<WorkflowResult> continueProcess(@PathVariable Integer id, @RequestBody WorkflowOperationRequest request) {
        String operator = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.workflowService.continueProcess(id, operator, request.getRemark()));
    }

    @PostMapping(value={"/workflow/approve/{id}"})
    @OperationLog(operation=OperationType.UPDATE, operationTarget=OperationTarget.WORKFLOW)
    @ApiOperation(value="Approval and consent")
    @ApiImplicitParam(name="id", value="Task ID", dataTypeClass=Integer.class, required=true)
    public Response<WorkflowResult> approve(@PathVariable Integer id, @RequestBody WorkflowApprovalRequest request) {
        String operator = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.workflowService.approve(id, request.getRemark(), (TaskForm)request.getForm(), operator));
    }

    @PostMapping(value={"/workflow/reject/{id}"})
    @OperationLog(operation=OperationType.UPDATE, operationTarget=OperationTarget.WORKFLOW)
    @ApiOperation(value="Approval rejected")
    @ApiImplicitParam(name="id", value="Task ID", dataTypeClass=Integer.class, required=true)
    public Response<WorkflowResult> reject(@PathVariable Integer id, @RequestBody WorkflowApprovalRequest request) {
        String operator = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.workflowService.reject(id, request.getRemark(), operator));
    }

    @PostMapping(value={"/workflow/transfer/{id}"})
    @OperationLog(operation=OperationType.UPDATE, operationTarget=OperationTarget.WORKFLOW)
    @ApiOperation(value="Turn to another approver", notes="Change approver")
    @ApiImplicitParam(name="id", value="Task ID", dataTypeClass=Integer.class, required=true)
    public Response<WorkflowResult> transfer(@PathVariable Integer id, @RequestBody WorkflowApprovalRequest request) {
        String operator = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.workflowService.transfer(id, request.getRemark(), request.getTransferTo(), operator));
    }

    @PostMapping(value={"/workflow/complete/{id}"})
    @OperationLog(operation=OperationType.UPDATE, operationTarget=OperationTarget.WORKFLOW)
    @ApiOperation(value="Complete task by ID")
    @ApiImplicitParam(name="id", value="Task ID", dataTypeClass=Integer.class, required=true)
    public Response<WorkflowResult> complete(@PathVariable Integer id, @RequestBody WorkflowApprovalRequest request) {
        String operator = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.workflowService.complete(id, request.getRemark(), operator));
    }

    @GetMapping(value={"/workflow/detail/{id}"})
    @ApiOperation(value="Get process detail")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="Process ID", dataTypeClass=Integer.class, required=true), @ApiImplicitParam(name="taskId", value="Task ID", dataTypeClass=Integer.class, example="1")})
    public Response<ProcessDetailResponse> detail(@PathVariable(name="id") Integer id, @RequestParam(required=false) Integer taskId) {
        String operator = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.workflowService.detail(id, taskId, operator));
    }

    @GetMapping(value={"/workflow/listProcess"})
    @ApiOperation(value="Get process list by paginating")
    public Response<PageResult<ProcessResponse>> listProcess(ProcessRequest query) {
        query.setApplicant(LoginUserUtils.getLoginUser().getName());
        return Response.success((Object)this.workflowService.listProcess(query));
    }

    @GetMapping(value={"/workflow/listTask"})
    @ApiOperation(value="Get task list by paginating")
    public Response<PageResult<TaskResponse>> listTask(TaskRequest query) {
        query.setApprover(LoginUserUtils.getLoginUser().getName());
        return Response.success((Object)this.workflowService.listTask(query));
    }

    @GetMapping(value={"/workflow/processSummary"})
    @ApiOperation(value="Get process statistics")
    public Response<ProcessCountResponse> processSummary(ProcessCountRequest query) {
        query.setApplicant(LoginUserUtils.getLoginUser().getName());
        return Response.success((Object)this.workflowService.countProcess(query));
    }

    @GetMapping(value={"/workflow/taskSummary"})
    @ApiOperation(value="Get task statistics")
    public Response<TaskCountResponse> taskSummary(TaskCountRequest query) {
        query.setApprover(LoginUserUtils.getLoginUser().getName());
        return Response.success((Object)this.workflowService.countTask(query));
    }

    @GetMapping(value={"/workflow/listTaskLogs"})
    @ApiOperation(value="Get task execution logs")
    public Response<PageResult<WorkflowExecuteLog>> listTaskLogs(TaskLogRequest query) {
        return Response.success((Object)this.workflowService.listTaskLogs(query));
    }
}

