/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.example;

import org.apache.inlong.sdk.dataproxy.common.ProcessResult;
import org.apache.inlong.sdk.dataproxy.example.ExampleUtils;
import org.apache.inlong.sdk.dataproxy.sender.http.HttpMsgSenderConfig;
import org.apache.inlong.sdk.dataproxy.sender.http.InLongHttpMsgSender;
import org.apache.inlong.sdk.dataproxy.utils.ProxyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InLongHttpClientExample {
    protected static final Logger logger = LoggerFactory.getLogger(InLongHttpClientExample.class);

    public static void main(String[] args) throws Exception {
        ProcessResult procResult;
        String managerAddr;
        HttpMsgSenderConfig dataProxyConfig;
        InLongHttpMsgSender messageSender;
        String managerIp = args[0];
        String managerPort = args[1];
        String groupId = args[2];
        String streamId = args[3];
        String secretId = args[4];
        String secretKey = args[5];
        int reqCnt = Integer.parseInt(args[6]);
        int msgSize = 1024;
        int msgCnt = 1;
        if (args.length > 7) {
            msgSize = Integer.parseInt(args[7]);
            msgCnt = Integer.parseInt(args[8]);
        }
        if (!(messageSender = new InLongHttpMsgSender(dataProxyConfig = new HttpMsgSenderConfig(managerAddr = "http://" + managerIp + ":" + managerPort, groupId, secretId, secretKey))).start(procResult = new ProcessResult())) {
            messageSender.close();
            System.out.println("Start http sender failure: process result=" + procResult);
            return;
        }
        System.out.println("InLongHttpMsgSender start, nodes=" + messageSender.getProxyNodeInfos());
        ExampleUtils.sendHttpMessages(messageSender, true, false, groupId, streamId, reqCnt, msgSize, msgCnt, procResult);
        ExampleUtils.sendHttpMessages(messageSender, true, true, groupId, streamId, reqCnt, msgSize, msgCnt, procResult);
        ExampleUtils.sendHttpMessages(messageSender, false, false, groupId, streamId, reqCnt, msgSize, msgCnt, procResult);
        ExampleUtils.sendHttpMessages(messageSender, false, true, groupId, streamId, reqCnt, msgSize, msgCnt, procResult);
        ProxyUtils.sleepSomeTime(10000L);
    }
}

