/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.utils;

import java.util.concurrent.atomic.AtomicLong;

public class LogCounter {
    private final AtomicLong counter = new AtomicLong(0L);
    private long start = 10L;
    private long control = 100000L;
    private long reset = 60000L;
    private final AtomicLong lastLogTime = new AtomicLong(System.currentTimeMillis());

    public LogCounter(long start, long control, long reset) {
        this.start = start;
        this.control = control;
        this.reset = reset;
    }

    public boolean shouldPrint() {
        long curTime = this.lastLogTime.get();
        if (System.currentTimeMillis() - curTime > this.reset && this.lastLogTime.compareAndSet(curTime, System.currentTimeMillis())) {
            this.counter.set(0L);
        }
        return this.counter.incrementAndGet() <= this.start || this.counter.get() % this.control == 0L;
    }
}

