/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.dataview;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.runtime.state.internal.InternalListState;
import org.apache.flink.table.api.dataview.ListView;
import org.apache.flink.table.runtime.dataview.StateDataView;

@Internal
public abstract class StateListView<N, EE>
extends ListView<EE>
implements StateDataView<N> {
    private final Iterable<EE> emptyList = Collections.emptyList();

    public List<EE> getList() {
        ArrayList list = new ArrayList();
        try {
            this.get().forEach(list::add);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    public void setList(List<EE> list) {
        this.clear();
        try {
            this.addAll(list);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Iterable<EE> get() throws Exception {
        Iterable<EE> original = (Iterable<EE>)this.getListState().get();
        return original != null ? original : this.emptyList;
    }

    public void add(EE value) throws Exception {
        this.getListState().add(value);
    }

    public void addAll(List<EE> list) throws Exception {
        this.getListState().addAll(list);
    }

    public boolean remove(EE value) throws Exception {
        Iterable iterable = (Iterable)this.getListState().get();
        if (iterable == null) {
            return false;
        }
        Iterator iterator = iterable.iterator();
        ArrayList list = new ArrayList();
        while (iterator.hasNext()) {
            Object it = iterator.next();
            list.add(it);
        }
        boolean success = list.remove(value);
        if (success) {
            this.getListState().update(list);
        }
        return success;
    }

    public void clear() {
        this.getListState().clear();
    }

    protected abstract ListState<EE> getListState();

    public static final class NamespacedStateListView<N, T>
    extends StateListView<N, T> {
        private final InternalListState<?, N, T> listState;
        private N namespace;

        public NamespacedStateListView(InternalListState<?, N, T> listState) {
            this.listState = listState;
        }

        @Override
        public void setCurrentNamespace(N namespace) {
            this.namespace = namespace;
        }

        @Override
        protected ListState<T> getListState() {
            this.listState.setCurrentNamespace(this.namespace);
            return this.listState;
        }
    }

    public static final class KeyedStateListView<N, T>
    extends StateListView<N, T> {
        private final ListState<T> listState;

        public KeyedStateListView(ListState<T> listState) {
            this.listState = listState;
        }

        @Override
        public void setCurrentNamespace(N namespace) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected ListState<T> getListState() {
            return this.listState;
        }
    }
}

