/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util.collections;

import org.apache.flink.table.runtime.util.MurmurHashUtil;
import org.apache.flink.table.runtime.util.collections.OptimizableHashSet;

public class FloatHashSet
extends OptimizableHashSet {
    private float[] key;

    public FloatHashSet(int expected, float f) {
        super(expected, f);
        this.key = new float[this.n + 1];
    }

    public FloatHashSet(int expected) {
        this(expected, 0.75f);
    }

    public FloatHashSet() {
        this(16, 0.75f);
    }

    public boolean add(float k) {
        int intKey = Float.floatToIntBits(k);
        if (intKey == 0) {
            if (this.containsZero) {
                return false;
            }
            this.containsZero = true;
        } else {
            float[] key = this.key;
            int pos = MurmurHashUtil.fmix(intKey) & this.mask;
            int curr = Float.floatToIntBits(key[pos]);
            if (curr != 0) {
                if (curr == intKey) {
                    return false;
                }
                while ((curr = Float.floatToIntBits(key[pos = pos + 1 & this.mask])) != 0) {
                    if (curr != intKey) continue;
                    return false;
                }
            }
            key[pos] = k;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(OptimizableHashSet.arraySize(this.size + 1, this.f));
        }
        return true;
    }

    public boolean contains(float k) {
        int intKey = Float.floatToIntBits(k);
        if (intKey == 0) {
            return this.containsZero;
        }
        float[] key = this.key;
        int pos = MurmurHashUtil.fmix(intKey) & this.mask;
        int curr = Float.floatToIntBits(key[pos]);
        if (curr == 0) {
            return false;
        }
        if (intKey == curr) {
            return true;
        }
        while ((curr = Float.floatToIntBits(key[pos = pos + 1 & this.mask])) != 0) {
            if (intKey != curr) continue;
            return true;
        }
        return false;
    }

    private void rehash(int newN) {
        float[] key = this.key;
        int mask = newN - 1;
        float[] newKey = new float[newN + 1];
        int i = this.n;
        int j = this.realSize();
        while (j-- != 0) {
            while (Float.floatToIntBits(key[--i]) == 0) {
            }
            int pos = MurmurHashUtil.fmix(Float.floatToIntBits(key[i])) & mask;
            if (Float.floatToIntBits(newKey[pos]) != 0) {
                while (Float.floatToIntBits(newKey[pos = pos + 1 & mask]) != 0) {
                }
            }
            newKey[pos] = key[i];
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = OptimizableHashSet.maxFill(this.n, this.f);
        this.key = newKey;
    }

    @Override
    public void optimize() {
    }
}

