/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.manager.controller.topic;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.inlong.tubemq.manager.controller.TubeMQResult;
import org.apache.inlong.tubemq.manager.controller.node.request.BaseReq;
import org.apache.inlong.tubemq.manager.controller.node.request.BatchAddTopicReq;
import org.apache.inlong.tubemq.manager.controller.node.request.CloneTopicReq;
import org.apache.inlong.tubemq.manager.controller.topic.request.DeleteTopicReq;
import org.apache.inlong.tubemq.manager.controller.topic.request.ModifyTopicReq;
import org.apache.inlong.tubemq.manager.controller.topic.request.QueryCanWriteReq;
import org.apache.inlong.tubemq.manager.controller.topic.request.SetAuthControlReq;
import org.apache.inlong.tubemq.manager.controller.topic.request.SetPublishReq;
import org.apache.inlong.tubemq.manager.controller.topic.request.SetSubscribeReq;
import org.apache.inlong.tubemq.manager.service.interfaces.MasterService;
import org.apache.inlong.tubemq.manager.service.interfaces.NodeService;
import org.apache.inlong.tubemq.manager.service.interfaces.TopicService;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/v1/topic"})
public class TopicWebController {
    private static final Logger log = LoggerFactory.getLogger(TopicWebController.class);
    private static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger(TopicWebController.class);
    @Autowired
    private NodeService nodeService;
    private static final Gson gson = new Gson();
    @Autowired
    private MasterService masterService;
    @Autowired
    private TopicService topicService;

    @RequestMapping(value={""})
    @ResponseBody
    public TubeMQResult topicMethodProxy(@RequestParam String method, @RequestBody String req) throws Exception {
        LOGGER.info("Received method for topicMethodProxy: {}", (Object)method);
        LOGGER.info("Received req for topicMethodProxy: {}", (Object)req);
        if (!TopicWebController.isValidMethod(method)) {
            return this.handleInvalidMethod(method);
        }
        if (!TopicWebController.isValidJson(req)) {
            return this.handleInvalidJson(req);
        }
        switch (method) {
            case "add": {
                return this.handleAddTopicRequest(req);
            }
            case "clone": {
                return this.handleCloneTopicRequest(req);
            }
            case "authControl": {
                return this.handleAuthControlRequest(req);
            }
            case "modify": {
                return this.handleModifyTopicRequest(req);
            }
            case "delete": 
            case "remove": {
                return this.handleDeleteTopicRequest(req);
            }
            case "queryCanWrite": {
                return this.handleQueryCanWriteRequest(req);
            }
            case "publish": {
                return this.handlePublishRequest(req);
            }
            case "subscribe": {
                return this.handleSubscribeRequest(req);
            }
        }
        return this.handleInvalidMethod(method);
    }

    private TubeMQResult handleInvalidMethod(String method) {
        LOGGER.warn("Invalid method value received: {}", (Object)method);
        return TubeMQResult.errorResult("Invalid method value.");
    }

    private TubeMQResult handleInvalidJson(String req) {
        LOGGER.warn("Invalid JSON format received: {}", (Object)req);
        return TubeMQResult.errorResult("Invalid JSON format.");
    }

    private TubeMQResult handleAddTopicRequest(String req) {
        return this.masterService.baseRequestMaster((BaseReq)gson.fromJson(req, BatchAddTopicReq.class));
    }

    private TubeMQResult handleCloneTopicRequest(String req) throws Exception {
        return this.nodeService.cloneTopicToBrokers((CloneTopicReq)gson.fromJson(req, CloneTopicReq.class));
    }

    private TubeMQResult handleAuthControlRequest(String req) {
        SetAuthControlReq setAuthControlReq = (SetAuthControlReq)gson.fromJson(req, SetAuthControlReq.class);
        setAuthControlReq.setMethod("admin_set_topic_authorize_control");
        setAuthControlReq.setType("op_modify");
        setAuthControlReq.setCreateUser("tubeAdmin");
        return this.masterService.baseRequestMaster(setAuthControlReq);
    }

    private TubeMQResult handleModifyTopicRequest(String req) {
        return this.masterService.baseRequestMaster((BaseReq)gson.fromJson(req, ModifyTopicReq.class));
    }

    private TubeMQResult handleDeleteTopicRequest(String req) {
        return this.masterService.baseRequestMaster((BaseReq)gson.fromJson(req, DeleteTopicReq.class));
    }

    private TubeMQResult handleQueryCanWriteRequest(String req) {
        QueryCanWriteReq queryCanWriteReq = (QueryCanWriteReq)gson.fromJson(req, QueryCanWriteReq.class);
        if (!queryCanWriteReq.legal()) {
            return TubeMQResult.errorResult("param illegal");
        }
        return this.topicService.queryCanWrite(queryCanWriteReq.getTopicName(), queryCanWriteReq.getClusterId());
    }

    private TubeMQResult handlePublishRequest(String req) {
        return this.masterService.baseRequestMaster((BaseReq)gson.fromJson(req, SetPublishReq.class));
    }

    private TubeMQResult handleSubscribeRequest(String req) {
        return this.masterService.baseRequestMaster((BaseReq)gson.fromJson(req, SetSubscribeReq.class));
    }

    private static boolean isValidMethod(String method) {
        List<String> allowedMethods = Arrays.asList("add", "clone", "authControl", "modify", "delete", "remove", "queryCanWrite", "publish", "subscribe");
        return allowedMethods.contains(method);
    }

    private static boolean isValidJson(String json) {
        try {
            gson.fromJson(json, Object.class);
            return true;
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("JSON validation failed with exception: {}", (Object)e.getMessage());
            return false;
        }
    }

    @GetMapping(value={"/consumerAuth"})
    @ResponseBody
    public String queryConsumerAuth(@RequestParam Map<String, String> req) throws Exception {
        String url = this.masterService.getQueryUrl(req);
        return this.masterService.queryMaster(url);
    }

    @GetMapping(value={"/topicConfig"})
    @ResponseBody
    public String queryTopicConfig(@RequestParam Map<String, String> req) throws Exception {
        String url = this.masterService.getQueryUrl(req);
        return this.masterService.queryMaster(url);
    }
}

