/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.manager.controller.topic.request;

import org.apache.commons.lang3.StringUtils;

public class AddTopicTask {
    public static final int MAX_TOPIC_LENGTH = 64;
    public static final String TOPIC_NAME_REGEX = "^[a-zA-Z]\\w+$";
    private String topicName;
    private Long clusterId;

    public boolean legal() {
        if (StringUtils.isBlank((CharSequence)this.topicName)) {
            return false;
        }
        if (this.topicName.length() > 64) {
            throw new IllegalArgumentException("topic name length larger than 64");
        }
        if (!this.topicName.matches(TOPIC_NAME_REGEX)) {
            throw new IllegalArgumentException("topic name must begin with a letter, can only contain characters,numbers,and underscores");
        }
        return true;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public Long getClusterId() {
        return this.clusterId;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddTopicTask)) {
            return false;
        }
        AddTopicTask other = (AddTopicTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$clusterId = this.getClusterId();
        Long other$clusterId = other.getClusterId();
        if (this$clusterId == null ? other$clusterId != null : !((Object)this$clusterId).equals(other$clusterId)) {
            return false;
        }
        String this$topicName = this.getTopicName();
        String other$topicName = other.getTopicName();
        return !(this$topicName == null ? other$topicName != null : !this$topicName.equals(other$topicName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddTopicTask;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $clusterId = this.getClusterId();
        result = result * 59 + ($clusterId == null ? 43 : ((Object)$clusterId).hashCode());
        String $topicName = this.getTopicName();
        result = result * 59 + ($topicName == null ? 43 : $topicName.hashCode());
        return result;
    }

    public String toString() {
        return "AddTopicTask(topicName=" + this.getTopicName() + ", clusterId=" + this.getClusterId() + ")";
    }
}

