/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.manager.service;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.inlong.tubemq.manager.repository.TopicRepository;
import org.apache.inlong.tubemq.manager.service.NodeServiceImpl;
import org.apache.inlong.tubemq.manager.service.TopicFuture;
import org.apache.inlong.tubemq.manager.service.interfaces.NodeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TopicBackendWorker
implements DisposableBean,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(TopicBackendWorker.class);
    private final AtomicBoolean runFlag = new AtomicBoolean(false);
    private final ConcurrentHashMap<Integer, BlockingQueue<TopicFuture>> pendingTopics = new ConcurrentHashMap();
    private final AtomicInteger notSatisfiedCount = new AtomicInteger(0);
    private final NodeService nodeService;
    private final ScheduledExecutorService workerExecutor;
    @Autowired
    private TopicRepository topicRepository;
    @Value(value="${manager.topic.queue.warning.size:100}")
    private int queueWarningSize;
    @Value(value="${manager.topic.queue.thread.interval:10}")
    private int queueThreadInterval;
    @Value(value="${manager.topic.queue.max.wait:3}")
    private int queueMaxWait;
    @Value(value="${manager.topic.queue.max.running.size:20}")
    private int queueMaxRunningSize;

    TopicBackendWorker() {
        ThreadFactoryBuilder factoryBuilder = new ThreadFactoryBuilder();
        this.workerExecutor = Executors.newSingleThreadScheduledExecutor(factoryBuilder.setNameFormat("tubemq-manager-topic-backend-worker").build());
        this.workerExecutor.schedule(this, (long)this.queueThreadInterval, TimeUnit.SECONDS);
        this.nodeService = new NodeServiceImpl(this);
    }

    public void addTopicFuture(TopicFuture future) {
        LinkedBlockingQueue<TopicFuture> tmpQueue = new LinkedBlockingQueue<TopicFuture>();
        LinkedBlockingQueue<TopicFuture> queue = this.pendingTopics.putIfAbsent(future.getEntry().getClusterId(), tmpQueue);
        if (queue == null) {
            queue = tmpQueue;
        }
        queue.add(future);
        if (queue.size() > this.queueWarningSize) {
            log.warn("queue size exceed {}, please check it", (Object)this.queueWarningSize);
        }
    }

    private void batchAddTopic() {
        this.pendingTopics.forEach((clusterId, queue) -> {
            HashMap<String, TopicFuture> pendingTopicList = new HashMap<String, TopicFuture>(32);
            if (this.notSatisfiedCount.get() > this.queueMaxWait || queue.size() > this.queueMaxRunningSize) {
                this.notSatisfiedCount.set(0);
                ArrayList tmpTopicList = new ArrayList();
                queue.drainTo(tmpTopicList, this.queueMaxRunningSize);
                for (TopicFuture topicFuture : tmpTopicList) {
                    pendingTopicList.put(topicFuture.getEntry().getTopic(), topicFuture);
                }
            } else {
                this.notSatisfiedCount.incrementAndGet();
            }
            this.nodeService.updateBrokerStatus((int)clusterId, (Map<String, TopicFuture>)pendingTopicList);
        });
    }

    private void checkTopicFromDB() {
    }

    @Override
    public void run() {
        log.info("TopicBackendWorker has started");
        if (this.runFlag.get()) {
            try {
                this.batchAddTopic();
                this.checkTopicFromDB();
            }
            catch (Exception exception) {
                log.warn("exception caught", (Throwable)exception);
            }
        }
    }

    public void destroy() throws Exception {
        this.runFlag.set(false);
        this.nodeService.close();
        this.workerExecutor.shutdown();
    }
}

