/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.manager.service.tube;

import java.util.ArrayList;
import java.util.List;

public class TubeHttpBrokerInfoList {
    private static final String IDLE = "idle";
    private static final String RUNNING = "running";
    private static final String ONLINE = "online";
    private static final String ONLY_READ = "only-read";
    private static final String ONLY_WRITE = "only-write";
    private int code;
    private String errMsg;
    private List<BrokerInfo> data;
    private List<BrokerInfo> configurableList;
    private List<BrokerInfo> workingList;
    private List<BrokerInfo> idleList;
    private List<Integer> needReloadList;

    public void divideBrokerListByState() {
        if (this.data != null) {
            this.configurableList = new ArrayList<BrokerInfo>();
            this.workingList = new ArrayList<BrokerInfo>();
            this.idleList = new ArrayList<BrokerInfo>();
            this.needReloadList = new ArrayList<Integer>();
            for (BrokerInfo brokerInfo : this.data) {
                if (brokerInfo.isConfigurable()) {
                    this.configurableList.add(brokerInfo);
                }
                if (brokerInfo.isWorking()) {
                    this.workingList.add(brokerInfo);
                }
                if (brokerInfo.isIdle()) {
                    this.idleList.add(brokerInfo);
                }
                if (!brokerInfo.isConfChanged) continue;
                this.needReloadList.add(brokerInfo.getBrokerId());
            }
        }
    }

    public List<Integer> getConfigurableBrokerIdList() {
        ArrayList<Integer> tmpBrokerIdList = new ArrayList<Integer>();
        if (this.configurableList != null) {
            for (BrokerInfo brokerInfo : this.configurableList) {
                tmpBrokerIdList.add(brokerInfo.getBrokerId());
            }
        }
        return tmpBrokerIdList;
    }

    public List<Integer> getAllBrokerIdList() {
        ArrayList<Integer> tmpBrokerIdList = new ArrayList<Integer>();
        if (this.data != null) {
            for (BrokerInfo brokerInfo : this.data) {
                tmpBrokerIdList.add(brokerInfo.getBrokerId());
            }
        }
        return tmpBrokerIdList;
    }

    public int getCode() {
        return this.code;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public List<BrokerInfo> getData() {
        return this.data;
    }

    public List<BrokerInfo> getConfigurableList() {
        return this.configurableList;
    }

    public List<BrokerInfo> getWorkingList() {
        return this.workingList;
    }

    public List<BrokerInfo> getIdleList() {
        return this.idleList;
    }

    public List<Integer> getNeedReloadList() {
        return this.needReloadList;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public void setData(List<BrokerInfo> data) {
        this.data = data;
    }

    public void setConfigurableList(List<BrokerInfo> configurableList) {
        this.configurableList = configurableList;
    }

    public void setWorkingList(List<BrokerInfo> workingList) {
        this.workingList = workingList;
    }

    public void setIdleList(List<BrokerInfo> idleList) {
        this.idleList = idleList;
    }

    public void setNeedReloadList(List<Integer> needReloadList) {
        this.needReloadList = needReloadList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TubeHttpBrokerInfoList)) {
            return false;
        }
        TubeHttpBrokerInfoList other = (TubeHttpBrokerInfoList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$errMsg = this.getErrMsg();
        String other$errMsg = other.getErrMsg();
        if (this$errMsg == null ? other$errMsg != null : !this$errMsg.equals(other$errMsg)) {
            return false;
        }
        List<BrokerInfo> this$data = this.getData();
        List<BrokerInfo> other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        List<BrokerInfo> this$configurableList = this.getConfigurableList();
        List<BrokerInfo> other$configurableList = other.getConfigurableList();
        if (this$configurableList == null ? other$configurableList != null : !((Object)this$configurableList).equals(other$configurableList)) {
            return false;
        }
        List<BrokerInfo> this$workingList = this.getWorkingList();
        List<BrokerInfo> other$workingList = other.getWorkingList();
        if (this$workingList == null ? other$workingList != null : !((Object)this$workingList).equals(other$workingList)) {
            return false;
        }
        List<BrokerInfo> this$idleList = this.getIdleList();
        List<BrokerInfo> other$idleList = other.getIdleList();
        if (this$idleList == null ? other$idleList != null : !((Object)this$idleList).equals(other$idleList)) {
            return false;
        }
        List<Integer> this$needReloadList = this.getNeedReloadList();
        List<Integer> other$needReloadList = other.getNeedReloadList();
        return !(this$needReloadList == null ? other$needReloadList != null : !((Object)this$needReloadList).equals(other$needReloadList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TubeHttpBrokerInfoList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $errMsg = this.getErrMsg();
        result = result * 59 + ($errMsg == null ? 43 : $errMsg.hashCode());
        List<BrokerInfo> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        List<BrokerInfo> $configurableList = this.getConfigurableList();
        result = result * 59 + ($configurableList == null ? 43 : ((Object)$configurableList).hashCode());
        List<BrokerInfo> $workingList = this.getWorkingList();
        result = result * 59 + ($workingList == null ? 43 : ((Object)$workingList).hashCode());
        List<BrokerInfo> $idleList = this.getIdleList();
        result = result * 59 + ($idleList == null ? 43 : ((Object)$idleList).hashCode());
        List<Integer> $needReloadList = this.getNeedReloadList();
        result = result * 59 + ($needReloadList == null ? 43 : ((Object)$needReloadList).hashCode());
        return result;
    }

    public String toString() {
        return "TubeHttpBrokerInfoList(code=" + this.getCode() + ", errMsg=" + this.getErrMsg() + ", data=" + this.getData() + ", configurableList=" + this.getConfigurableList() + ", workingList=" + this.getWorkingList() + ", idleList=" + this.getIdleList() + ", needReloadList=" + this.getNeedReloadList() + ")";
    }

    public static class BrokerInfo {
        private int brokerId;
        private String brokerIp;
        private int brokerPort;
        private String manageStatus;
        private String runStatus;
        private String subStatus;
        private int stepOp;
        private boolean isConfChanged;
        private boolean isConfLoaded;
        private boolean isBrokerOnline;
        private String brokerVersion;
        private boolean acceptPublish;
        private boolean acceptSubscribe;

        private boolean isIdle() {
            return this.subStatus != null && TubeHttpBrokerInfoList.IDLE.equals(this.subStatus);
        }

        private boolean isWorking() {
            if (this.runStatus != null && this.manageStatus != null) {
                return TubeHttpBrokerInfoList.RUNNING.equals(this.runStatus) && (TubeHttpBrokerInfoList.ONLINE.equals(this.manageStatus) || TubeHttpBrokerInfoList.ONLY_READ.equals(this.manageStatus) || TubeHttpBrokerInfoList.ONLY_WRITE.equals(this.manageStatus));
            }
            return false;
        }

        private boolean isConfigurable() {
            return this.stepOp == 0 || this.stepOp == -2 || this.stepOp == 31 || this.stepOp == 32;
        }

        public int hashCode() {
            return this.brokerId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BrokerInfo)) {
                return false;
            }
            BrokerInfo brokerInfo = (BrokerInfo)o;
            return this.brokerId == brokerInfo.brokerId;
        }

        public int getBrokerId() {
            return this.brokerId;
        }

        public String getBrokerIp() {
            return this.brokerIp;
        }

        public int getBrokerPort() {
            return this.brokerPort;
        }

        public String getManageStatus() {
            return this.manageStatus;
        }

        public String getRunStatus() {
            return this.runStatus;
        }

        public String getSubStatus() {
            return this.subStatus;
        }

        public int getStepOp() {
            return this.stepOp;
        }

        public boolean isConfChanged() {
            return this.isConfChanged;
        }

        public boolean isConfLoaded() {
            return this.isConfLoaded;
        }

        public boolean isBrokerOnline() {
            return this.isBrokerOnline;
        }

        public String getBrokerVersion() {
            return this.brokerVersion;
        }

        public boolean isAcceptPublish() {
            return this.acceptPublish;
        }

        public boolean isAcceptSubscribe() {
            return this.acceptSubscribe;
        }

        public void setBrokerId(int brokerId) {
            this.brokerId = brokerId;
        }

        public void setBrokerIp(String brokerIp) {
            this.brokerIp = brokerIp;
        }

        public void setBrokerPort(int brokerPort) {
            this.brokerPort = brokerPort;
        }

        public void setManageStatus(String manageStatus) {
            this.manageStatus = manageStatus;
        }

        public void setRunStatus(String runStatus) {
            this.runStatus = runStatus;
        }

        public void setSubStatus(String subStatus) {
            this.subStatus = subStatus;
        }

        public void setStepOp(int stepOp) {
            this.stepOp = stepOp;
        }

        public void setConfChanged(boolean isConfChanged) {
            this.isConfChanged = isConfChanged;
        }

        public void setConfLoaded(boolean isConfLoaded) {
            this.isConfLoaded = isConfLoaded;
        }

        public void setBrokerOnline(boolean isBrokerOnline) {
            this.isBrokerOnline = isBrokerOnline;
        }

        public void setBrokerVersion(String brokerVersion) {
            this.brokerVersion = brokerVersion;
        }

        public void setAcceptPublish(boolean acceptPublish) {
            this.acceptPublish = acceptPublish;
        }

        public void setAcceptSubscribe(boolean acceptSubscribe) {
            this.acceptSubscribe = acceptSubscribe;
        }

        public String toString() {
            return "TubeHttpBrokerInfoList.BrokerInfo(brokerId=" + this.getBrokerId() + ", brokerIp=" + this.getBrokerIp() + ", brokerPort=" + this.getBrokerPort() + ", manageStatus=" + this.getManageStatus() + ", runStatus=" + this.getRunStatus() + ", subStatus=" + this.getSubStatus() + ", stepOp=" + this.getStepOp() + ", isConfChanged=" + this.isConfChanged() + ", isConfLoaded=" + this.isConfLoaded() + ", isBrokerOnline=" + this.isBrokerOnline() + ", brokerVersion=" + this.getBrokerVersion() + ", acceptPublish=" + this.isAcceptPublish() + ", acceptSubscribe=" + this.isAcceptSubscribe() + ")";
        }
    }
}

