/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.metadata;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;
import org.apache.inlong.tubemq.server.broker.metadata.BrokerDefMetadata;
import org.apache.inlong.tubemq.server.broker.metadata.ClusterConfigHolder;

public class TopicMetadata {
    private String topic;
    private int statusId = 0;
    private int numTopicStores = 1;
    private int numPartitions = 1;
    private int unflushThreshold = 1000;
    private int unflushInterval = 10000;
    private int unflushDataHold = 0;
    private boolean acceptPublish = true;
    private boolean acceptSubscribe = true;
    private String dataPath;
    @Deprecated
    private String deleteWhen = "0 0 6,18 * * ?";
    private String deletePolicy = "delete,168h";
    private int memCacheMsgSize = 0x100000;
    private int memCacheMsgCnt = 5120;
    private int memCacheFlushIntvl = 20000;
    private int maxMsgSize = -2;
    private int minMemCacheSize = -2;

    public TopicMetadata(BrokerDefMetadata brokerDefMetadata, String topicMetaConfInfo) {
        if (TStringUtils.isBlank((String)topicMetaConfInfo)) {
            return;
        }
        String[] topicConfInfoArr = topicMetaConfInfo.split(":", -1);
        this.topic = topicConfInfoArr[0];
        this.numPartitions = TStringUtils.isBlank((String)topicConfInfoArr[1]) ? brokerDefMetadata.getNumPartitions() : Integer.parseInt(topicConfInfoArr[1]);
        this.acceptPublish = TStringUtils.isBlank((String)topicConfInfoArr[2]) ? brokerDefMetadata.isAcceptPublish() : Boolean.parseBoolean(topicConfInfoArr[2]);
        this.acceptSubscribe = TStringUtils.isBlank((String)topicConfInfoArr[3]) ? brokerDefMetadata.isAcceptSubscribe() : Boolean.parseBoolean(topicConfInfoArr[3]);
        this.unflushThreshold = TStringUtils.isBlank((String)topicConfInfoArr[4]) ? brokerDefMetadata.getUnflushThreshold() : Integer.parseInt(topicConfInfoArr[4]);
        this.unflushInterval = TStringUtils.isBlank((String)topicConfInfoArr[5]) ? brokerDefMetadata.getUnflushInterval() : Integer.parseInt(topicConfInfoArr[5]);
        this.deleteWhen = TStringUtils.isBlank((String)topicConfInfoArr[6]) ? brokerDefMetadata.getDeleteWhen() : topicConfInfoArr[6];
        this.deletePolicy = TStringUtils.isBlank((String)topicConfInfoArr[7]) ? brokerDefMetadata.getDeletePolicy() : topicConfInfoArr[7];
        this.numTopicStores = TStringUtils.isBlank((String)topicConfInfoArr[8]) ? brokerDefMetadata.getNumTopicStores() : Integer.parseInt(topicConfInfoArr[8]);
        this.statusId = TStringUtils.isBlank((String)topicConfInfoArr[9]) ? 0 : Integer.parseInt(topicConfInfoArr[9]);
        this.unflushDataHold = TStringUtils.isBlank((String)topicConfInfoArr[10]) ? brokerDefMetadata.getUnflushDataHold() : Integer.parseInt(topicConfInfoArr[10]);
        this.memCacheMsgSize = TStringUtils.isBlank((String)topicConfInfoArr[11]) ? brokerDefMetadata.getMemCacheMsgSize() : Integer.parseInt(topicConfInfoArr[11]) * 1024 * 512;
        this.memCacheMsgCnt = TStringUtils.isBlank((String)topicConfInfoArr[12]) ? brokerDefMetadata.getMemCacheMsgCnt() : Integer.parseInt(topicConfInfoArr[12]) * 512;
        this.memCacheFlushIntvl = TStringUtils.isBlank((String)topicConfInfoArr[13]) ? brokerDefMetadata.getMemCacheFlushInterval() : Integer.parseInt(topicConfInfoArr[13]);
        this.maxMsgSize = ClusterConfigHolder.getMaxMsgSize();
        this.minMemCacheSize = ClusterConfigHolder.getMinMemCacheSize();
        if (topicConfInfoArr.length > 14 && TStringUtils.isNotBlank((String)topicConfInfoArr[14])) {
            int maxMsgSize = Integer.parseInt(topicConfInfoArr[14]);
            Tuple2<Integer, Integer> calcResult = ClusterConfigHolder.calcMaxMsgSize(maxMsgSize);
            this.maxMsgSize = (Integer)calcResult.getF0();
            this.minMemCacheSize = (Integer)calcResult.getF1();
        }
    }

    public TopicMetadata(BrokerDefMetadata brokerDefMetadata, String topicName, int numTopicStores, int numPartitions) {
        this.topic = topicName;
        this.numTopicStores = numTopicStores;
        this.numPartitions = numPartitions;
        this.acceptPublish = brokerDefMetadata.isAcceptPublish();
        this.acceptSubscribe = brokerDefMetadata.isAcceptSubscribe();
        this.unflushThreshold = brokerDefMetadata.getUnflushThreshold();
        this.unflushInterval = brokerDefMetadata.getUnflushInterval();
        this.deleteWhen = brokerDefMetadata.getDeleteWhen();
        this.deletePolicy = brokerDefMetadata.getDeletePolicy();
        this.statusId = 0;
        this.unflushDataHold = brokerDefMetadata.getUnflushDataHold();
        this.memCacheMsgSize = brokerDefMetadata.getMemCacheMsgSize();
        this.memCacheMsgCnt = brokerDefMetadata.getMemCacheMsgCnt();
        this.memCacheFlushIntvl = brokerDefMetadata.getMemCacheFlushInterval();
        this.maxMsgSize = ClusterConfigHolder.getMaxMsgSize();
        this.minMemCacheSize = ClusterConfigHolder.getMinMemCacheSize();
    }

    private TopicMetadata(String topic, int unflushThreshold, int unflushInterval, int unflushDataHold, String dataPath, String deleteWhen, String deletePolicy, int numPartitions, boolean acceptPublish, boolean acceptSubscribe, int statusId, int numTopicStores, int memCacheMsgSize, int memCacheMsgCnt, int memCacheFlushIntvl, int maxMsgSize, int minMemCacheSize) {
        this.topic = topic;
        this.unflushThreshold = unflushThreshold;
        this.unflushInterval = unflushInterval;
        this.unflushDataHold = unflushDataHold;
        this.dataPath = dataPath;
        this.deleteWhen = deleteWhen;
        this.deletePolicy = deletePolicy;
        this.numPartitions = numPartitions;
        this.acceptPublish = acceptPublish;
        this.acceptSubscribe = acceptSubscribe;
        this.statusId = statusId;
        this.numTopicStores = numTopicStores;
        this.memCacheMsgSize = memCacheMsgSize;
        this.memCacheMsgCnt = memCacheMsgCnt;
        this.memCacheFlushIntvl = memCacheFlushIntvl;
        this.maxMsgSize = maxMsgSize;
        this.minMemCacheSize = minMemCacheSize;
    }

    public TopicMetadata clone() {
        return new TopicMetadata(this.topic, this.unflushThreshold, this.unflushInterval, this.unflushDataHold, this.dataPath, this.deleteWhen, this.deletePolicy, this.numPartitions, this.acceptPublish, this.acceptSubscribe, this.statusId, this.numTopicStores, this.memCacheMsgSize, this.memCacheMsgCnt, this.memCacheFlushIntvl, this.maxMsgSize, this.minMemCacheSize);
    }

    public boolean isAcceptPublish() {
        return this.acceptPublish;
    }

    public boolean isAcceptSubscribe() {
        return this.acceptSubscribe;
    }

    public int getNumTopicStores() {
        return this.numTopicStores;
    }

    public int getNumPartitions() {
        return this.numPartitions;
    }

    public String getDeletePolicy() {
        return this.deletePolicy;
    }

    public void setDeletePolicy(String deletePolicy) {
        this.deletePolicy = deletePolicy;
    }

    public String getDeleteWhen() {
        return this.deleteWhen;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public int getUnflushThreshold() {
        return this.unflushThreshold;
    }

    public void setUnflushThreshold(int unflushThreshold) {
        this.unflushThreshold = unflushThreshold;
    }

    public int getUnflushDataHold() {
        return this.unflushDataHold;
    }

    public void setUnflushDataHold(int unflushDataHold) {
        this.unflushDataHold = unflushDataHold;
    }

    public int getUnflushInterval() {
        return this.unflushInterval;
    }

    public void setUnflushInterval(int unflushInterval) {
        this.unflushInterval = unflushInterval;
    }

    public Set<Integer> getAllPartitionIds() {
        HashSet<Integer> partIds = new HashSet<Integer>();
        for (int i = 0; i < this.numTopicStores; ++i) {
            for (int j = 0; j < this.numPartitions; ++j) {
                partIds.add(i * 10000 + j);
            }
        }
        return partIds;
    }

    public Map<Integer, Set<Integer>> getStorePartIdMap() {
        HashMap<Integer, Set<Integer>> storePartIds = new HashMap<Integer, Set<Integer>>();
        for (int i = 0; i < this.numTopicStores; ++i) {
            HashSet<Integer> partIds = new HashSet<Integer>();
            for (int j = 0; j < this.numPartitions; ++j) {
                partIds.add(i * 10000 + j);
            }
            storePartIds.put(i, partIds);
        }
        return storePartIds;
    }

    public int getStoreIdByPartitionId(int partitionId) {
        return partitionId % 10000;
    }

    public Set<Integer> getPartIdsByStoreId(int storeId) {
        HashSet<Integer> partIds = new HashSet<Integer>();
        if (storeId >= 0 && storeId < this.numTopicStores) {
            for (int i = 0; i < this.numPartitions; ++i) {
                partIds.add(storeId * 10000 + i);
            }
        }
        return partIds;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public void setStatusId(int statusId) {
        this.statusId = statusId;
    }

    public boolean isValidTopic() {
        return this.statusId == 0;
    }

    public int getMemCacheMsgSize() {
        return this.memCacheMsgSize;
    }

    public int getMemCacheMsgCnt() {
        return this.memCacheMsgCnt;
    }

    public int getMemCacheFlushIntvl() {
        return this.memCacheFlushIntvl;
    }

    public int getMaxMsgSize() {
        return this.maxMsgSize;
    }

    public int getMinMemCacheSize() {
        return this.minMemCacheSize;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.acceptPublish ? 1231 : 1237);
        result = 31 * result + (this.acceptSubscribe ? 1231 : 1237);
        result = 31 * result + (this.dataPath == null ? 0 : this.dataPath.hashCode());
        result = 31 * result + (this.deletePolicy == null ? 0 : this.deletePolicy.hashCode());
        result = 31 * result + (this.deleteWhen == null ? 0 : this.deleteWhen.hashCode());
        result = 31 * result + this.numPartitions;
        result = 31 * result + this.numTopicStores;
        result = 31 * result + (this.topic == null ? 0 : this.topic.hashCode());
        result = 31 * result + this.unflushInterval;
        result = 31 * result + this.unflushThreshold;
        result = 31 * result + this.unflushDataHold;
        result = 31 * result + this.statusId;
        result = 31 * result + this.memCacheMsgSize;
        result = 31 * result + this.memCacheMsgCnt;
        result = 31 * result + this.memCacheFlushIntvl;
        result = 31 * result + this.maxMsgSize;
        result = 31 * result + this.minMemCacheSize;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TopicMetadata other = (TopicMetadata)obj;
        if (this.acceptPublish != other.acceptPublish) {
            return false;
        }
        if (this.acceptSubscribe != other.acceptSubscribe) {
            return false;
        }
        if (this.dataPath == null ? other.dataPath != null : !this.dataPath.equals(other.dataPath)) {
            return false;
        }
        if (this.deletePolicy == null ? other.deletePolicy != null : !this.deletePolicy.equals(other.deletePolicy)) {
            return false;
        }
        if (this.deleteWhen == null ? other.deleteWhen != null : !this.deleteWhen.equals(other.deleteWhen)) {
            return false;
        }
        if (this.numPartitions != other.numPartitions) {
            return false;
        }
        if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
            return false;
        }
        if (this.unflushInterval != other.unflushInterval) {
            return false;
        }
        if (this.unflushThreshold != other.unflushThreshold) {
            return false;
        }
        if (this.unflushDataHold != other.unflushDataHold) {
            return false;
        }
        if (this.statusId != other.statusId) {
            return false;
        }
        if (this.numTopicStores != other.numTopicStores) {
            return false;
        }
        if (this.memCacheMsgSize != other.memCacheMsgSize) {
            return false;
        }
        if (this.memCacheMsgCnt != other.memCacheMsgCnt) {
            return false;
        }
        if (this.memCacheFlushIntvl != other.memCacheFlushIntvl) {
            return false;
        }
        if (this.maxMsgSize != other.maxMsgSize) {
            return false;
        }
        return this.minMemCacheSize == other.minMemCacheSize;
    }

    public boolean isPropertyEquals(TopicMetadata other) {
        return this.numPartitions == other.numPartitions && this.unflushInterval == other.unflushInterval && this.unflushThreshold == other.unflushThreshold && this.unflushDataHold == other.unflushDataHold && this.memCacheMsgSize == other.memCacheMsgSize && this.memCacheMsgCnt == other.memCacheMsgCnt && this.memCacheFlushIntvl == other.memCacheFlushIntvl && this.maxMsgSize == other.maxMsgSize && this.deletePolicy.equals(other.deletePolicy);
    }

    public String toString() {
        return new StringBuilder(512).append("TopicMetadata [topic=").append(this.topic).append(", unflushThreshold=").append(this.unflushThreshold).append(", unflushInterval=").append(this.unflushInterval).append(", unflushDataHold=").append(this.unflushDataHold).append(", dataPath=").append(this.dataPath).append(", deleteWhen=").append(this.deleteWhen).append(", deletePolicy=").append(this.deletePolicy).append(", numPartitions=").append(this.numPartitions).append(", acceptPublish=").append(this.acceptPublish).append(", acceptSubscribe=").append(this.acceptSubscribe).append(", statusId=").append(this.statusId).append(", numTopicStores=").append(this.numTopicStores).append(", memCacheMsgSizeInMs=").append(this.memCacheMsgSize / 1024 / 512).append(", memCacheMsgCntInK=").append(this.memCacheMsgCnt / 512).append(", memCacheFlushIntvl=").append(this.memCacheFlushIntvl).append(", maxMsgSize=").append(this.maxMsgSize).append(", minMemCacheSize=").append(this.minMemCacheSize).append("]").toString();
    }
}

