/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.bdbstore.bdbentitys;

import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.inlong.tubemq.corebase.utils.DateTimeConvertUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;

@Entity
public class BdbBrokerConfEntity
implements Serializable {
    private static final long serialVersionUID = 3961934697293763691L;
    @PrimaryKey
    private int brokerId = -2;
    private String brokerIp;
    private int brokerPort = -2;
    private String brokerAddress;
    private String brokerFullInfo;
    private String brokerSimpleInfo;
    private int regionId = -2;
    private int manageStatus = -2;
    private int numPartitions = -2;
    private int unflushThreshold = -2;
    private int unflushInterval = -2;
    private String deleteWhen;
    private String deletePolicy;
    private int dataStoreType = -2;
    private String dataPath;
    private String attributes;
    private boolean acceptPublish = true;
    private boolean acceptSubscribe = true;
    private boolean isConfDataUpdated = false;
    private boolean isBrokerLoaded = false;
    private String createUser;
    private Date createDate;
    private String modifyUser;
    private Date modifyDate;
    private String brokerTLSSimpleInfo;
    private String brokerTLSFullInfo;

    public BdbBrokerConfEntity() {
    }

    public BdbBrokerConfEntity(int brokerId, String brokerIp, int brokerPort, int numPartitions, int unflushThreshold, int unflushInterval, String deleteWhen, String deletePolicy, int manageStatus, boolean acceptPublish, boolean acceptSubscribe, String attributes, boolean isConfDataUpdated, boolean isBrokerLoaded, String createUser, Date createDate, String modifyUser, Date modifyDate) {
        this.brokerId = brokerId;
        this.brokerIp = brokerIp;
        this.brokerPort = brokerPort;
        this.manageStatus = manageStatus;
        this.numPartitions = numPartitions;
        this.unflushThreshold = unflushThreshold;
        this.unflushInterval = unflushInterval;
        this.deleteWhen = deleteWhen;
        this.deletePolicy = deletePolicy;
        this.acceptPublish = acceptPublish;
        this.acceptSubscribe = acceptSubscribe;
        this.isConfDataUpdated = isConfDataUpdated;
        this.isBrokerLoaded = isBrokerLoaded;
        this.createUser = createUser;
        this.createDate = createDate;
        this.modifyUser = modifyUser;
        this.modifyDate = modifyDate;
        this.attributes = attributes;
        this.buildStrInfo();
    }

    public StringBuilder toJsonString(StringBuilder sb) {
        return sb.append("{\"type\":\"BdbBrokerConfEntity\",").append("\"brokerId\":\"").append(this.brokerId).append("\",\"brokerAddress\":\"").append(this.brokerAddress).append("\",\"manageStatus\":\"").append(this.manageStatus).append("\",\"numPartitions\":").append(this.numPartitions).append(",\"unflushThreshold\":").append(this.unflushThreshold).append(",\"unflushInterval\":").append(this.unflushInterval).append(",\"deleteWhen\":\"").append(this.deleteWhen).append("\",\"deletePolicy\":\"").append(this.deletePolicy).append("\",\"manageStatus\":").append(this.manageStatus).append(",\"acceptPublish\":").append(this.acceptPublish).append(",\"acceptSubscribe\":").append(this.acceptSubscribe).append(",\"isConfDataUpdated\":").append(this.isConfDataUpdated).append(",\"isBrokerLoaded\":").append(this.isBrokerLoaded).append(",\"numTopicStores\":").append(this.getNumTopicStores()).append(",\"dataPath\":\"").append(this.dataPath).append("\",\"unflushDataHold\":").append(this.getDftUnFlushDataHold()).append(",\"memCacheMsgSizeInMB\":").append(this.getDftMemCacheMsgSizeInMB()).append(",\"memCacheMsgCntInK\":").append(this.getDftMemCacheMsgCntInK()).append(",\"memCacheFlushIntvl\":").append(this.getDftMemCacheFlushIntvl()).append(",\"createUser\":\"").append(this.createUser).append("\",\"createDate\":\"").append(DateTimeConvertUtils.date2yyyyMMddHHmmss((Date)this.createDate)).append("\",\"modifyUser\":\"").append(this.modifyUser).append("\",\"modifyDate\":\"").append(DateTimeConvertUtils.date2yyyyMMddHHmmss((Date)this.modifyDate)).append("\"}");
    }

    public String getBrokerDefaultConfInfo() {
        return new StringBuilder(512).append(this.getDftNumPartitions()).append(":").append(this.isAcceptPublish()).append(":").append(this.isAcceptSubscribe()).append(":").append(this.getDftUnflushThreshold()).append(":").append(this.getDftUnflushInterval()).append(":").append(this.getDftDeleteWhen()).append(":").append(this.getDftDeletePolicy()).append(":").append(this.getNumTopicStores()).append(":").append(this.getDftUnFlushDataHold()).append(":").append(this.getDftMemCacheMsgSizeInMB()).append(":").append(this.getDftMemCacheMsgCntInK()).append(":").append(this.getDftMemCacheFlushIntvl()).toString();
    }

    public void setConfDataUpdated() {
        this.isBrokerLoaded = false;
        this.isConfDataUpdated = true;
    }

    public boolean isConfDataUpdated() {
        return this.isConfDataUpdated;
    }

    public boolean isBrokerLoaded() {
        return this.isBrokerLoaded;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public void setAttributes(String attributes) {
        this.attributes = attributes;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public void setDataStore(int dataStoreType, String dataPath) {
        this.dataPath = dataPath;
        this.dataStoreType = dataStoreType;
    }

    public int getDataStoreType() {
        return this.dataStoreType;
    }

    public void setBrokerLoaded() {
        this.isBrokerLoaded = true;
        this.isConfDataUpdated = false;
    }

    public String getSimpleBrokerInfo() {
        if (this.brokerPort == 8123) {
            return this.brokerSimpleInfo;
        }
        return this.brokerFullInfo;
    }

    public String getSimpleTLSBrokerInfo() {
        if (this.getBrokerTLSPort() == 8124) {
            return this.brokerTLSSimpleInfo;
        }
        return this.brokerTLSFullInfo;
    }

    public String getBrokerIdAndAddress() {
        return this.brokerFullInfo;
    }

    public int getDftUnflushThreshold() {
        return this.unflushThreshold;
    }

    public void setDftUnflushThreshold(int unflushThreshold) {
        this.unflushThreshold = unflushThreshold;
    }

    public int getDftUnflushInterval() {
        return this.unflushInterval;
    }

    public void setDftUnflushInterval(int unflushInterval) {
        this.unflushInterval = unflushInterval;
    }

    public String getDftDeleteWhen() {
        return this.deleteWhen;
    }

    public void setDftDeleteWhen(String deleteWhen) {
        this.deleteWhen = deleteWhen;
    }

    public String getDftDeletePolicy() {
        return this.deletePolicy;
    }

    public void setDftDeletePolicy(String deletePolicy) {
        this.deletePolicy = deletePolicy;
    }

    public int getManageStatus() {
        return this.manageStatus;
    }

    public void setManageStatus(int manageStatus) {
        this.manageStatus = manageStatus;
    }

    public int getBrokerId() {
        return this.brokerId;
    }

    public void setBrokerId(int brokerId) {
        this.brokerId = brokerId;
    }

    public int getNumTopicStores() {
        String atrVal = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"storeNum");
        if (atrVal != null) {
            return Integer.parseInt(atrVal);
        }
        return 1;
    }

    public BdbBrokerConfEntity setNumTopicStores(int numTopicStores) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"storeNum", (String)String.valueOf(numTopicStores));
        return this;
    }

    public int getDftMemCacheMsgCntInK() {
        String atrVal = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"memCacheMsgCntInK");
        if (atrVal != null) {
            return Integer.parseInt(atrVal);
        }
        return 10;
    }

    public void setDftMemCacheMsgCntInK(int memCacheMsgCntInK) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"memCacheMsgCntInK", (String)String.valueOf(memCacheMsgCntInK));
    }

    public int getDftMemCacheMsgSizeInMB() {
        String atrVal = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"memCacheMsgSizeInMB");
        if (atrVal != null) {
            return Integer.parseInt(atrVal);
        }
        return 2;
    }

    public void setDftMemCacheMsgSizeInMB(int memCacheMsgSizeInMB) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"memCacheMsgSizeInMB", (String)String.valueOf(memCacheMsgSizeInMB));
    }

    public int getDftMemCacheFlushIntvl() {
        String atrVal = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"memCacheFlushIntvl");
        if (atrVal != null) {
            return Integer.parseInt(atrVal);
        }
        return 20000;
    }

    public void setDftMemCacheFlushIntvl(int memCacheFlushIntvl) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"memCacheFlushIntvl", (String)String.valueOf(memCacheFlushIntvl));
    }

    public int getDftUnFlushDataHold() {
        String atrVal = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"unFlushDataHold");
        if (atrVal != null) {
            return Integer.parseInt(atrVal);
        }
        return 0;
    }

    public void setDftUnFlushDataHold(int unFlushDataHold) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"unFlushDataHold", (String)String.valueOf(unFlushDataHold));
    }

    public int getBrokerTLSPort() {
        String atrVal = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"TLSPort");
        if (atrVal != null) {
            return Integer.parseInt(atrVal);
        }
        return 8124;
    }

    public void setBrokerTLSPort(int brokerTLSPort) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"TLSPort", (String)String.valueOf(brokerTLSPort));
    }

    public int getRegionId() {
        return this.regionId;
    }

    public BdbBrokerConfEntity setRegionId(int regionId) {
        this.regionId = regionId;
        return this;
    }

    public String getBrokerAddress() {
        return this.brokerAddress;
    }

    public String getBrokerIp() {
        return this.brokerIp;
    }

    public void setBrokerIp(String brokerIp) {
        this.brokerIp = brokerIp;
    }

    public int getBrokerPort() {
        return this.brokerPort;
    }

    public int getDftNumPartitions() {
        return this.numPartitions;
    }

    public void setDftNumPartitions(int numPartitions) {
        this.numPartitions = numPartitions;
    }

    public String getRecordCreateUser() {
        return this.createUser;
    }

    public void setRecordCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public Date getRecordCreateDate() {
        return this.createDate;
    }

    public void setRecordCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public String getRecordModifyUser() {
        return this.modifyUser;
    }

    public void setRecordModifyUser(String modifyUser) {
        this.modifyUser = modifyUser;
    }

    public Date getRecordModifyDate() {
        return this.modifyDate;
    }

    public void setRecordModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }

    public boolean isAcceptPublish() {
        return this.acceptPublish;
    }

    public void setDftAcceptPublish(boolean acceptPublish) {
        this.acceptPublish = acceptPublish;
    }

    public boolean isAcceptSubscribe() {
        return this.acceptSubscribe;
    }

    public void setDftAcceptSubscribe(boolean acceptSubscribe) {
        this.acceptSubscribe = acceptSubscribe;
    }

    public void setBrokerIpAndPort(String brokerIp, int brokerPort) {
        this.brokerPort = brokerPort;
        this.brokerIp = brokerIp;
        this.buildStrInfo();
    }

    public void appendAttributes(String attrKey, String attrVal) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)attrKey, (String)attrVal);
    }

    public long getDataVerId() {
        String atrVal = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"dataVerId");
        if (atrVal != null) {
            return Long.parseLong(atrVal);
        }
        return -2L;
    }

    public BdbBrokerConfEntity setDataVerId(long dataVerId) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"dataVerId", (String)String.valueOf(dataVerId));
        return this;
    }

    public int getBrokerGroupId() {
        String atrVal = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"bGroupId");
        if (atrVal != null) {
            return Integer.parseInt(atrVal);
        }
        return -2;
    }

    public void setBrokerGroupId(long brokerGroupId) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"bGroupId", (String)String.valueOf(brokerGroupId));
    }

    public int getBrokerWebPort() {
        String atrVal = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"bWebPort");
        if (atrVal != null) {
            return Integer.parseInt(atrVal);
        }
        return -2;
    }

    public void setBrokerWebPort(int brokerWebPort) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"bWebPort", (String)String.valueOf(brokerWebPort));
    }

    public void buildStrInfo() {
        StringBuilder sBuilder = new StringBuilder(512);
        this.brokerAddress = sBuilder.append(this.brokerIp).append(":").append(this.brokerPort).toString();
        sBuilder.delete(0, sBuilder.length());
        this.brokerSimpleInfo = sBuilder.append(this.brokerId).append(":").append(this.brokerIp).append(":").append(" ").toString();
        sBuilder.delete(0, sBuilder.length());
        this.brokerFullInfo = sBuilder.append(this.brokerId).append(":").append(this.brokerIp).append(":").append(this.brokerPort).toString();
        sBuilder.delete(0, sBuilder.length());
        this.brokerTLSSimpleInfo = sBuilder.append(this.brokerId).append(":").append(this.brokerIp).append(":").append(" ").toString();
        sBuilder.delete(0, sBuilder.length());
        this.brokerTLSFullInfo = sBuilder.append(this.brokerId).append(":").append(this.brokerIp).append(":").append(this.getBrokerTLSPort()).toString();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("brokerId", this.brokerId).append("brokerIp", (Object)this.brokerIp).append("brokerPort", this.brokerPort).append("brokerAddress", (Object)this.brokerAddress).append("brokerFullInfo", (Object)this.brokerFullInfo).append("brokerSimpleInfo", (Object)this.brokerSimpleInfo).append("regionId", this.regionId).append("manageStatus", this.manageStatus).append("numPartitions", this.numPartitions).append("unflushThreshold", this.unflushThreshold).append("unflushInterval", this.unflushInterval).append("deleteWhen", (Object)this.deleteWhen).append("deletePolicy", (Object)this.deletePolicy).append("dataStoreType", this.dataStoreType).append("dataPath", (Object)this.dataPath).append("attributes", (Object)this.attributes).append("acceptPublish", this.acceptPublish).append("acceptSubscribe", this.acceptSubscribe).append("isConfDataUpdated", this.isConfDataUpdated).append("isBrokerLoaded", this.isBrokerLoaded).append("createUser", (Object)this.createUser).append("createDate", (Object)this.createDate).append("modifyUser", (Object)this.modifyUser).append("modifyDate", (Object)this.modifyDate).append("brokerTLSSimpleInfo", (Object)this.brokerTLSSimpleInfo).append("brokerTLSFullInfo", (Object)this.brokerTLSFullInfo).toString();
    }
}

