/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.bdbimpl;

import com.sleepycat.je.Environment;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.StoreConfig;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.server.common.exception.LoadMetaException;
import org.apache.inlong.tubemq.server.master.bdbstore.bdbentitys.BdbBrokerConfEntity;
import org.apache.inlong.tubemq.server.master.metamanage.DataOpErrCode;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BrokerConfEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.AbsBrokerConfigMapperImpl;

public class BdbBrokerConfigMapperImpl
extends AbsBrokerConfigMapperImpl {
    private EntityStore brokerConfStore;
    private final PrimaryIndex<Integer, BdbBrokerConfEntity> brokerConfIndex;

    public BdbBrokerConfigMapperImpl(ReplicatedEnvironment repEnv, StoreConfig storeConfig) {
        this.brokerConfStore = new EntityStore((Environment)repEnv, "bdbBrokerConfig", storeConfig);
        this.brokerConfIndex = this.brokerConfStore.getPrimaryIndex(Integer.class, BdbBrokerConfEntity.class);
    }

    @Override
    public void close() {
        this.clearCachedData();
        if (this.brokerConfStore != null) {
            try {
                this.brokerConfStore.close();
                this.brokerConfStore = null;
            }
            catch (Throwable e) {
                logger.error("[BDB Impl] close broker configure failure ", e);
            }
        }
        logger.info("[BDB Impl] broker configure closed!");
    }

    @Override
    public void loadConfig(StringBuilder strBuff) throws LoadMetaException {
        long totalCnt = 0L;
        EntityCursor cursor = null;
        logger.info("[BDB Impl] load broker configure start...");
        this.clearCachedData();
        try {
            cursor = this.brokerConfIndex.entities();
            for (BdbBrokerConfEntity bdbEntity : cursor) {
                if (bdbEntity == null) {
                    logger.warn("[BDB Impl] found Null data while loading broker configure!");
                    continue;
                }
                this.putRecord2Caches(new BrokerConfEntity(bdbEntity));
                ++totalCnt;
            }
        }
        catch (Exception e) {
            logger.error("[BDB Impl] load broker configure failure ", (Throwable)e);
            throw new LoadMetaException(e.getMessage());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        logger.info(strBuff.append("[BDB Impl] loaded ").append(totalCnt).append(" broker configure successfully...").toString());
        strBuff.delete(0, strBuff.length());
    }

    @Override
    protected boolean putConfig2Persistent(BrokerConfEntity entity, StringBuilder strBuff, ProcessResult result) {
        BdbBrokerConfEntity bdbEntity = entity.buildBdbBrokerConfEntity();
        try {
            this.brokerConfIndex.put((Object)bdbEntity);
        }
        catch (Throwable e) {
            logger.error("[BDB Impl] put broker configure failure ", e);
            result.setFailResult(DataOpErrCode.DERR_STORE_ABNORMAL.getCode(), strBuff.append("Put broker configure failure: ").append(e.getMessage()).toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        result.setSuccResult(null);
        return result.isSuccess();
    }

    @Override
    protected boolean delConfigFromPersistent(int brokerId, StringBuilder strBuff) {
        try {
            this.brokerConfIndex.delete((Object)brokerId);
        }
        catch (Throwable e) {
            logger.error("[BDB Impl] delete broker configure failure ", e);
            return false;
        }
        return true;
    }
}

