/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer;

import java.util.concurrent.atomic.AtomicInteger;

public class NodeRebInfo {
    private String clientId;
    private int status;
    private long createTime;
    private int reqType;
    private AtomicInteger waitDuration = new AtomicInteger(0);

    public NodeRebInfo(String clientId, int waitDuration) {
        this.status = 0;
        this.clientId = clientId;
        this.waitDuration.set(waitDuration);
        this.createTime = System.currentTimeMillis();
        this.reqType = waitDuration <= 0 ? 0 : 1;
    }

    public NodeRebInfo(String clientId, int status, long createTime, int reqType, int waitDuration) {
        this.clientId = clientId;
        this.status = status;
        this.createTime = createTime;
        this.reqType = reqType;
        this.waitDuration.set(waitDuration);
    }

    public String getClientId() {
        return this.clientId;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public int getReqType() {
        return this.reqType;
    }

    public int getWaitDuration() {
        return this.waitDuration.get();
    }

    public int decrAndGetWaitDuration() {
        return this.waitDuration.decrementAndGet();
    }

    public NodeRebInfo clone() {
        return new NodeRebInfo(this.clientId, this.status, this.createTime, this.reqType, this.waitDuration.get());
    }

    public StringBuilder toJsonString(StringBuilder sBuilder) {
        return sBuilder.append("{\"clientId\":\"").append(this.clientId).append("\",\"status\":").append(this.status).append(",\"createTime\":").append(this.createTime).append(",\"reqType\":").append(this.reqType).append(",\"waitDuration\":").append(this.waitDuration.get()).append("}");
    }
}

