/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.web.simplemvc;

import java.io.StringWriter;
import java.io.Writer;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.master.web.simplemvc.RequestContext;
import org.apache.inlong.tubemq.server.master.web.simplemvc.TemplateEngine;
import org.apache.inlong.tubemq.server.master.web.simplemvc.conf.WebConfig;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityTemplateEngine
implements TemplateEngine {
    private final WebConfig config;
    private final VelocityEngine engine;

    public VelocityTemplateEngine(WebConfig config) {
        this.config = config;
        this.engine = new VelocityEngine();
    }

    @Override
    public void init() throws Exception {
        if (TStringUtils.isEmpty((String)this.config.getVelocityConfigFilePath())) {
            this.engine.setProperty("resource.loader.file.path", (Object)this.config.getTemplatePath());
            this.engine.setProperty("resource.loader.file.cache", (Object)false);
            this.engine.setProperty("resource.default_encoding", (Object)"UTF-8");
            this.engine.init();
        } else {
            this.engine.init(this.config.getVelocityConfigFilePath());
        }
    }

    @Override
    public String renderTemplate(String templateName, RequestContext context) throws Exception {
        StringWriter writer = new StringWriter();
        this.renderTemplate(templateName, context, writer);
        return writer.toString();
    }

    @Override
    public void renderTemplate(String templateName, RequestContext context, Writer writer) throws Exception {
        Template t = this.engine.getTemplate(templateName);
        if (t != null) {
            t.merge((Context)new VelocityContext(context.getMap()), writer);
        }
    }
}

