/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.definition;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.workflow.WorkflowAction;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.definition.ConditionNextElement;
import org.apache.inlong.manager.workflow.definition.Element;
import org.apache.inlong.manager.workflow.definition.ServiceTaskType;
import org.apache.inlong.manager.workflow.definition.TaskListenerFactory;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.apache.inlong.manager.workflow.event.EventListener;
import org.apache.inlong.manager.workflow.event.task.TaskEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ServiceTask
extends WorkflowTask {
    private static final Logger log = LoggerFactory.getLogger(ServiceTask.class);
    private static final Set<WorkflowAction> SUPPORTED_ACTIONS = ImmutableSet.of((Object)((Object)WorkflowAction.COMPLETE), (Object)((Object)WorkflowAction.CANCEL), (Object)((Object)WorkflowAction.TERMINATE));
    private final AtomicBoolean isInit = new AtomicBoolean(false);
    private TaskListenerFactory listenerFactory;
    private ServiceTaskType taskType;

    @Override
    public WorkflowAction defaultNextAction() {
        return WorkflowAction.COMPLETE;
    }

    @Override
    protected Set<WorkflowAction> supportedActions() {
        return SUPPORTED_ACTIONS;
    }

    @Override
    public List<Element> getNextList(WorkflowAction action, WorkflowContext context) {
        Preconditions.expectTrue((boolean)this.supportedActions().contains((Object)action), (String)("not support workflow action " + (Object)((Object)action) + ", it in one of " + this.supportedActions()));
        switch (action) {
            case COMPLETE: {
                return super.getNextList(action, context);
            }
            case CANCEL: 
            case TERMINATE: {
                return Collections.singletonList(context.getProcess().getEndEvent());
            }
        }
        throw new WorkflowException("unknown workflow action " + (Object)((Object)action));
    }

    public void addListeners(List<TaskEventListener> listeners) {
        if (CollectionUtils.isEmpty(listeners)) {
            return;
        }
        for (TaskEventListener listener : listeners) {
            if (listener == null) continue;
            this.addListener(listener);
        }
    }

    @Override
    public ServiceTask clone() {
        ServiceTask serviceTask = new ServiceTask();
        serviceTask.setName(this.getName());
        serviceTask.setDisplayName(this.getDisplayName());
        serviceTask.setServiceTaskType(this.taskType);
        serviceTask.setListenerFactory(this.listenerFactory);
        HashMap cloneActionToNextElementMap = Maps.newHashMap();
        this.getActionToNextElementMap().forEach((k, v) -> cloneActionToNextElementMap.put(k, v.stream().map(ele -> {
            try {
                return (ConditionNextElement)ele.clone();
            }
            catch (CloneNotSupportedException e) {
                log.error("clone service task error: ", (Throwable)e);
                return null;
            }
        }).collect(Collectors.toList())));
        serviceTask.setActionToNextElementMap(cloneActionToNextElementMap);
        return serviceTask;
    }

    public void setListenerFactory(TaskListenerFactory factory) {
        this.listenerFactory = factory;
    }

    public void setServiceTaskType(ServiceTaskType type) {
        this.taskType = type;
    }

    public void initListeners(WorkflowContext workflowContext) {
        if (this.isInit.compareAndSet(false, true)) {
            if (this.listenerFactory == null || this.taskType == null) {
                return;
            }
            ArrayList listeners = Lists.newArrayList(this.listenerFactory.get(workflowContext, this.taskType));
            List listenerNames = listeners.stream().map(EventListener::name).collect(Collectors.toList());
            log.info("ServiceTask: [{}] is init for listeners: {}", (Object)this.getName(), listenerNames);
            this.addListeners(listeners);
        } else {
            log.warn("ServiceTask [{}] was already init", (Object)this.getName());
        }
    }
}

