/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.html;

import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.core.Constants;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class HtmlInputType {
    public static final String CHECKBOX_VALUE = "checkbox";
    public static final HtmlInputType CHECKBOX = new HtmlInputType("checkbox");
    public static final String COLOR_VALUE = "color";
    public static final HtmlInputType COLOR = new HtmlInputType("color");
    public static final String DATE_VALUE = "date";
    public static final HtmlInputType DATE = new HtmlInputType("date");
    public static final String DATETIME_LOCAL_VALUE = "datetime-local";
    public static final HtmlInputType DATETIME_LOCAL = new HtmlInputType("datetime-local");
    public static final String EMAIL_VALUE = "email";
    public static final HtmlInputType EMAIL = new HtmlInputType("email");
    public static final String FILE_VALUE = "file";
    public static final HtmlInputType FILE = new HtmlInputType("file");
    public static final String HIDDEN_VALUE = "hidden";
    public static final HtmlInputType HIDDEN = new HtmlInputType("hidden");
    public static final String MONTH_VALUE = "month";
    public static final HtmlInputType MONTH = new HtmlInputType("month");
    public static final String NUMBER_VALUE = "number";
    public static final HtmlInputType NUMBER = new HtmlInputType("number");
    public static final String PASSWORD_VALUE = "password";
    public static final HtmlInputType PASSWORD = new HtmlInputType("password");
    public static final String RADIO_VALUE = "radio";
    public static final HtmlInputType RADIO = new HtmlInputType("radio");
    public static final String RANGE_VALUE = "range";
    public static final HtmlInputType RANGE = new HtmlInputType("range");
    public static final String SEARCH_VALUE = "search";
    public static final HtmlInputType SEARCH = new HtmlInputType("search");
    public static final String TEL_VALUE = "tel";
    public static final HtmlInputType TEL = new HtmlInputType("tel");
    public static final String TEXT_VALUE = "text";
    public static final HtmlInputType TEXT = new HtmlInputType("text");
    public static final String TEXTAREA_VALUE = "textarea";
    public static final HtmlInputType TEXTAREA = new HtmlInputType("textarea");
    public static final String TIME_VALUE = "time";
    public static final HtmlInputType TIME = new HtmlInputType("time");
    public static final String URL_VALUE = "url";
    public static final HtmlInputType URL = new HtmlInputType("url");
    public static final String WEEK_VALUE = "week";
    public static final HtmlInputType WEEK = new HtmlInputType("week");
    private static final Constants CONSTANTS = new Constants(HtmlInputType.class);
    static final Collection<Class<?>> NUMERIC_TYPES = Arrays.asList(Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Short.TYPE, Integer.class, Long.class, Float.class, Double.class, Short.class, BigDecimal.class);
    @JsonValue
    private String value;

    private HtmlInputType(String value) {
        Assert.hasText((String)value, (String)"Value must not be null or empty!");
        this.value = value;
    }

    @Nullable
    public static HtmlInputType of(String value) {
        Assert.hasText((String)value, (String)"Value must not be null or empty!");
        int underscore = value.indexOf(95);
        String lookup = underscore < 0 ? value : value.substring(0, underscore);
        try {
            return (HtmlInputType)CONSTANTS.asObject(lookup);
        }
        catch (Constants.ConstantException o_O) {
            return null;
        }
    }

    @Nullable
    public static HtmlInputType from(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        if (LocalDate.class.equals(type)) {
            return DATE;
        }
        if (LocalDateTime.class.equals(type)) {
            return DATETIME_LOCAL;
        }
        if (NUMERIC_TYPES.contains(type)) {
            return NUMBER;
        }
        if (URI.class.equals(type) || URL.class.equals(type)) {
            return URL;
        }
        if (String.class.equals(type)) {
            return TEXT;
        }
        if (LocalTime.class.equals(type)) {
            return TIME;
        }
        return null;
    }

    public String value() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

