/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.util.Map;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;

public class HeaderLinksResponseEntity<T extends RepresentationModel<?>>
extends ResponseEntity<T> {
    private HeaderLinksResponseEntity(ResponseEntity<T> entity) {
        super(entity.getBody(), (MultiValueMap)HeaderLinksResponseEntity.getHeadersWithLinks(entity), entity.getStatusCode());
        RepresentationModel body = (RepresentationModel)entity.getBody();
        if (body != null) {
            body.removeLinks();
        }
    }

    private HeaderLinksResponseEntity(HttpEntity<T> entity) {
        this(((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(entity.getHeaders())).body(entity.getBody()));
    }

    public static <S extends RepresentationModel<?>> HeaderLinksResponseEntity<S> wrap(HttpEntity<S> entity) {
        Assert.notNull(entity, (String)"Given HttpEntity must not be null!");
        if (entity instanceof ResponseEntity) {
            return new HeaderLinksResponseEntity((ResponseEntity)entity);
        }
        return new HeaderLinksResponseEntity<S>(entity);
    }

    public static <S extends RepresentationModel<?>> HeaderLinksResponseEntity<S> wrap(S entity) {
        Assert.notNull(entity, (String)"ResourceSupport must not be null!");
        return new HeaderLinksResponseEntity(ResponseEntity.ok(entity));
    }

    private static <T extends RepresentationModel<?>> HttpHeaders getHeadersWithLinks(ResponseEntity<T> entity) {
        RepresentationModel body = (RepresentationModel)entity.getBody();
        Links links = body != null ? body.getLinks() : Links.NONE;
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.putAll((Map)entity.getHeaders());
        httpHeaders.add("Link", links.toString());
        return httpHeaders;
    }
}

