/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.dao.interceptor;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.inlong.manager.common.tenant.MultiTenantQuery;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MultiTenantQueryFilter {
    private static final Logger log = LoggerFactory.getLogger(MultiTenantQueryFilter.class);
    private static final String METHOD_FILTER_PATH = "org.apache.inlong.manager.dao.mapper";
    private static final Set<String> METHOD_SET = new HashSet<String>();

    public static boolean isMultiTenantQuery(String methodName) {
        return METHOD_SET.contains(methodName);
    }

    @PostConstruct
    private void init() {
        Reflections methodReflections = new Reflections(METHOD_FILTER_PATH, new Scanner[]{Scanners.MethodsAnnotated});
        Set methodSet = methodReflections.getMethodsAnnotatedWith(MultiTenantQuery.class);
        MultiTenantQueryFilter.markMethods(methodSet);
        Reflections reflections = new Reflections(METHOD_FILTER_PATH, new Scanner[]{Scanners.TypesAnnotated});
        Set clazzSet = reflections.getTypesAnnotatedWith(MultiTenantQuery.class);
        clazzSet.stream().filter(Class::isInterface).forEach(clazz -> {
            MultiTenantQuery annotation = clazz.getAnnotation(MultiTenantQuery.class);
            if (annotation == null || !annotation.with()) {
                return;
            }
            List<Method> methods = Arrays.asList(clazz.getMethods());
            MultiTenantQueryFilter.markMethods(methods);
        });
        log.debug("success to find all methods that support multi-tenant queries, methods={}", METHOD_SET);
    }

    private static void markMethods(Collection<Method> methods) {
        methods.forEach(method -> {
            MultiTenantQuery annotation = method.getAnnotation(MultiTenantQuery.class);
            if (annotation != null && !annotation.with()) {
                METHOD_SET.remove(MultiTenantQueryFilter.getMethodFullName(method));
            } else {
                METHOD_SET.add(MultiTenantQueryFilter.getMethodFullName(method));
            }
        });
    }

    private static String getMethodFullName(Method method) {
        return method.getDeclaringClass().getName() + "." + method.getName();
    }
}

