/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source;

import com.google.common.annotations.VisibleForTesting;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDrivenSource;
import org.apache.flume.conf.Configurable;
import org.apache.flume.conf.Configurables;
import org.apache.flume.instrumentation.SourceCounter;
import org.apache.flume.source.SslContextAwareAbstractSource;
import org.apache.flume.source.SyslogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SyslogTcpSource
extends SslContextAwareAbstractSource
implements EventDrivenSource,
Configurable {
    private static final Logger logger = LoggerFactory.getLogger(SyslogTcpSource.class);
    private int port;
    private String host = null;
    private Integer eventSize;
    private Map<String, String> formaterProp;
    private SourceCounter sourceCounter;
    private Set<String> keepFields;
    private String clientIPHeader;
    private String clientHostnameHeader;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private Channel serverChannel;

    @Override
    public void start() {
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).handler((ChannelHandler)new LoggingHandler(LogLevel.TRACE))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{new SyslogTcpHandler(SyslogTcpSource.this.eventSize, SyslogTcpSource.this.keepFields, SyslogTcpSource.this.formaterProp, SyslogTcpSource.this.clientIPHeader, SyslogTcpSource.this.clientHostnameHeader)});
                    Optional<SSLEngine> engine = SyslogTcpSource.this.getSslEngine(false);
                    engine.ifPresent(sslEngine -> ch.pipeline().addFirst("ssl", (ChannelHandler)new SslHandler(sslEngine)));
                }
            });
            logger.info("Syslog TCP Source starting...");
            this.serverChannel = b.bind(this.host, this.port).sync().channel();
        }
        catch (Exception ex) {
            logger.error("Unable to start Syslog TCP Source", (Throwable)ex);
        }
        this.sourceCounter.start();
        super.start();
    }

    @Override
    public void stop() {
        logger.info("Syslog TCP Source stopping...");
        logger.info("Metrics: {}", (Object)this.sourceCounter);
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        try {
            this.serverChannel.closeFuture().sync();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.sourceCounter.stop();
        super.stop();
    }

    @Override
    public void configure(Context context) {
        this.configureSsl(context);
        Configurables.ensureRequiredNonNull(context, "port");
        this.port = context.getInteger("port");
        this.host = context.getString("host");
        this.eventSize = context.getInteger("eventSize", SyslogUtils.DEFAULT_SIZE);
        this.formaterProp = context.getSubProperties("format.");
        this.keepFields = SyslogUtils.chooseFieldsToKeep(context.getString("keepFields", "none"));
        this.clientIPHeader = context.getString("clientIPHeader");
        this.clientHostnameHeader = context.getString("clientHostnameHeader");
        if (this.sourceCounter == null) {
            this.sourceCounter = new SourceCounter(this.getName());
        }
    }

    @VisibleForTesting
    InetSocketAddress getBoundAddress() {
        SocketAddress localAddress = this.serverChannel.localAddress();
        if (!(localAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Not bound to an internet address");
        }
        return (InetSocketAddress)localAddress;
    }

    @VisibleForTesting
    SourceCounter getSourceCounter() {
        return this.sourceCounter;
    }

    public class SyslogTcpHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        private final SyslogUtils syslogUtils = new SyslogUtils();
        private final String clientIPHeader;
        private final String clientHostnameHeader;

        SyslogTcpHandler(int eventSize, Set<String> keepFields, Map<String, String> formatterProp, String clientIPHeader, String clientHostnameHeader) {
            this.syslogUtils.setEventSize(eventSize);
            this.syslogUtils.addFormats(formatterProp);
            this.syslogUtils.setKeepFields(keepFields);
            this.clientIPHeader = clientIPHeader;
            this.clientHostnameHeader = clientHostnameHeader;
        }

        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf buff) throws Exception {
            while (buff.isReadable()) {
                Event e = this.syslogUtils.extractEvent(buff);
                if (e == null) {
                    logger.debug("Parsed partial event, event will be generated when rest of the event is received.");
                    continue;
                }
                if (this.clientIPHeader != null) {
                    e.getHeaders().put(this.clientIPHeader, SyslogUtils.getIP(ctx.channel().remoteAddress()));
                }
                if (this.clientHostnameHeader != null) {
                    e.getHeaders().put(this.clientHostnameHeader, SyslogUtils.getHostname(ctx.channel().remoteAddress()));
                }
                SyslogTcpSource.this.sourceCounter.incrementEventReceivedCount();
                try {
                    SyslogTcpSource.this.getChannelProcessor().processEvent(e);
                    SyslogTcpSource.this.sourceCounter.incrementEventAcceptedCount();
                }
                catch (ChannelException ex) {
                    logger.error("Error writting to channel, event dropped", (Throwable)ex);
                    SyslogTcpSource.this.sourceCounter.incrementChannelWriteFail();
                }
                catch (RuntimeException ex) {
                    logger.error("Error parsing event from syslog stream, event dropped", (Throwable)ex);
                    SyslogTcpSource.this.sourceCounter.incrementEventReadFail();
                    return;
                }
            }
        }
    }
}

