/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.cli.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.impl.InlongClientImpl;
import org.apache.inlong.manager.client.api.inner.client.ClientFactory;
import org.apache.inlong.manager.common.auth.Authentication;
import org.apache.inlong.manager.common.auth.DefaultAuthentication;
import org.apache.inlong.manager.common.exceptions.BusinessException;

public class ClientUtils {
    private static final String CONFIG_FILE = "application.properties";
    public static ClientFactory clientFactory;
    private static ClientConfiguration configuration;
    private static String serviceUrl;

    public static InlongClientImpl getClient() {
        ClientUtils.initClientConfiguration();
        return new InlongClientImpl(serviceUrl, configuration);
    }

    public static void initClientFactory() {
        clientFactory = org.apache.inlong.manager.client.api.util.ClientUtils.getClientFactory((ClientConfiguration)ClientUtils.getClient().getConfiguration());
    }

    public static String readFile(File file) {
        if (!file.exists() || file.length() == 0L) {
            throw new BusinessException("File does not exist or is empty.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            int ch;
            while ((ch = ((Reader)reader).read()) != -1) {
                stringBuilder.append((char)ch);
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        return stringBuilder.toString();
    }

    private static void initClientConfiguration() {
        Properties properties = new Properties();
        String path = Thread.currentThread().getContextClassLoader().getResource("").getPath() + CONFIG_FILE;
        try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]));){
            properties.load(inputStream);
            serviceUrl = properties.getProperty("server.host") + ":" + properties.getProperty("server.port");
            String user = properties.getProperty("default.admin.user");
            String password = properties.getProperty("default.admin.password");
            configuration = new ClientConfiguration();
            configuration.setAuthentication((Authentication)new DefaultAuthentication(user, password));
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }
}

