/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.transform;

import io.swagger.annotations.ApiModel;
import java.util.List;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.stream.StreamTransform;
import org.apache.inlong.manager.pojo.transform.TransformDefinition;

@ApiModel(value="StreamTransform with multiple pre stream nodes, such as join")
public class MultiDependencyTransform
extends StreamTransform {
    public MultiDependencyTransform(String transformName, TransformDefinition transformDefinition, String ... preNodes) {
        Preconditions.expectNotNull((Object)transformDefinition, (String)"transform definition cannot be null");
        this.transformDefinition = transformDefinition;
        Preconditions.expectNotBlank((String)transformName, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"transform name cannot be empty");
        this.transformName = transformName;
        Preconditions.expectNoNullElements((Object[])preNodes, (String)"pre nodes cannot be null");
        for (String preNode : preNodes) {
            this.addPre(preNode);
        }
    }

    public MultiDependencyTransform(String transformName, TransformDefinition transformDefinition, List<String> preNodes, List<String> postNodes) {
        this(transformName, transformDefinition, preNodes.toArray(new String[0]));
        if (postNodes != null) {
            for (String postNode : postNodes) {
                this.addPost(postNode);
            }
        }
    }

    public MultiDependencyTransform() {
    }
}

