/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.inlong.tubemq.corebase.utils.DateTimeConvertUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;

public class Message
implements Serializable {
    static final long serialVersionUID = -1L;
    protected int flag;
    private long indexId;
    private String topic;
    private byte[] data;
    private String attribute;
    private transient String msgType;
    private transient String msgTime;
    private transient String sysAttributes;

    public Message(String topic, byte[] data) {
        this.topic = topic;
        this.data = data;
    }

    protected Message(long indexId, String topic, byte[] data, String attribute, int flag) {
        this.indexId = indexId;
        this.topic = topic;
        this.data = data;
        this.attribute = attribute;
        this.flag = flag;
    }

    public int getFlag() {
        return this.flag;
    }

    public String getMsgType() {
        if (TStringUtils.isBlank(this.msgType) && TStringUtils.isNotBlank(this.attribute) && this.attribute.contains("$msgType$")) {
            this.parseSystemHeader();
        }
        return this.msgType;
    }

    public String getMsgTime() {
        if (TStringUtils.isBlank(this.msgTime) && TStringUtils.isNotBlank(this.attribute) && this.attribute.contains("$msgTime$")) {
            this.parseSystemHeader();
        }
        return this.msgTime;
    }

    public void putSystemHeader(String msgType, String msgTime) {
        this.msgType = null;
        this.msgTime = null;
        this.sysAttributes = null;
        StringBuilder strBuff = new StringBuilder(512);
        if (TStringUtils.isNotBlank(msgType)) {
            this.msgType = msgType.trim();
            this.sysAttributes = strBuff.append("$msgType$").append("=").append(this.msgType).toString();
            strBuff.delete(0, strBuff.length());
        }
        if (TStringUtils.isNotBlank(msgTime)) {
            String tmpMsgTime = msgTime.trim();
            if (tmpMsgTime.length() != DateTimeConvertUtils.LENGTH_YYYYMMDDHHMM) {
                throw new IllegalArgumentException(strBuff.append("Illegal parameter: msgTime's value must '").append("yyyyMMddHHmm").append("' format and length must equal ").append(DateTimeConvertUtils.LENGTH_YYYYMMDDHHMM).toString());
            }
            try {
                DateTimeConvertUtils.yyyyMMddHHmm2ms(tmpMsgTime);
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException(strBuff.append("Illegal parameter: msgTime's value parse failure: ").append(ex.getMessage()).toString());
            }
            this.msgTime = tmpMsgTime;
            if (TStringUtils.isNotEmpty(this.sysAttributes)) {
                strBuff.append(this.sysAttributes).append(",");
            }
            this.sysAttributes = strBuff.append("$msgTime$").append("=").append(this.msgTime).toString();
            strBuff.delete(0, strBuff.length());
        }
        if (TStringUtils.isNotEmpty(this.sysAttributes)) {
            strBuff.append(this.sysAttributes);
        }
        if (TStringUtils.isNotBlank(this.attribute)) {
            String[] strAttrs;
            for (String strAttrItem : strAttrs = this.attribute.split(",")) {
                if (strAttrItem == null || strAttrItem.contains("$msgType$") || strAttrItem.contains("$msgTime$")) continue;
                if (strBuff.length() == 0) {
                    strBuff.append(strAttrItem);
                    continue;
                }
                strBuff.append(",").append(strAttrItem);
            }
        }
        this.attribute = strBuff.toString();
    }

    public boolean hasAttribute() {
        return this.attribute != null;
    }

    public long getIndexId() {
        return this.indexId;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topicName) {
        this.topic = topicName;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void clearAttribute() {
        this.attribute = "";
    }

    public String getAttribute() {
        return this.attribute;
    }

    public String getAttrValue(String keyVal) {
        String[] strAttrs;
        if (TStringUtils.isBlank(keyVal)) {
            throw new IllegalArgumentException("keyVal's value is blank!");
        }
        if (TStringUtils.isBlank(this.attribute)) {
            return null;
        }
        for (String strAttrItem : strAttrs = this.attribute.split(",")) {
            String[] strItems;
            if (!TStringUtils.isNotBlank(strAttrItem) || (strItems = strAttrItem.split("=")).length <= 1 || TStringUtils.isBlank(strItems[0]) || !keyVal.equals(strItems[0])) continue;
            return strItems[1];
        }
        return null;
    }

    public void setAttrKeyVal(String keyVal, String valueVal) {
        String[] strAttrs;
        if (TStringUtils.isBlank(keyVal)) {
            throw new IllegalArgumentException("keyVal's value is blank!");
        }
        if (TStringUtils.isBlank(valueVal)) {
            throw new IllegalArgumentException("valueVal's value is blank!");
        }
        if (keyVal.contains("$msgType$") || keyVal.contains("$msgTime$") || valueVal.contains("$msgType$") || valueVal.contains("$msgTime$")) {
            throw new IllegalArgumentException(new StringBuilder(512).append("System Headers(").append("$msgType$").append(",").append("$msgTime$").append(") are reserved tokens, can't include in keyVal or valueVal!").toString());
        }
        if (keyVal.contains(",") || keyVal.contains("=") || valueVal.contains(",") || valueVal.contains("=")) {
            throw new IllegalArgumentException(new StringBuilder(512).append("(").append(",").append(",").append("=").append(") are reserved tokens, can't include in keyVal or valueVal!").toString());
        }
        if (TStringUtils.isBlank(this.attribute)) {
            this.attribute = keyVal + "=" + valueVal;
            return;
        }
        int count = 0;
        StringBuilder sBuilder = new StringBuilder(512);
        for (String strAttrItem : strAttrs = this.attribute.split(",")) {
            String[] strItems;
            if (!TStringUtils.isNotBlank(strAttrItem) || (strItems = strAttrItem.split("=")).length <= 1 || TStringUtils.isBlank(strItems[0]) || keyVal.equals(strItems[0])) continue;
            if (count++ > 0) {
                sBuilder.append(",");
            }
            sBuilder.append(strAttrItem);
        }
        if (count > 0) {
            sBuilder.append(",");
        }
        sBuilder.append(keyVal).append("=").append(valueVal);
        this.attribute = sBuilder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attribute == null ? 0 : this.attribute.hashCode());
        result = 31 * result + Arrays.hashCode(this.data);
        result = 31 * result + (int)(this.indexId ^ this.indexId >>> 32);
        result = 31 * result + (this.topic == null ? 0 : this.topic.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Message other = (Message)obj;
        if (this.attribute == null ? other.attribute != null : !this.attribute.equals(other.attribute)) {
            return false;
        }
        if (!Arrays.equals(this.data, other.data)) {
            return false;
        }
        if (this.indexId != other.indexId) {
            return false;
        }
        return !(this.topic == null ? other.topic != null : !this.topic.equals(other.topic));
    }

    private void parseSystemHeader() {
        if (TStringUtils.isBlank(this.attribute)) {
            return;
        }
        if (this.attribute.contains("$msgType$") || this.attribute.contains("$msgTime$")) {
            String[] strAttrs;
            for (String strAttrItem : strAttrs = this.attribute.split(",")) {
                String[] strItems;
                if (!TStringUtils.isNotBlank(strAttrItem)) continue;
                if (strAttrItem.contains("$msgType$")) {
                    strItems = strAttrItem.split("=");
                    if (strItems.length <= 1) continue;
                    this.msgType = strItems[1];
                    continue;
                }
                if (!strAttrItem.contains("$msgTime$") || (strItems = strAttrItem.split("=")).length <= 1) continue;
                try {
                    DateTimeConvertUtils.yyyyMMddHHmm2ms(strItems[1]);
                    this.msgTime = strItems[1];
                }
                catch (Throwable ex) {
                    this.msgTime = "";
                }
            }
            if (TStringUtils.isNotBlank(this.msgType)) {
                this.sysAttributes = "$msgType$=" + this.msgType;
            }
            if (TStringUtils.isNotBlank(this.msgTime)) {
                this.sysAttributes = TStringUtils.isBlank(this.sysAttributes) ? "$msgTime$=" + this.msgTime : this.sysAttributes + ",$msgTime$=" + this.msgTime;
            }
        }
    }
}

