/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.policies;

import org.apache.inlong.tubemq.corebase.policies.FlowCtrlResult;
import org.apache.inlong.tubemq.corebase.policies.SSDCtrlResult;

public class FlowCtrlItem {
    private int type = 0;
    private int startTime = -2;
    private int endTime = -2;
    private long dltInM = -2L;
    private long dataLtInSZ = -2L;
    private int freqLtInMs = -2;
    private int zeroCnt = -2;

    public FlowCtrlItem(int type, int startTime, int endTime, long dltInM, long dataLtInSZ, int freqLtInMs) {
        this.type = type;
        this.startTime = startTime;
        this.endTime = endTime;
        this.dltInM = dltInM;
        this.dataLtInSZ = dataLtInSZ;
        this.freqLtInMs = freqLtInMs;
    }

    public FlowCtrlItem(int type, int normFreqLtInMs, int filterFreqInMs, int minDataFilterFreqInMs) {
        this.type = type;
        this.freqLtInMs = filterFreqInMs;
        this.dataLtInSZ = normFreqLtInMs;
        this.zeroCnt = minDataFilterFreqInMs;
    }

    public FlowCtrlItem(int type, int zeroCnt, int freqLtInMs) {
        this.type = type;
        this.freqLtInMs = freqLtInMs;
        this.zeroCnt = zeroCnt;
    }

    public FlowCtrlItem(int type, int startTime, int endTime, long dltStartInM, long dltEndInM) {
        this.type = type;
        this.startTime = startTime;
        this.endTime = endTime;
        this.dltInM = dltStartInM;
        this.dataLtInSZ = dltEndInM;
    }

    public SSDCtrlResult getSSDStartDltProc(int currH, int currM) {
        if (this.type != 2) {
            return new SSDCtrlResult(-2L, -2L);
        }
        int curTime = currH * 100 + currM;
        if (curTime < this.startTime || curTime > this.endTime) {
            return new SSDCtrlResult(-2L, -2L);
        }
        return new SSDCtrlResult(this.dltInM, this.dataLtInSZ);
    }

    public int getFreLimit(int msgZeroCount) {
        if (this.type != 1) {
            return -2;
        }
        if (msgZeroCount >= this.zeroCnt) {
            return this.freqLtInMs;
        }
        return -2;
    }

    public FlowCtrlResult getDataLimit(long dltInM, int currH, int currM) {
        if (this.type != 0 || dltInM <= this.dltInM) {
            return null;
        }
        int curTime = currH * 100 + currM;
        if (curTime < this.startTime || curTime > this.endTime) {
            return null;
        }
        return new FlowCtrlResult(this.dataLtInSZ, this.freqLtInMs);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FlowCtrlItem other = (FlowCtrlItem)obj;
        return this.type == other.type && this.startTime == other.startTime && this.endTime == other.endTime && this.dataLtInSZ == other.dataLtInSZ && this.freqLtInMs == other.freqLtInMs && this.zeroCnt == other.zeroCnt;
    }

    public int getType() {
        return this.type;
    }

    public int getStartTime() {
        return this.startTime;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public long getDltInM() {
        return this.dltInM;
    }

    public long getDataLtInSZ() {
        return this.dataLtInSZ;
    }

    public int getFreqLtInMs() {
        return this.freqLtInMs;
    }

    public int getZeroCnt() {
        return this.zeroCnt;
    }

    public StringBuilder toJsonString(StringBuilder sBuilder) {
        switch (this.type) {
            case 1: {
                return sBuilder.append("{\"zeroCnt\":").append(this.zeroCnt).append(",\"freqInMs\":").append(this.freqLtInMs).append("}");
            }
            case 2: {
                return sBuilder.append("{\"start\":\"").append(String.format("%02d", this.startTime / 100)).append(":").append(String.format("%02d", this.startTime % 100)).append("\",\"end\":\"").append(String.format("%02d", this.endTime / 100)).append(":").append(String.format("%02d", this.endTime % 100)).append("\",\"dltStInM\":").append(this.dltInM / 1024L / 1024L).append(",\"dltEdInM\":").append(this.dataLtInSZ / 1024L / 1024L).append("}");
            }
            case 3: {
                return sBuilder.append("{\"normFreqInMs\":").append((int)this.dataLtInSZ).append(",\"filterFreqInMs\":").append(this.freqLtInMs).append(",\"minDataFilterFreqInMs\":").append(this.zeroCnt).append("}");
            }
        }
        return sBuilder.append("{\"start\":\"").append(String.format("%02d", this.startTime / 100)).append(":").append(String.format("%02d", this.startTime % 100)).append("\",\"end\":\"").append(String.format("%02d", this.endTime / 100)).append(":").append(String.format("%02d", this.endTime % 100)).append("\",\"dltInM\":").append(this.dltInM).append(",\"limitInM\":").append(this.dataLtInSZ / 1024L / 1024L).append(",\"freqInMs\":").append(this.freqLtInMs).append("}");
    }
}

