/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.OperatorBoundary;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.SpatialReference;
import java.math.BigDecimal;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.function.Deterministic;
import org.apache.calcite.linq4j.function.Hints;
import org.apache.calcite.linq4j.function.SemiStrict;
import org.apache.calcite.linq4j.function.Strict;
import org.apache.calcite.runtime.Geometries;
import org.apache.calcite.runtime.HilbertCurve2D;

@Deterministic
@Strict
public class GeoFunctions {
    private GeoFunctions() {
    }

    public static String ST_AsText(Geometries.Geom g) {
        return GeoFunctions.ST_AsWKT(g);
    }

    public static String ST_AsWKT(Geometries.Geom g) {
        return GeometryEngine.geometryToWkt(g.g(), 0);
    }

    public static Geometries.Geom ST_GeomFromText(String s) {
        return GeoFunctions.ST_GeomFromText(s, 0);
    }

    public static Geometries.Geom ST_GeomFromText(String s, int srid) {
        Geometry g = GeometryEngine.geometryFromWkt(s, 0, Geometry.Type.Unknown);
        return Geometries.bind(g, srid);
    }

    public static Geometries.Geom ST_LineFromText(String s) {
        return GeoFunctions.ST_GeomFromText(s, 0);
    }

    public static Geometries.Geom ST_LineFromText(String wkt, int srid) {
        Geometry g = GeometryEngine.geometryFromWkt(wkt, 0, Geometry.Type.Line);
        return Geometries.bind(g, srid);
    }

    public static Geometries.Geom ST_MPointFromText(String s) {
        return GeoFunctions.ST_GeomFromText(s, 0);
    }

    public static Geometries.Geom ST_MPointFromText(String wkt, int srid) {
        Geometry g = GeometryEngine.geometryFromWkt(wkt, 0, Geometry.Type.MultiPoint);
        return Geometries.bind(g, srid);
    }

    public static Geometries.Geom ST_PointFromText(String s) {
        return GeoFunctions.ST_GeomFromText(s, 0);
    }

    public static Geometries.Geom ST_PointFromText(String wkt, int srid) {
        Geometry g = GeometryEngine.geometryFromWkt(wkt, 0, Geometry.Type.Point);
        return Geometries.bind(g, srid);
    }

    public static Geometries.Geom ST_PolyFromText(String s) {
        return GeoFunctions.ST_GeomFromText(s, 0);
    }

    public static Geometries.Geom ST_PolyFromText(String wkt, int srid) {
        Geometry g = GeometryEngine.geometryFromWkt(wkt, 0, Geometry.Type.Polygon);
        return Geometries.bind(g, srid);
    }

    public static Geometries.Geom ST_MLineFromText(String s) {
        return GeoFunctions.ST_GeomFromText(s, 0);
    }

    public static Geometries.Geom ST_MLineFromText(String wkt, int srid) {
        Geometry g = GeometryEngine.geometryFromWkt(wkt, 0, Geometry.Type.Unknown);
        return Geometries.bind(g, srid);
    }

    public static Geometries.Geom ST_MPolyFromText(String s) {
        return GeoFunctions.ST_GeomFromText(s, 0);
    }

    public static Geometries.Geom ST_MPolyFromText(String wkt, int srid) {
        Geometry g = GeometryEngine.geometryFromWkt(wkt, 0, Geometry.Type.Unknown);
        return Geometries.bind(g, srid);
    }

    private static void ST_MakeGrid(Geometries.Geom geom, BigDecimal deltaX, BigDecimal deltaY) {
    }

    private static void ST_MakeGridPoints(Geometries.Geom geom, BigDecimal deltaX, BigDecimal deltaY) {
    }

    public static Geometries.Geom ST_MakeEnvelope(BigDecimal xMin, BigDecimal yMin, BigDecimal xMax, BigDecimal yMax, int srid) {
        return GeoFunctions.ST_GeomFromText("POLYGON((" + xMin + " " + yMin + ", " + xMin + " " + yMax + ", " + xMax + " " + yMax + ", " + xMax + " " + yMin + ", " + xMin + " " + yMin + "))", srid);
    }

    public static Geometries.Geom ST_MakeEnvelope(BigDecimal xMin, BigDecimal yMin, BigDecimal xMax, BigDecimal yMax) {
        return GeoFunctions.ST_MakeEnvelope(xMin, yMin, xMax, yMax, 0);
    }

    @Hints(value={"SqlKind:ST_MAKE_LINE"})
    public static Geometries.Geom ST_MakeLine(Geometries.Geom geom1, Geometries.Geom geom2) {
        return Geometries.makeLine(geom1, geom2);
    }

    @Hints(value={"SqlKind:ST_MAKE_LINE"})
    public static Geometries.Geom ST_MakeLine(Geometries.Geom geom1, Geometries.Geom geom2, Geometries.Geom geom3) {
        return Geometries.makeLine(geom1, geom2, geom3);
    }

    @Hints(value={"SqlKind:ST_MAKE_LINE"})
    public static Geometries.Geom ST_MakeLine(Geometries.Geom geom1, Geometries.Geom geom2, Geometries.Geom geom3, Geometries.Geom geom4) {
        return Geometries.makeLine(geom1, geom2, geom3, geom4);
    }

    @Hints(value={"SqlKind:ST_MAKE_LINE"})
    public static Geometries.Geom ST_MakeLine(Geometries.Geom geom1, Geometries.Geom geom2, Geometries.Geom geom3, Geometries.Geom geom4, Geometries.Geom geom5) {
        return Geometries.makeLine(geom1, geom2, geom3, geom4, geom5);
    }

    @Hints(value={"SqlKind:ST_MAKE_LINE"})
    public static Geometries.Geom ST_MakeLine(Geometries.Geom geom1, Geometries.Geom geom2, Geometries.Geom geom3, Geometries.Geom geom4, Geometries.Geom geom5, Geometries.Geom geom6) {
        return Geometries.makeLine(geom1, geom2, geom3, geom4, geom5, geom6);
    }

    @Hints(value={"SqlKind:ST_POINT"})
    public static Geometries.Geom ST_MakePoint(BigDecimal x, BigDecimal y) {
        return GeoFunctions.ST_Point(x, y);
    }

    @Hints(value={"SqlKind:ST_POINT3"})
    public static Geometries.Geom ST_MakePoint(BigDecimal x, BigDecimal y, BigDecimal z) {
        return GeoFunctions.ST_Point(x, y, z);
    }

    @Hints(value={"SqlKind:ST_POINT"})
    public static Geometries.Geom ST_Point(BigDecimal x, BigDecimal y) {
        return Geometries.point(x.doubleValue(), y.doubleValue());
    }

    @Hints(value={"SqlKind:ST_POINT3"})
    public static Geometries.Geom ST_Point(BigDecimal x, BigDecimal y, BigDecimal z) {
        Point g = new Point(x.doubleValue(), y.doubleValue(), z.doubleValue());
        return new Geometries.SimpleGeom(g);
    }

    public static boolean ST_Is3D(Geometries.Geom geom) {
        return geom.g().hasZ();
    }

    public static Double ST_X(Geometries.Geom geom) {
        return geom.g() instanceof Point ? Double.valueOf(((Point)geom.g()).getX()) : null;
    }

    public static Double ST_Y(Geometries.Geom geom) {
        return geom.g() instanceof Point ? Double.valueOf(((Point)geom.g()).getY()) : null;
    }

    public static Double ST_Z(Geometries.Geom geom) {
        return geom.g().getDescription().hasZ() && geom.g() instanceof Point ? Double.valueOf(((Point)geom.g()).getZ()) : null;
    }

    public static Geometries.Geom ST_Boundary(Geometries.Geom geom) {
        OperatorBoundary op = OperatorBoundary.local();
        Geometry result = op.execute(geom.g(), null);
        return geom.wrap(result);
    }

    public static double ST_Distance(Geometries.Geom geom1, Geometries.Geom geom2) {
        return GeometryEngine.distance(geom1.g(), geom2.g(), geom1.sr());
    }

    public static String ST_GeometryType(Geometries.Geom geom) {
        return Geometries.type(geom.g()).name();
    }

    public static int ST_GeometryTypeCode(Geometries.Geom geom) {
        return Geometries.type((Geometry)geom.g()).code;
    }

    public static Geometries.Geom ST_Envelope(Geometries.Geom geom) {
        Envelope env = Geometries.envelope(geom.g());
        return geom.wrap(env);
    }

    @Hints(value={"SqlKind:ST_CONTAINS"})
    public static boolean ST_Contains(Geometries.Geom geom1, Geometries.Geom geom2) {
        return GeometryEngine.contains(geom1.g(), geom2.g(), geom1.sr());
    }

    public static boolean ST_ContainsProperly(Geometries.Geom geom1, Geometries.Geom geom2) {
        return GeometryEngine.contains(geom1.g(), geom2.g(), geom1.sr()) && !GeometryEngine.crosses(geom1.g(), geom2.g(), geom1.sr());
    }

    private static boolean ST_Covers(Geometries.Geom geom1, Geometries.Geom geom2) {
        throw Geometries.todo();
    }

    public static boolean ST_Crosses(Geometries.Geom geom1, Geometries.Geom geom2) {
        return GeometryEngine.crosses(geom1.g(), geom2.g(), geom1.sr());
    }

    public static boolean ST_Disjoint(Geometries.Geom geom1, Geometries.Geom geom2) {
        return GeometryEngine.disjoint(geom1.g(), geom2.g(), geom1.sr());
    }

    public static boolean ST_EnvelopesIntersect(Geometries.Geom geom1, Geometries.Geom geom2) {
        Envelope e1 = Geometries.envelope(geom1.g());
        Envelope e2 = Geometries.envelope(geom2.g());
        return Geometries.intersects(e1, e2, geom1.sr());
    }

    public static boolean ST_Equals(Geometries.Geom geom1, Geometries.Geom geom2) {
        return GeometryEngine.equals(geom1.g(), geom2.g(), geom1.sr());
    }

    public static boolean ST_Intersects(Geometries.Geom geom1, Geometries.Geom geom2) {
        Geometry g1 = geom1.g();
        Geometry g2 = geom2.g();
        SpatialReference sr = geom1.sr();
        return Geometries.intersects(g1, g2, sr);
    }

    public static boolean ST_OrderingEquals(Geometries.Geom geom1, Geometries.Geom geom2) {
        return GeometryEngine.equals(geom1.g(), geom2.g(), geom1.sr());
    }

    public static boolean ST_Overlaps(Geometries.Geom geom1, Geometries.Geom geom2) {
        return GeometryEngine.overlaps(geom1.g(), geom2.g(), geom1.sr());
    }

    public static boolean ST_Touches(Geometries.Geom geom1, Geometries.Geom geom2) {
        return GeometryEngine.touches(geom1.g(), geom2.g(), geom1.sr());
    }

    public static boolean ST_Within(Geometries.Geom geom1, Geometries.Geom geom2) {
        return GeometryEngine.within(geom1.g(), geom2.g(), geom1.sr());
    }

    @Hints(value={"SqlKind:ST_DWITHIN"})
    public static boolean ST_DWithin(Geometries.Geom geom1, Geometries.Geom geom2, double distance) {
        double distance1 = GeometryEngine.distance(geom1.g(), geom2.g(), geom1.sr());
        return distance1 <= distance;
    }

    public static Geometries.Geom ST_Buffer(Geometries.Geom geom, double distance) {
        Polygon g = GeometryEngine.buffer(geom.g(), geom.sr(), distance);
        return geom.wrap(g);
    }

    public static Geometries.Geom ST_Buffer(Geometries.Geom geom, double distance, int quadSegs) {
        throw Geometries.todo();
    }

    public static Geometries.Geom ST_Buffer(Geometries.Geom geom, double bufferSize, String style) {
        int equals;
        int quadSegCount = 8;
        Geometries.CapStyle endCapStyle = Geometries.CapStyle.ROUND;
        Geometries.JoinStyle joinStyle = Geometries.JoinStyle.ROUND;
        float mitreLimit = 5.0f;
        int i = 0;
        block13: while ((equals = style.indexOf(61, i)) >= 0) {
            int space = style.indexOf(32, equals);
            if (space < 0) {
                space = style.length();
            }
            String name = style.substring(i, equals);
            String value = style.substring(equals + 1, space);
            switch (name) {
                case "quad_segs": {
                    quadSegCount = Integer.valueOf(value);
                    break;
                }
                case "endcap": {
                    endCapStyle = Geometries.CapStyle.of(value);
                    break;
                }
                case "join": {
                    joinStyle = Geometries.JoinStyle.of(value);
                    break;
                }
                case "mitre_limit": 
                case "miter_limit": {
                    mitreLimit = Float.parseFloat(value);
                    break;
                }
            }
            for (i = space; i < style.length(); ++i) {
                if (style.charAt(i) != ' ') continue block13;
            }
        }
        return Geometries.buffer(geom, bufferSize, quadSegCount, endCapStyle, joinStyle, mitreLimit);
    }

    public static Geometries.Geom ST_Union(Geometries.Geom geom1, Geometries.Geom geom2) {
        SpatialReference sr = geom1.sr();
        Geometry g = GeometryEngine.union(new Geometry[]{geom1.g(), geom2.g()}, sr);
        return Geometries.bind(g, sr);
    }

    @SemiStrict
    public static Geometries.Geom ST_Union(Geometries.Geom geomCollection) {
        SpatialReference sr = geomCollection.sr();
        Geometry g = GeometryEngine.union(new Geometry[]{geomCollection.g()}, sr);
        return Geometries.bind(g, sr);
    }

    public static Geometries.Geom ST_Transform(Geometries.Geom geom, int srid) {
        return geom.transform(srid);
    }

    public static Geometries.Geom ST_SetSRID(Geometries.Geom geom, int srid) {
        return geom.transform(srid);
    }

    @Hints(value={"SqlKind:HILBERT"})
    public static Long hilbert(Geometries.Geom geom) {
        Geometry g = geom.g();
        if (g instanceof Point) {
            double x = ((Point)g).getX();
            double y = ((Point)g).getY();
            return new HilbertCurve2D(8).toIndex(x, y);
        }
        return null;
    }

    @Hints(value={"SqlKind:HILBERT"})
    public static long hilbert(BigDecimal x, BigDecimal y) {
        return new HilbertCurve2D(8).toIndex(x.doubleValue(), y.doubleValue());
    }

    public static class GridEnumerable
    extends AbstractEnumerable<Object[]> {
        private final Envelope envelope;
        private final boolean point;
        private final double deltaX;
        private final double deltaY;
        private final double minX;
        private final double minY;
        private final int baseX;
        private final int baseY;
        private final int spanX;
        private final int spanY;
        private final int area;

        public GridEnumerable(Envelope envelope, BigDecimal deltaX, BigDecimal deltaY, boolean point) {
            this.envelope = envelope;
            this.deltaX = deltaX.doubleValue();
            this.deltaY = deltaY.doubleValue();
            this.point = point;
            this.spanX = (int)Math.floor((envelope.getXMax() - envelope.getXMin()) / this.deltaX) + 1;
            this.baseX = (int)Math.floor(envelope.getXMin() / this.deltaX);
            this.minX = this.deltaX * (double)this.baseX;
            this.spanY = (int)Math.floor((envelope.getYMax() - envelope.getYMin()) / this.deltaY) + 1;
            this.baseY = (int)Math.floor(envelope.getYMin() / this.deltaY);
            this.minY = this.deltaY * (double)this.baseY;
            this.area = this.spanX * this.spanY;
        }

        @Override
        public Enumerator<Object[]> enumerator() {
            return new Enumerator<Object[]>(){
                int id = -1;

                @Override
                public Object[] current() {
                    Geometries.Geom geom;
                    int x = this.id % spanX;
                    int y = this.id / spanX;
                    if (point) {
                        double xCurrent = minX + ((double)x + 0.5) * deltaX;
                        double yCurrent = minY + ((double)y + 0.5) * deltaY;
                        geom = GeoFunctions.ST_MakePoint(BigDecimal.valueOf(xCurrent), BigDecimal.valueOf(yCurrent));
                    } else {
                        Polygon polygon = new Polygon();
                        double left = minX + (double)x * deltaX;
                        double right = left + deltaX;
                        double bottom = minY + (double)y * deltaY;
                        double top = bottom + deltaY;
                        Polyline polyline = new Polyline();
                        polyline.addSegment(new Line(left, bottom, right, bottom), true);
                        polyline.addSegment(new Line(right, bottom, right, top), false);
                        polyline.addSegment(new Line(right, top, left, top), false);
                        polyline.addSegment(new Line(left, top, left, bottom), false);
                        polygon.add(polyline, false);
                        geom = new Geometries.SimpleGeom(polygon);
                    }
                    return new Object[]{geom, this.id, x + 1, y + 1, baseX + x, baseY + y};
                }

                @Override
                public boolean moveNext() {
                    return ++this.id < area;
                }

                @Override
                public void reset() {
                    this.id = -1;
                }

                @Override
                public void close() {
                }
            };
        }
    }
}

